/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.lang.Nullable;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;

public class CompositeTransactionAttributeSource
implements TransactionAttributeSource,
Serializable {
    private final TransactionAttributeSource[] transactionAttributeSources;

    public CompositeTransactionAttributeSource(TransactionAttributeSource ... transactionAttributeSources) {
        Assert.notNull((Object)transactionAttributeSources, "TransactionAttributeSource array must not be null");
        this.transactionAttributeSources = transactionAttributeSources;
    }

    public final TransactionAttributeSource[] getTransactionAttributeSources() {
        return this.transactionAttributeSources;
    }

    @Override
    public boolean isCandidateClass(Class<?> targetClass) {
        for (TransactionAttributeSource source2 : this.transactionAttributeSources) {
            if (!source2.isCandidateClass(targetClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public TransactionAttribute getTransactionAttribute(Method method, @Nullable Class<?> targetClass) {
        for (TransactionAttributeSource source2 : this.transactionAttributeSources) {
            TransactionAttribute attr = source2.getTransactionAttribute(method, targetClass);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }
}

