/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

class VavrCollections {
    VavrCollections() {
    }

    public static enum FromJavaConverter implements ConditionalGenericConverter
    {
        INSTANCE{

            @Override
            @NonNull
            public java.util.Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                return CONVERTIBLE_PAIRS;
            }

            @Override
            public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                if (sourceType.isCollection() && Map.class.isAssignableFrom(targetType.getType())) {
                    return false;
                }
                return !sourceType.isMap() || Map.class.isAssignableFrom(targetType.getType()) || targetType.getType().equals(Traversable.class);
            }

            @Override
            @Nullable
            public Object convert(@Nullable Object source2, TypeDescriptor sourceDescriptor, TypeDescriptor targetDescriptor) {
                Class<?> targetType = targetDescriptor.getType();
                if (Seq.class.isAssignableFrom(targetType)) {
                    return io.vavr.collection.List.ofAll((Iterable)source2);
                }
                if (Set.class.isAssignableFrom(targetType)) {
                    return LinkedHashSet.ofAll((Iterable)source2);
                }
                if (Map.class.isAssignableFrom(targetType)) {
                    return LinkedHashMap.ofAll((java.util.Map)source2);
                }
                if (source2 instanceof List) {
                    return io.vavr.collection.List.ofAll((Iterable)source2);
                }
                if (source2 instanceof java.util.Set) {
                    return LinkedHashSet.ofAll((Iterable)source2);
                }
                if (source2 instanceof java.util.Map) {
                    return LinkedHashMap.ofAll((java.util.Map)source2);
                }
                return source2;
            }
        };

        private static final java.util.Set<GenericConverter.ConvertiblePair> CONVERTIBLE_PAIRS;

        static {
            HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>();
            pairs.add(new GenericConverter.ConvertiblePair(Collection.class, Traversable.class));
            pairs.add(new GenericConverter.ConvertiblePair(java.util.Map.class, Traversable.class));
            CONVERTIBLE_PAIRS = Collections.unmodifiableSet(pairs);
        }
    }

    public static enum ToJavaConverter implements Converter<Object, Object>
    {
        INSTANCE;


        public QueryExecutionConverters.WrapperType getWrapperType() {
            return QueryExecutionConverters.WrapperType.multiValue(Traversable.class);
        }

        @Override
        @NonNull
        public Object convert(Object source2) {
            if (source2 instanceof Seq) {
                return ((Seq)source2).asJava();
            }
            if (source2 instanceof Map) {
                return ((Map)source2).toJavaMap();
            }
            if (source2 instanceof Set) {
                return ((Set)source2).toJavaSet();
            }
            throw new IllegalArgumentException("Unsupported Vavr collection " + source2.getClass());
        }
    }
}

