/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.Slice;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ResultProcessor {
    private final QueryMethod method;
    private final ProjectingConverter converter;
    private final ProjectionFactory factory;
    private final ReturnedType type;

    ResultProcessor(QueryMethod method, ProjectionFactory factory) {
        this(method, factory, method.getReturnedObjectType());
    }

    private ResultProcessor(QueryMethod method, ProjectionFactory factory, Class<?> type) {
        Assert.notNull((Object)method, "QueryMethod must not be null!");
        Assert.notNull((Object)factory, "ProjectionFactory must not be null!");
        Assert.notNull(type, "Type must not be null!");
        this.method = method;
        this.type = ReturnedType.of(type, method.getDomainClass(), factory);
        this.converter = new ProjectingConverter(this.type, factory);
        this.factory = factory;
    }

    private ResultProcessor(QueryMethod method, ProjectingConverter converter, ProjectionFactory factory, ReturnedType type) {
        this.method = method;
        this.converter = converter;
        this.factory = factory;
        this.type = type;
    }

    public ResultProcessor withDynamicProjection(ParameterAccessor accessor) {
        Assert.notNull((Object)accessor, "Parameter accessor must not be null!");
        Class<?> projection = accessor.findDynamicProjection();
        return projection == null ? this : this.withType(projection);
    }

    public ReturnedType getReturnedType() {
        return this.type;
    }

    @Nullable
    public <T> T processResult(@Nullable Object source2) {
        return this.processResult(source2, NoOpConverter.INSTANCE);
    }

    @Nullable
    public <T> T processResult(@Nullable Object source2, Converter<Object, Object> preparingConverter) {
        ChainingConverter converter;
        block8: {
            block9: {
                if (source2 == null || this.type.isInstance(source2) || !this.type.isProjecting()) {
                    return (T)source2;
                }
                Assert.notNull(preparingConverter, "Preparing converter must not be null!");
                converter = ChainingConverter.of(this.type.getReturnedType(), preparingConverter).and(this.converter);
                if (!(source2 instanceof Slice)) break block8;
                if (this.method.isPageQuery()) break block9;
                if (!this.method.isSliceQuery()) break block8;
            }
            return (T)((Slice)source2).map(converter::convert);
        }
        if (source2 instanceof Collection && this.method.isCollectionQuery()) {
            Collection collection = (Collection)source2;
            Collection<Object> target = ResultProcessor.createCollectionFor(collection);
            for (Object columns : collection) {
                target.add(this.type.isInstance(columns) ? columns : converter.convert(columns));
            }
            return (T)target;
        }
        if (source2 instanceof Stream && this.method.isStreamQuery()) {
            return (T)((Stream)source2).map(t -> this.type.isInstance(t) ? t : converter.convert(t));
        }
        if (ReactiveWrapperConverters.supports(source2.getClass())) {
            return ReactiveWrapperConverters.map(source2, converter::convert);
        }
        return (T)converter.convert(source2);
    }

    private ResultProcessor withType(Class<?> type) {
        ReturnedType returnedType = ReturnedType.of(type, this.method.getDomainClass(), this.factory);
        return new ResultProcessor(this.method, this.converter.withType(returnedType), this.factory, returnedType);
    }

    private static Collection<Object> createCollectionFor(Collection<?> source2) {
        try {
            return CollectionFactory.createCollection(source2.getClass(), source2.size());
        }
        catch (RuntimeException o_O) {
            return CollectionFactory.createApproximateCollection(source2, source2.size());
        }
    }

    private static class ProjectingConverter
    implements Converter<Object, Object> {
        private final ReturnedType type;
        private final ProjectionFactory factory;
        private final ConversionService conversionService;

        ProjectingConverter(ReturnedType type, ProjectionFactory factory) {
            this(type, factory, DefaultConversionService.getSharedInstance());
        }

        public ProjectingConverter(ReturnedType type, ProjectionFactory factory, ConversionService conversionService) {
            this.type = type;
            this.factory = factory;
            this.conversionService = conversionService;
        }

        ProjectingConverter withType(ReturnedType type) {
            Assert.notNull((Object)type, "ReturnedType must not be null!");
            return new ProjectingConverter(type, this.factory, this.conversionService);
        }

        @Override
        @Nullable
        public Object convert(Object source2) {
            Class<?> targetType = this.type.getReturnedType();
            if (targetType.isInterface()) {
                return this.factory.createProjection(targetType, this.getProjectionTarget(source2));
            }
            return this.conversionService.convert(source2, targetType);
        }

        private Object getProjectionTarget(Object source2) {
            if (source2 != null && source2.getClass().isArray()) {
                source2 = Arrays.asList((Object[])source2);
            }
            if (source2 instanceof Collection) {
                return ProjectingConverter.toMap((Collection)source2, this.type.getInputProperties());
            }
            return source2;
        }

        private static Map<String, Object> toMap(Collection<?> values2, List<String> names) {
            int i2 = 0;
            HashMap<String, Object> result = new HashMap<String, Object>(values2.size());
            for (Object element : values2) {
                result.put(names.get(i2++), element);
            }
            return result;
        }
    }

    private static enum NoOpConverter implements Converter<Object, Object>
    {
        INSTANCE;


        @Override
        public Object convert(Object source2) {
            return source2;
        }
    }

    private static class ChainingConverter
    implements Converter<Object, Object> {
        private final Class<?> targetType;
        private final Converter<Object, Object> delegate;

        private ChainingConverter(Class<?> targetType, Converter<Object, Object> delegate) {
            this.targetType = targetType;
            this.delegate = delegate;
        }

        public static ChainingConverter of(Class<?> targetType, Converter<Object, Object> delegate) {
            return new ChainingConverter(targetType, delegate);
        }

        public ChainingConverter and(Converter<Object, Object> converter) {
            Assert.notNull(converter, "Converter must not be null!");
            return new ChainingConverter(this.targetType, source2 -> {
                if (source2 == null || this.targetType.isInstance(source2)) {
                    return source2;
                }
                Object intermediate = this.convert(source2);
                return intermediate == null || this.targetType.isInstance(intermediate) ? intermediate : converter.convert(intermediate);
            });
        }

        @Override
        @Nullable
        public Object convert(Object source2) {
            return this.delegate.convert(source2);
        }
    }
}

