/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.spel.spi.EvaluationContextExtension;

public class JpaEvaluationContextExtension
implements EvaluationContextExtension {
    private final JpaRootObject root;

    public JpaEvaluationContextExtension(char escapeCharacter) {
        this.root = JpaRootObject.of(EscapeCharacter.of(escapeCharacter));
    }

    @Override
    public String getExtensionId() {
        return "jpa";
    }

    @Override
    public Object getRootObject() {
        return this.root;
    }

    public static class JpaRootObject {
        private final EscapeCharacter character;

        private JpaRootObject(EscapeCharacter character) {
            this.character = character;
        }

        public static JpaRootObject of(EscapeCharacter character) {
            return new JpaRootObject(character);
        }

        public String escape(String source2) {
            return this.character.escape(source2);
        }

        public char escapeCharacter() {
            return this.character.getEscapeCharacter();
        }
    }
}

