/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JpaQueryCreator
extends AbstractQueryCreator<CriteriaQuery<? extends Object>, Predicate> {
    private final CriteriaBuilder builder;
    private final Root<?> root;
    private final CriteriaQuery<? extends Object> query;
    private final ParameterMetadataProvider provider;
    private final ReturnedType returnedType;
    private final PartTree tree;
    private final EscapeCharacter escape;

    public JpaQueryCreator(PartTree tree, ReturnedType type, CriteriaBuilder builder, ParameterMetadataProvider provider) {
        super(tree);
        this.tree = tree;
        CriteriaQuery<? extends Object> criteriaQuery = this.createCriteriaQuery(builder, type);
        this.builder = builder;
        this.query = criteriaQuery.distinct(tree.isDistinct());
        this.root = this.query.from(type.getDomainType());
        this.provider = provider;
        this.returnedType = type;
        this.escape = provider.getEscape();
    }

    protected CriteriaQuery<? extends Object> createCriteriaQuery(CriteriaBuilder builder, ReturnedType type) {
        Class<?> typeToRead = type.getTypeToRead();
        return typeToRead == null || this.tree.isExistsProjection() ? builder.createTupleQuery() : builder.createQuery(typeToRead);
    }

    public List<ParameterMetadataProvider.ParameterMetadata<?>> getParameterExpressions() {
        return this.provider.getExpressions();
    }

    @Override
    protected Predicate create(Part part, Iterator<Object> iterator2) {
        return this.toPredicate(part, this.root);
    }

    @Override
    protected Predicate and(Part part, Predicate base, Iterator<Object> iterator2) {
        return this.builder.and((Expression<Boolean>)base, (Expression<Boolean>)this.toPredicate(part, this.root));
    }

    @Override
    protected Predicate or(Predicate base, Predicate predicate) {
        return this.builder.or((Expression<Boolean>)base, (Expression<Boolean>)predicate);
    }

    @Override
    protected final CriteriaQuery<? extends Object> complete(Predicate predicate, Sort sort) {
        return this.complete(predicate, sort, this.query, this.builder, this.root);
    }

    protected CriteriaQuery<? extends Object> complete(@Nullable Predicate predicate, Sort sort, CriteriaQuery<? extends Object> query2, CriteriaBuilder builder, Root<?> root) {
        if (this.returnedType.needsCustomConstruction()) {
            ArrayList selections = new ArrayList();
            for (String property : this.returnedType.getInputProperties()) {
                PropertyPath path = PropertyPath.from(property, this.returnedType.getDomainType());
                selections.add(QueryUtils.toExpressionRecursively(root, path, true).alias(property));
            }
            Class<?> typeToRead = this.returnedType.getReturnedType();
            query2 = typeToRead.isInterface() ? query2.multiselect(selections) : query2.select(builder.construct(typeToRead, selections.toArray(new Selection[0])));
        } else if (this.tree.isExistsProjection()) {
            if (root.getModel().hasSingleIdAttribute()) {
                SingularAttribute id = root.getModel().getId(root.getModel().getIdType().getJavaType());
                query2 = query2.multiselect(root.get(id).alias(id.getName()));
            } else {
                query2 = query2.multiselect(root.getModel().getIdClassAttributes().stream().map(it -> root.get(it).alias(it.getName())).collect(Collectors.toList()));
            }
        } else {
            query2 = query2.select(root);
        }
        CriteriaQuery<? extends Object> select = query2.orderBy(QueryUtils.toOrders(sort, root, builder));
        return predicate == null ? select : select.where((Expression)predicate);
    }

    private Predicate toPredicate(Part part, Root<?> root) {
        return new PredicateBuilder(part, root).build();
    }

    private class PredicateBuilder {
        private final Part part;
        private final Root<?> root;

        public PredicateBuilder(Part part, Root<?> root) {
            Assert.notNull((Object)part, "Part must not be null!");
            Assert.notNull(root, "Root must not be null!");
            this.part = part;
            this.root = root;
        }

        public Predicate build() {
            PropertyPath property = this.part.getProperty();
            Part.Type type = this.part.getType();
            switch (type) {
                case BETWEEN: {
                    ParameterMetadataProvider.ParameterMetadata first = JpaQueryCreator.this.provider.next(this.part);
                    ParameterMetadataProvider.ParameterMetadata second = JpaQueryCreator.this.provider.next(this.part);
                    return JpaQueryCreator.this.builder.between(this.getComparablePath(this.root, this.part), first.getExpression(), second.getExpression());
                }
                case AFTER: 
                case GREATER_THAN: {
                    return JpaQueryCreator.this.builder.greaterThan(this.getComparablePath(this.root, this.part), JpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case GREATER_THAN_EQUAL: {
                    return JpaQueryCreator.this.builder.greaterThanOrEqualTo(this.getComparablePath(this.root, this.part), JpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case BEFORE: 
                case LESS_THAN: {
                    return JpaQueryCreator.this.builder.lessThan(this.getComparablePath(this.root, this.part), JpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case LESS_THAN_EQUAL: {
                    return JpaQueryCreator.this.builder.lessThanOrEqualTo(this.getComparablePath(this.root, this.part), JpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case IS_NULL: {
                    return this.getTypedPath(this.root, this.part).isNull();
                }
                case IS_NOT_NULL: {
                    return this.getTypedPath(this.root, this.part).isNotNull();
                }
                case NOT_IN: {
                    return this.upperIfIgnoreCase(this.getTypedPath(this.root, this.part)).in((Expression<Collection<?>>)JpaQueryCreator.this.provider.next(this.part, Collection.class).getExpression()).not();
                }
                case IN: {
                    return this.upperIfIgnoreCase(this.getTypedPath(this.root, this.part)).in((Expression<Collection<?>>)JpaQueryCreator.this.provider.next(this.part, Collection.class).getExpression());
                }
                case STARTING_WITH: 
                case ENDING_WITH: 
                case CONTAINING: 
                case NOT_CONTAINING: {
                    if (property.getLeafProperty().isCollection()) {
                        Expression propertyExpression = this.traversePath(this.root, property);
                        ParameterExpression parameterExpression = JpaQueryCreator.this.provider.next(this.part).getExpression();
                        return type.equals((Object)Part.Type.NOT_CONTAINING) ? this.isNotMember(JpaQueryCreator.this.builder, parameterExpression, propertyExpression) : this.isMember(JpaQueryCreator.this.builder, parameterExpression, propertyExpression);
                    }
                }
                case LIKE: 
                case NOT_LIKE: {
                    Expression stringPath = this.getTypedPath(this.root, this.part);
                    Expression<String> propertyExpression = this.upperIfIgnoreCase(stringPath);
                    Expression<String> parameterExpression = this.upperIfIgnoreCase(JpaQueryCreator.this.provider.next(this.part, String.class).getExpression());
                    Predicate like = JpaQueryCreator.this.builder.like(propertyExpression, parameterExpression, JpaQueryCreator.this.escape.getEscapeCharacter());
                    return type.equals((Object)Part.Type.NOT_LIKE) || type.equals((Object)Part.Type.NOT_CONTAINING) ? like.not() : like;
                }
                case TRUE: {
                    Expression<Boolean> truePath = this.getTypedPath(this.root, this.part);
                    return JpaQueryCreator.this.builder.isTrue(truePath);
                }
                case FALSE: {
                    Expression<Boolean> falsePath = this.getTypedPath(this.root, this.part);
                    return JpaQueryCreator.this.builder.isFalse(falsePath);
                }
                case SIMPLE_PROPERTY: {
                    ParameterMetadataProvider.ParameterMetadata expression = JpaQueryCreator.this.provider.next(this.part);
                    Expression path = this.getTypedPath(this.root, this.part);
                    return expression.isIsNullParameter() ? path.isNull() : JpaQueryCreator.this.builder.equal(this.upperIfIgnoreCase(path), this.upperIfIgnoreCase(expression.getExpression()));
                }
                case NEGATING_SIMPLE_PROPERTY: {
                    return JpaQueryCreator.this.builder.notEqual(this.upperIfIgnoreCase(this.getTypedPath(this.root, this.part)), this.upperIfIgnoreCase(JpaQueryCreator.this.provider.next(this.part).getExpression()));
                }
                case IS_EMPTY: 
                case IS_NOT_EMPTY: {
                    if (!property.getLeafProperty().isCollection()) {
                        throw new IllegalArgumentException("IsEmpty / IsNotEmpty can only be used on collection properties!");
                    }
                    Expression collectionPath = this.traversePath(this.root, property);
                    return type.equals((Object)Part.Type.IS_NOT_EMPTY) ? JpaQueryCreator.this.builder.isNotEmpty(collectionPath) : JpaQueryCreator.this.builder.isEmpty(collectionPath);
                }
            }
            throw new IllegalArgumentException("Unsupported keyword " + (Object)((Object)type));
        }

        private <T> Predicate isMember(CriteriaBuilder builder, Expression<T> parameter, Expression<Collection<T>> property) {
            return builder.isMember(parameter, property);
        }

        private <T> Predicate isNotMember(CriteriaBuilder builder, Expression<T> parameter, Expression<Collection<T>> property) {
            return builder.isNotMember(parameter, property);
        }

        private <T> Expression<T> upperIfIgnoreCase(Expression<? extends T> expression) {
            switch (this.part.shouldIgnoreCase()) {
                case ALWAYS: {
                    Assert.state(this.canUpperCase(expression), "Unable to ignore case of " + expression.getJavaType().getName() + " types, the property '" + this.part.getProperty().getSegment() + "' must reference a String");
                    return JpaQueryCreator.this.builder.upper(expression);
                }
                case WHEN_POSSIBLE: {
                    if (!this.canUpperCase(expression)) break;
                    return JpaQueryCreator.this.builder.upper(expression);
                }
            }
            return expression;
        }

        private boolean canUpperCase(Expression<?> expression) {
            return String.class.equals(expression.getJavaType());
        }

        private Expression<? extends Comparable> getComparablePath(Root<?> root, Part part) {
            return this.getTypedPath(root, part);
        }

        private <T> Expression<T> getTypedPath(Root<?> root, Part part) {
            return QueryUtils.toExpressionRecursively(root, part.getProperty());
        }

        private <T> Expression<T> traversePath(Path<?> root, PropertyPath path) {
            Path result = root.get(path.getSegment());
            return path.hasNext() ? this.traversePath(result, path.next()) : result;
        }
    }
}

