/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.lang.NonNull;

public abstract class Jsr310Converters {
    private static final List<Class<?>> CLASSES = Arrays.asList(LocalDateTime.class, LocalDate.class, LocalTime.class, Instant.class, ZoneId.class, Duration.class, Period.class);

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        converters.add(DateToLocalDateTimeConverter.INSTANCE);
        converters.add(LocalDateTimeToDateConverter.INSTANCE);
        converters.add(DateToLocalDateConverter.INSTANCE);
        converters.add(LocalDateToDateConverter.INSTANCE);
        converters.add(DateToLocalTimeConverter.INSTANCE);
        converters.add(LocalTimeToDateConverter.INSTANCE);
        converters.add(DateToInstantConverter.INSTANCE);
        converters.add(InstantToDateConverter.INSTANCE);
        converters.add(LocalDateTimeToInstantConverter.INSTANCE);
        converters.add(InstantToLocalDateTimeConverter.INSTANCE);
        converters.add(ZoneIdToStringConverter.INSTANCE);
        converters.add(StringToZoneIdConverter.INSTANCE);
        converters.add(DurationToStringConverter.INSTANCE);
        converters.add(StringToDurationConverter.INSTANCE);
        converters.add(PeriodToStringConverter.INSTANCE);
        converters.add(StringToPeriodConverter.INSTANCE);
        converters.add(StringToLocalDateConverter.INSTANCE);
        converters.add(StringToLocalDateTimeConverter.INSTANCE);
        converters.add(StringToInstantConverter.INSTANCE);
        return converters;
    }

    public static boolean supports(Class<?> type) {
        return CLASSES.contains(type);
    }

    @ReadingConverter
    public static enum StringToInstantConverter implements Converter<String, Instant>
    {
        INSTANCE;


        @Override
        @NonNull
        public Instant convert(String source2) {
            return Instant.parse(source2);
        }
    }

    @ReadingConverter
    public static enum StringToLocalDateTimeConverter implements Converter<String, LocalDateTime>
    {
        INSTANCE;


        @Override
        @NonNull
        public LocalDateTime convert(String source2) {
            return LocalDateTime.parse(source2, DateTimeFormatter.ISO_DATE_TIME);
        }
    }

    @ReadingConverter
    public static enum StringToLocalDateConverter implements Converter<String, LocalDate>
    {
        INSTANCE;


        @Override
        @NonNull
        public LocalDate convert(String source2) {
            return LocalDate.parse(source2, DateTimeFormatter.ISO_DATE);
        }
    }

    @ReadingConverter
    public static enum StringToPeriodConverter implements Converter<String, Period>
    {
        INSTANCE;


        @Override
        @NonNull
        public Period convert(String s2) {
            return Period.parse(s2);
        }
    }

    @WritingConverter
    public static enum PeriodToStringConverter implements Converter<Period, String>
    {
        INSTANCE;


        @Override
        @NonNull
        public String convert(Period period) {
            return period.toString();
        }
    }

    @ReadingConverter
    public static enum StringToDurationConverter implements Converter<String, Duration>
    {
        INSTANCE;


        @Override
        @NonNull
        public Duration convert(String s2) {
            return Duration.parse(s2);
        }
    }

    @WritingConverter
    public static enum DurationToStringConverter implements Converter<Duration, String>
    {
        INSTANCE;


        @Override
        @NonNull
        public String convert(Duration duration) {
            return duration.toString();
        }
    }

    @ReadingConverter
    public static enum StringToZoneIdConverter implements Converter<String, ZoneId>
    {
        INSTANCE;


        @Override
        @NonNull
        public ZoneId convert(String source2) {
            return ZoneId.of(source2);
        }
    }

    @WritingConverter
    public static enum ZoneIdToStringConverter implements Converter<ZoneId, String>
    {
        INSTANCE;


        @Override
        @NonNull
        public String convert(ZoneId source2) {
            return source2.toString();
        }
    }

    @ReadingConverter
    public static enum InstantToLocalDateTimeConverter implements Converter<Instant, LocalDateTime>
    {
        INSTANCE;


        @Override
        @NonNull
        public LocalDateTime convert(Instant source2) {
            return LocalDateTime.ofInstant(source2, ZoneId.systemDefault());
        }
    }

    @ReadingConverter
    public static enum LocalDateTimeToInstantConverter implements Converter<LocalDateTime, Instant>
    {
        INSTANCE;


        @Override
        @NonNull
        public Instant convert(LocalDateTime source2) {
            return source2.atZone(ZoneId.systemDefault()).toInstant();
        }
    }

    @WritingConverter
    public static enum InstantToDateConverter implements Converter<Instant, Date>
    {
        INSTANCE;


        @Override
        @NonNull
        public Date convert(Instant source2) {
            return Date.from(source2);
        }
    }

    @ReadingConverter
    public static enum DateToInstantConverter implements Converter<Date, Instant>
    {
        INSTANCE;


        @Override
        @NonNull
        public Instant convert(Date source2) {
            return source2.toInstant();
        }
    }

    @WritingConverter
    public static enum LocalTimeToDateConverter implements Converter<LocalTime, Date>
    {
        INSTANCE;


        @Override
        @NonNull
        public Date convert(LocalTime source2) {
            return Date.from(source2.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    @ReadingConverter
    public static enum DateToLocalTimeConverter implements Converter<Date, LocalTime>
    {
        INSTANCE;


        @Override
        @NonNull
        public LocalTime convert(Date source2) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(source2.getTime()), ZoneId.systemDefault()).toLocalTime();
        }
    }

    @WritingConverter
    public static enum LocalDateToDateConverter implements Converter<LocalDate, Date>
    {
        INSTANCE;


        @Override
        @NonNull
        public Date convert(LocalDate source2) {
            return Date.from(source2.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
    }

    @ReadingConverter
    public static enum DateToLocalDateConverter implements Converter<Date, LocalDate>
    {
        INSTANCE;


        @Override
        @NonNull
        public LocalDate convert(Date source2) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(source2.getTime()), ZoneId.systemDefault()).toLocalDate();
        }
    }

    @WritingConverter
    public static enum LocalDateTimeToDateConverter implements Converter<LocalDateTime, Date>
    {
        INSTANCE;


        @Override
        @NonNull
        public Date convert(LocalDateTime source2) {
            return Date.from(source2.atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    @ReadingConverter
    public static enum DateToLocalDateTimeConverter implements Converter<Date, LocalDateTime>
    {
        INSTANCE;


        @Override
        @NonNull
        public LocalDateTime convert(Date source2) {
            return LocalDateTime.ofInstant(source2.toInstant(), ZoneId.systemDefault());
        }
    }
}

