/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;

@Deprecated
public abstract class JodaTimeConverters {
    private static final boolean JODA_TIME_IS_PRESENT = ClassUtils.isPresent("org.joda.time.LocalDate", null);

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!JODA_TIME_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(LocalDateToDateConverter.INSTANCE);
        converters.add(LocalDateTimeToDateConverter.INSTANCE);
        converters.add(DateTimeToDateConverter.INSTANCE);
        converters.add(DateToLocalDateConverter.INSTANCE);
        converters.add(DateToLocalDateTimeConverter.INSTANCE);
        converters.add(DateToDateTimeConverter.INSTANCE);
        converters.add(LocalDateTimeToJodaLocalDateTime.INSTANCE);
        converters.add(LocalDateTimeToJodaDateTime.INSTANCE);
        converters.add(InstantToJodaLocalDateTime.INSTANCE);
        converters.add(JodaLocalDateTimeToInstant.INSTANCE);
        converters.add(LocalDateTimeToJsr310Converter.INSTANCE);
        return converters;
    }

    @Deprecated
    public static enum LocalDateTimeToJodaDateTime implements Converter<java.time.LocalDateTime, DateTime>
    {
        INSTANCE;


        @Override
        @NonNull
        public DateTime convert(java.time.LocalDateTime source2) {
            return new DateTime((Object)Jsr310Converters.LocalDateTimeToDateConverter.INSTANCE.convert(source2));
        }
    }

    @Deprecated
    public static enum JodaLocalDateTimeToInstant implements Converter<LocalDateTime, Instant>
    {
        INSTANCE;


        @Override
        @NonNull
        public Instant convert(LocalDateTime source2) {
            return Instant.ofEpochMilli(source2.toDateTime().getMillis());
        }
    }

    @Deprecated
    public static enum InstantToJodaLocalDateTime implements Converter<Instant, LocalDateTime>
    {
        INSTANCE;


        @Override
        @NonNull
        public LocalDateTime convert(Instant source2) {
            return LocalDateTime.fromDateFields((Date)new Date(source2.toEpochMilli()));
        }
    }

    @ReadingConverter
    @Deprecated
    public static enum LocalDateTimeToJodaLocalDateTime implements Converter<java.time.LocalDateTime, LocalDateTime>
    {
        INSTANCE;


        @Override
        @NonNull
        public LocalDateTime convert(java.time.LocalDateTime source2) {
            return LocalDateTime.fromDateFields((Date)Jsr310Converters.LocalDateTimeToDateConverter.INSTANCE.convert(source2));
        }
    }

    @Deprecated
    public static enum DateToDateTimeConverter implements Converter<Date, DateTime>
    {
        INSTANCE;


        @Override
        @NonNull
        public DateTime convert(Date source2) {
            return new DateTime(source2.getTime());
        }
    }

    @Deprecated
    public static enum DateToLocalDateTimeConverter implements Converter<Date, LocalDateTime>
    {
        INSTANCE;


        @Override
        @NonNull
        public LocalDateTime convert(Date source2) {
            return new LocalDateTime(source2.getTime());
        }
    }

    @Deprecated
    public static enum DateToLocalDateConverter implements Converter<Date, LocalDate>
    {
        INSTANCE;


        @Override
        @NonNull
        public LocalDate convert(Date source2) {
            return new LocalDate(source2.getTime());
        }
    }

    @Deprecated
    public static enum DateTimeToDateConverter implements Converter<DateTime, Date>
    {
        INSTANCE;


        @Override
        @NonNull
        public Date convert(DateTime source2) {
            return source2.toDate();
        }
    }

    @Deprecated
    public static enum LocalDateTimeToDateConverter implements Converter<LocalDateTime, Date>
    {
        INSTANCE;


        @Override
        @NonNull
        public Date convert(LocalDateTime source2) {
            return source2.toDate();
        }
    }

    @Deprecated
    public static enum LocalDateToDateConverter implements Converter<LocalDate, Date>
    {
        INSTANCE;


        @Override
        @NonNull
        public Date convert(LocalDate source2) {
            return source2.toDate();
        }
    }

    @Deprecated
    public static enum LocalDateTimeToJsr310Converter implements Converter<LocalDateTime, java.time.LocalDateTime>
    {
        INSTANCE;


        @Override
        @NonNull
        public java.time.LocalDateTime convert(LocalDateTime source2) {
            return java.time.LocalDateTime.ofInstant(source2.toDate().toInstant(), ZoneId.systemDefault());
        }
    }
}

