/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.availability;

import org.springframework.boot.availability.AvailabilityState;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class AvailabilityChangeEvent<S extends AvailabilityState>
extends PayloadApplicationEvent<S> {
    public AvailabilityChangeEvent(Object source2, S state) {
        super(source2, state);
    }

    public S getState() {
        return (S)((AvailabilityState)this.getPayload());
    }

    @Override
    public ResolvableType getResolvableType() {
        return ResolvableType.forClassWithGenerics(this.getClass(), this.getStateType());
    }

    private Class<?> getStateType() {
        S state = this.getState();
        if (state instanceof Enum) {
            return ((Enum)state).getDeclaringClass();
        }
        return state.getClass();
    }

    public static <S extends AvailabilityState> void publish(ApplicationContext context, S state) {
        Assert.notNull((Object)context, "Context must not be null");
        AvailabilityChangeEvent.publish(context, context, state);
    }

    public static <S extends AvailabilityState> void publish(ApplicationEventPublisher publisher, Object source2, S state) {
        Assert.notNull((Object)publisher, "Publisher must not be null");
        publisher.publishEvent(new AvailabilityChangeEvent<S>(source2, state));
    }
}

