/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import groovy.lang.Closure;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.groovy.GroovyBeanDefinitionReader;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.SpringProperties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class BeanDefinitionLoader {
    private static final boolean XML_ENABLED = !SpringProperties.getFlag("spring.xml.ignore");
    private static final Pattern GROOVY_CLOSURE_PATTERN = Pattern.compile(".*\\$_.*closure.*");
    private final Object[] sources;
    private final AnnotatedBeanDefinitionReader annotatedReader;
    private final AbstractBeanDefinitionReader xmlReader;
    private final BeanDefinitionReader groovyReader;
    private final ClassPathBeanDefinitionScanner scanner;
    private ResourceLoader resourceLoader;

    BeanDefinitionLoader(BeanDefinitionRegistry registry, Object ... sources) {
        Assert.notNull((Object)registry, "Registry must not be null");
        Assert.notEmpty(sources, "Sources must not be empty");
        this.sources = sources;
        this.annotatedReader = new AnnotatedBeanDefinitionReader(registry);
        this.xmlReader = XML_ENABLED ? new XmlBeanDefinitionReader(registry) : null;
        this.groovyReader = this.isGroovyPresent() ? new GroovyBeanDefinitionReader(registry) : null;
        this.scanner = new ClassPathBeanDefinitionScanner(registry);
        this.scanner.addExcludeFilter(new ClassExcludeFilter(sources));
    }

    void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.annotatedReader.setBeanNameGenerator(beanNameGenerator);
        this.scanner.setBeanNameGenerator(beanNameGenerator);
        if (this.xmlReader != null) {
            this.xmlReader.setBeanNameGenerator(beanNameGenerator);
        }
    }

    void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.scanner.setResourceLoader(resourceLoader);
        if (this.xmlReader != null) {
            this.xmlReader.setResourceLoader(resourceLoader);
        }
    }

    void setEnvironment(ConfigurableEnvironment environment2) {
        this.annotatedReader.setEnvironment(environment2);
        this.scanner.setEnvironment(environment2);
        if (this.xmlReader != null) {
            this.xmlReader.setEnvironment(environment2);
        }
    }

    void load() {
        for (Object source2 : this.sources) {
            this.load(source2);
        }
    }

    private void load(Object source2) {
        Assert.notNull(source2, "Source must not be null");
        if (source2 instanceof Class) {
            this.load((Class)source2);
            return;
        }
        if (source2 instanceof Resource) {
            this.load((Resource)source2);
            return;
        }
        if (source2 instanceof Package) {
            this.load((Package)source2);
            return;
        }
        if (source2 instanceof CharSequence) {
            this.load((CharSequence)source2);
            return;
        }
        throw new IllegalArgumentException("Invalid source type " + source2.getClass());
    }

    private void load(Class<?> source2) {
        if (this.isGroovyPresent() && GroovyBeanDefinitionSource.class.isAssignableFrom(source2)) {
            GroovyBeanDefinitionSource loader = BeanUtils.instantiateClass(source2, GroovyBeanDefinitionSource.class);
            ((GroovyBeanDefinitionReader)this.groovyReader).beans(loader.getBeans());
        }
        if (this.isEligible(source2)) {
            this.annotatedReader.register(source2);
        }
    }

    private void load(Resource source2) {
        if (source2.getFilename().endsWith(".groovy")) {
            if (this.groovyReader == null) {
                throw new BeanDefinitionStoreException("Cannot load Groovy beans without Groovy on classpath");
            }
            this.groovyReader.loadBeanDefinitions(source2);
        } else {
            if (this.xmlReader == null) {
                throw new BeanDefinitionStoreException("Cannot load XML bean definitions when XML support is disabled");
            }
            this.xmlReader.loadBeanDefinitions(source2);
        }
    }

    private void load(Package source2) {
        this.scanner.scan(source2.getName());
    }

    private void load(CharSequence source2) {
        String resolvedSource = this.scanner.getEnvironment().resolvePlaceholders(source2.toString());
        try {
            this.load(ClassUtils.forName(resolvedSource, null));
            return;
        }
        catch (ClassNotFoundException | IllegalArgumentException exception) {
            if (this.loadAsResources(resolvedSource)) {
                return;
            }
            Package packageResource = this.findPackage(resolvedSource);
            if (packageResource != null) {
                this.load(packageResource);
                return;
            }
            throw new IllegalArgumentException("Invalid source '" + resolvedSource + "'");
        }
    }

    private boolean loadAsResources(String resolvedSource) {
        Resource[] resources2;
        boolean foundCandidate = false;
        for (Resource resource : resources2 = this.findResources(resolvedSource)) {
            if (!this.isLoadCandidate(resource)) continue;
            foundCandidate = true;
            this.load(resource);
        }
        return foundCandidate;
    }

    private boolean isGroovyPresent() {
        return ClassUtils.isPresent("groovy.lang.MetaClass", null);
    }

    private Resource[] findResources(String source2) {
        ResourceLoader loader = this.resourceLoader != null ? this.resourceLoader : new PathMatchingResourcePatternResolver();
        try {
            if (loader instanceof ResourcePatternResolver) {
                return ((ResourcePatternResolver)loader).getResources(source2);
            }
            return new Resource[]{loader.getResource(source2)};
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error reading source '" + source2 + "'");
        }
    }

    private boolean isLoadCandidate(Resource resource) {
        String path;
        if (resource == null || !resource.exists()) {
            return false;
        }
        if (resource instanceof ClassPathResource && (path = ((ClassPathResource)resource).getPath()).indexOf(46) == -1) {
            try {
                return Package.getPackage(path) == null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private Package findPackage(CharSequence source2) {
        Package pkg = Package.getPackage(source2.toString());
        if (pkg != null) {
            return pkg;
        }
        try {
            Resource[] resources2;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());
            Resource[] resourceArray = resources2 = resolver.getResources(ClassUtils.convertClassNameToResourcePath(source2.toString()) + "/*.class");
            int n = resourceArray.length;
            int n2 = 0;
            if (n2 < n) {
                Resource resource = resourceArray[n2];
                String className = StringUtils.stripFilenameExtension(resource.getFilename());
                this.load(Class.forName(source2.toString() + "." + className));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Package.getPackage(source2.toString());
    }

    private boolean isEligible(Class<?> type) {
        return !type.isAnonymousClass() && !this.isGroovyClosure(type) && !this.hasNoConstructors(type);
    }

    private boolean isGroovyClosure(Class<?> type) {
        return GROOVY_CLOSURE_PATTERN.matcher(type.getName()).matches();
    }

    private boolean hasNoConstructors(Class<?> type) {
        Object[] constructors = type.getDeclaredConstructors();
        return ObjectUtils.isEmpty(constructors);
    }

    @FunctionalInterface
    protected static interface GroovyBeanDefinitionSource {
        public Closure<?> getBeans();
    }

    private static class ClassExcludeFilter
    extends AbstractTypeHierarchyTraversingFilter {
        private final Set<String> classNames = new HashSet<String>();

        ClassExcludeFilter(Object ... sources) {
            super(false, false);
            for (Object source2 : sources) {
                if (!(source2 instanceof Class)) continue;
                this.classNames.add(((Class)source2).getName());
            }
        }

        @Override
        protected boolean matchClassName(String className) {
            return this.classNames.contains(className);
        }
    }
}

