/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.logging.Log;
import org.jgroups.util.SuppressCache;
import org.jgroups.util.Util;

public class SuppressLog<T> {
    protected final Log log;
    protected final SuppressCache<T> cache;
    protected final String message_format;
    protected final String suppress_format;

    public SuppressLog(Log log, String message_key, String suppress_msg) {
        this.log = log;
        this.cache = new SuppressCache();
        this.message_format = Util.getMessage(message_key);
        this.suppress_format = Util.getMessage(suppress_msg);
    }

    public SuppressCache<T> getCache() {
        return this.cache;
    }

    public void log(Level level, T key, long timeout, Object ... args2) {
        SuppressCache.Value val = this.cache.putIfAbsent(key, timeout);
        if (val == null) {
            return;
        }
        String message = val.count() == 1 ? String.format(this.message_format, args2) : String.format(this.message_format, args2) + " " + String.format(this.suppress_format, val.count(), key, val.age());
        switch (level) {
            case error: {
                this.log.error(message);
                break;
            }
            case warn: {
                this.log.warn(message);
                break;
            }
            case trace: {
                this.log.trace(message);
            }
        }
    }

    public void removeExpired(long timeout) {
        this.cache.removeExpired(timeout);
    }

    public static enum Level {
        error,
        warn,
        trace;

    }
}

