/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.rt.transports;

import java.io.Closeable;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.tests.rt.RtReceiver;
import org.jgroups.tests.rt.RtTransport;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

public class JGroupsTransport
implements Receiver,
RtTransport {
    protected JChannel ch;
    protected RtReceiver receiver;
    protected View view;
    protected boolean oob = true;
    protected boolean dont_bundle;
    protected final Log log = LogFactory.getLog(JGroupsTransport.class);

    @Override
    public String[] options() {
        return new String[]{"-props <props>", "-name <name>", "-oob true|false", "-dont_bundle true|false"};
    }

    @Override
    public void options(String ... options) throws Exception {
        if (options == null) {
            return;
        }
        for (int i2 = 0; i2 < options.length; ++i2) {
            if (options[i2].startsWith("-oob")) {
                this.oob = Boolean.valueOf(options[++i2]);
                continue;
            }
            if (!options[i2].startsWith("-dont_bundle")) continue;
            this.dont_bundle = Boolean.valueOf(options[++i2]);
        }
    }

    @Override
    public void receiver(RtReceiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public Address localAddress() {
        return this.ch != null ? this.ch.getAddress() : null;
    }

    public List<Address> clusterMembers() {
        return this.view.getMembers();
    }

    @Override
    public void start(String ... options) throws Exception {
        String props = "udp.xml";
        String name = null;
        this.options(options);
        if (options != null) {
            for (int i2 = 0; i2 < options.length; ++i2) {
                if (options[i2].startsWith("-props")) {
                    props = options[++i2];
                    continue;
                }
                if (!options[i2].startsWith("-name")) continue;
                name = options[++i2];
            }
        }
        this.ch = new JChannel(props).name(name).receiver(this);
        TP transport = this.ch.getProtocolStack().getTransport();
        this.ch.connect("rt");
        View v = this.ch.getView();
        if (v.size() > 2) {
            throw new IllegalStateException(String.format("More than 2 members found (%s); terminating\n", v));
        }
    }

    @Override
    public void stop() {
        Util.close((Closeable)this.ch);
    }

    @Override
    public void send(Object dest, byte[] buf, int offset, int length) throws Exception {
        BytesMessage msg = new BytesMessage((Address)dest, buf, offset, length);
        if (this.oob) {
            msg.setFlag(Message.Flag.OOB);
        }
        if (this.dont_bundle) {
            msg.setFlag(Message.Flag.DONT_BUNDLE);
        }
        this.ch.send(msg);
    }

    @Override
    public void receive(MessageBatch batch) {
        if (this.receiver == null) {
            return;
        }
        for (Message msg : batch) {
            try {
                this.receiver.receive(msg.getSrc(), msg.getArray(), msg.getOffset(), msg.getLength());
            }
            catch (Throwable t) {
                this.log.error("failed delivering message from batch", t);
            }
        }
    }

    @Override
    public void receive(Message msg) {
        if (this.receiver == null) {
            return;
        }
        try {
            this.receiver.receive(msg.getSrc(), msg.getArray(), msg.getOffset(), msg.getLength());
        }
        catch (Throwable t) {
            this.log.error("failed delivering message", t);
        }
    }

    @Override
    public void viewAccepted(View view) {
        System.out.println("view = " + view);
        this.view = view;
    }
}

