/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.Closeable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.MethodInvoker;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.protocols.FD_ALL3;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FRAG4;
import org.jgroups.protocols.MERGE3;
import org.jgroups.protocols.MFC;
import org.jgroups.protocols.PING;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TCPPING;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UDP;
import org.jgroups.protocols.UFC;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.VERIFY_SUSPECT;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.NonReflectiveProbeHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.perf.PerfUtil;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.OneTimeAddressGenerator;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class ProgrammaticUPerf
implements Receiver,
MethodInvoker {
    private JChannel channel;
    private Address local_addr;
    private RpcDispatcher disp;
    static final String groupname = "uperf";
    protected final List<Address> members = new ArrayList<Address>();
    protected volatile View view;
    protected volatile boolean looping = true;
    protected Thread event_loop_thread;
    protected final LongAdder num_reads = new LongAdder();
    protected final LongAdder num_writes = new LongAdder();
    @Property
    protected boolean sync = true;
    @Property
    protected boolean oob = true;
    @Property
    protected int num_threads = 100;
    @Property
    protected int time = 60;
    @Property
    protected int msg_size = 1000;
    @Property
    protected int anycast_count = 2;
    @Property
    protected double read_percentage = 0.8;
    @Property
    protected boolean allow_local_gets = true;
    @Property
    protected boolean print_invokers;
    @Property
    protected boolean print_details;
    private static final short START = 0;
    private static final short GET = 1;
    private static final short PUT = 2;
    private static final short GET_CONFIG = 3;
    private static final short SET_SYNC = 4;
    private static final short SET_OOB = 5;
    private static final short SET_NUM_THREADS = 6;
    private static final short SET_TIME = 7;
    private static final short SET_MSG_SIZE = 8;
    private static final short SET_ANYCAST_COUNT = 9;
    private static final short SET_READ_PERCENTAGE = 10;
    private static final short ALLOW_LOCAL_GETS = 11;
    private static final short PRINT_INVOKERS = 12;
    private static final short PRINT_DETAILS = 13;
    private static final short QUIT_ALL = 14;
    private final AtomicInteger COUNTER = new AtomicInteger(1);
    private byte[] BUFFER = new byte[this.msg_size];
    protected static final String format = "[1] Start test [2] View [4] Threads (%d) [6] Time (%,ds) [7] Msg size (%s)\n[s] Sync (%b) [o] OOB (%b)\n[a] Anycast count (%d) [r] Read percentage (%.2f) \n[l] local gets (%b) [d] print details (%b)  [i] print invokers (%b)\n[v] Version [x] Exit [X] Exit all\n";

    public boolean getSync() {
        return this.sync;
    }

    public void setSync(boolean s2) {
        this.sync = s2;
    }

    public boolean getOOB() {
        return this.oob;
    }

    public void setOOB(boolean oob) {
        this.oob = oob;
    }

    public int getNumThreads() {
        return this.num_threads;
    }

    public void setNumThreads(int t) {
        this.num_threads = t;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int t) {
        this.time = t;
    }

    public int getMsgSize() {
        return this.msg_size;
    }

    public void setMsgSize(int t) {
        this.msg_size = t;
    }

    public int getAnycastCount() {
        return this.anycast_count;
    }

    public void setAnycastCount(int t) {
        this.anycast_count = t;
    }

    public double getReadPercentage() {
        return this.read_percentage;
    }

    public void setReadPercentage(double r) {
        this.read_percentage = r;
    }

    public boolean allowLocalGets() {
        return this.allow_local_gets;
    }

    public void allowLocalGets(boolean a) {
        this.allow_local_gets = a;
    }

    public boolean printInvokers() {
        return this.print_invokers;
    }

    public void printInvokers(boolean p) {
        this.print_invokers = p;
    }

    public boolean printDetails() {
        return this.print_details;
    }

    public void printDetails(boolean p) {
        this.print_details = p;
    }

    public void init(String name, AddressGenerator generator, String bind_addr, int bind_port, boolean udp, String mcast_addr, int mcast_port, String initial_hosts) throws Throwable {
        InetAddress bind_address = bind_addr != null ? Util.getAddress(bind_addr, Util.getIpStackType()) : Util.getLoopback();
        Protocol[] prot_stack = new Protocol[]{null, null, new MERGE3(), new FD_SOCK(), new FD_ALL3(), new VERIFY_SUSPECT(), new NAKACK2(), new UNICAST3(), new STABLE(), new GMS().setJoinTimeout(1000L), new UFC(), new MFC(), new FRAG4()};
        if (udp) {
            Object u = ((UDP)new UDP().setMulticastAddress(InetAddress.getByName(mcast_addr))).setMulticastPort(mcast_port);
            ((TP)u).getDiagnosticsHandler().setMcastAddress(InetAddress.getByName("224.0.75.75")).enableUdp(true);
            prot_stack[0] = u;
            prot_stack[1] = new PING();
        } else {
            if (initial_hosts == null) {
                InetAddress host = bind_addr == null ? InetAddress.getLocalHost() : Util.getAddress(bind_addr, Util.getIpStackType());
                initial_hosts = String.format("%s[%d]", host.getHostAddress(), bind_port);
            }
            TCP tcp = new TCP();
            tcp.getDiagnosticsHandler().enableUdp(false).enableTcp(true);
            prot_stack[0] = tcp;
            prot_stack[1] = new TCPPING().setInitialHosts2(Util.parseCommaDelimitedHosts(initial_hosts, 2));
        }
        ((TP)((TP)prot_stack[0]).setBindAddress(bind_address)).setBindPort(bind_port);
        this.channel = new JChannel(prot_stack).addAddressGenerator(generator).setName(name);
        TP transport = this.channel.getProtocolStack().getTransport();
        NonReflectiveProbeHandler h2 = new NonReflectiveProbeHandler(this.channel);
        transport.registerProbeHandler(h2);
        h2.initialize(this.channel.getProtocolStack().getProtocols());
        this.disp = new RpcDispatcher(this.channel, this).setReceiver(this).setMethodInvoker(this);
        this.channel.connect(groupname);
        this.local_addr = this.channel.getAddress();
        if (this.members.size() < 2) {
            return;
        }
        Address coord = this.members.get(0);
        PerfUtil.Config config = (PerfUtil.Config)this.disp.callRemoteMethod(coord, new PerfUtil.CustomCall(3, new Object[0]), new RequestOptions(ResponseMode.GET_ALL, 5000L));
        if (config != null) {
            this.applyConfig(config);
            System.out.println("Fetched config from " + coord + ": " + config + "\n");
        } else {
            System.err.println("failed to fetch config from " + coord);
        }
    }

    void stop() {
        Util.close(this.disp, this.channel);
    }

    protected void startEventThread() {
        this.event_loop_thread = new Thread(this::eventLoop, "EventLoop");
        this.event_loop_thread.setDaemon(true);
        this.event_loop_thread.start();
    }

    protected void stopEventThread() {
        Thread tmp = this.event_loop_thread;
        this.looping = false;
        if (tmp != null) {
            tmp.interrupt();
        }
        Util.close((Closeable)this.channel);
    }

    @Override
    public void viewAccepted(View new_view) {
        this.view = new_view;
        System.out.println("** view: " + new_view);
        this.members.clear();
        this.members.addAll(new_view.getMembers());
    }

    @Override
    public Object invoke(Object target, short method_id, Object[] args2) throws Exception {
        ProgrammaticUPerf uperf = (ProgrammaticUPerf)target;
        switch (method_id) {
            case 0: {
                return uperf.startTest();
            }
            case 1: {
                Integer key = (Integer)args2[0];
                return uperf.get(key);
            }
            case 2: {
                Integer key = (Integer)args2[0];
                byte[] val = (byte[])args2[1];
                uperf.put(key, val);
                return null;
            }
            case 3: {
                return uperf.getConfig();
            }
            case 4: {
                uperf.setSync((Boolean)args2[0]);
                return null;
            }
            case 5: {
                Boolean bool_val = (Boolean)args2[0];
                uperf.setOOB(bool_val);
                return null;
            }
            case 6: {
                uperf.setNumThreads((Integer)args2[0]);
                return null;
            }
            case 7: {
                uperf.setTime((Integer)args2[0]);
                return null;
            }
            case 8: {
                uperf.setMsgSize((Integer)args2[0]);
                return null;
            }
            case 9: {
                uperf.setAnycastCount((Integer)args2[0]);
                return null;
            }
            case 10: {
                uperf.setReadPercentage((Double)args2[0]);
                return null;
            }
            case 11: {
                uperf.allowLocalGets((Boolean)args2[0]);
                return null;
            }
            case 12: {
                uperf.printInvokers((Boolean)args2[0]);
                return null;
            }
            case 13: {
                uperf.printDetails((Boolean)args2[0]);
                return null;
            }
            case 14: {
                uperf.quitAll();
                return null;
            }
        }
        throw new IllegalArgumentException("method with id=" + method_id + " not found");
    }

    public PerfUtil.Results startTest() throws Exception {
        this.BUFFER = new byte[this.msg_size];
        System.out.printf("running for %d seconds\n", this.time);
        CountDownLatch latch = new CountDownLatch(1);
        this.num_reads.reset();
        this.num_writes.reset();
        Invoker[] invokers = new Invoker[this.num_threads];
        for (int i2 = 0; i2 < invokers.length; ++i2) {
            invokers[i2] = new Invoker(this.members, latch);
            invokers[i2].start();
        }
        long start = System.currentTimeMillis();
        latch.countDown();
        long interval = (long)((double)this.time * 1000.0 / 10.0);
        for (int i3 = 1; i3 <= 10; ++i3) {
            Util.sleep(interval);
            System.out.printf("%d: %s\n", i3, this.printAverage(start));
        }
        for (Invoker invoker : invokers) {
            invoker.cancel();
        }
        for (Invoker invoker : invokers) {
            invoker.join();
        }
        long total_time = System.currentTimeMillis() - start;
        System.out.println();
        AverageMinMax avg_gets = null;
        AverageMinMax avg_puts = null;
        for (Invoker invoker : invokers) {
            if (this.print_invokers) {
                System.out.printf("invoker %s: gets %s puts %s\n", invoker.getId(), ProgrammaticUPerf.print(invoker.avgGets(), this.print_details), ProgrammaticUPerf.print(invoker.avgPuts(), this.print_details));
            }
            if (avg_gets == null) {
                avg_gets = invoker.avgGets();
            } else {
                avg_gets.merge(invoker.avgGets());
            }
            if (avg_puts == null) {
                avg_puts = invoker.avgPuts();
                continue;
            }
            avg_puts.merge(invoker.avgPuts());
        }
        if (this.print_invokers) {
            System.out.printf("\navg over all invokers: gets %s puts %s\n", ProgrammaticUPerf.print(avg_gets, this.print_details), ProgrammaticUPerf.print(avg_puts, this.print_details));
        }
        System.out.printf("\ndone (in %s ms)\n", total_time);
        return new PerfUtil.Results((int)this.num_reads.sum(), (int)this.num_writes.sum(), total_time, avg_gets, avg_puts);
    }

    public void quitAll() {
        System.out.println("-- received quitAll(): shutting down");
        this.stopEventThread();
    }

    protected String printAverage(long start_time) {
        long tmp_time = System.currentTimeMillis() - start_time;
        long reads = this.num_reads.sum();
        long writes = this.num_writes.sum();
        double reqs_sec = (double)(reads + writes) / ((double)tmp_time / 1000.0);
        return String.format("%,.0f reqs/sec (%,d reads %,d writes)", reqs_sec, reads, writes);
    }

    public byte[] get(int key) {
        return this.BUFFER;
    }

    public void put(int key, byte[] val) {
    }

    public PerfUtil.Config getConfig() {
        PerfUtil.Config c = new PerfUtil.Config();
        c.add("sync", this.sync).add("oob", this.oob).add("num_threads", this.num_threads).add("time", this.time).add("msg_size", this.msg_size).add("anycast_count", this.anycast_count).add("read_percentage", this.read_percentage).add("allow_local_gets", this.allow_local_gets).add("print_invokers", this.print_invokers).add("print_details", this.print_details);
        return c;
    }

    protected void applyConfig(PerfUtil.Config config) {
        block24: for (Map.Entry<String, Object> e : config.values.entrySet()) {
            String name = e.getKey();
            Object value = e.getValue();
            switch (name) {
                case "sync": {
                    this.setSync((Boolean)value);
                    continue block24;
                }
                case "oob": {
                    this.setOOB((Boolean)value);
                    continue block24;
                }
                case "num_threads": {
                    this.setNumThreads((Integer)value);
                    continue block24;
                }
                case "time": {
                    this.setTime((Integer)value);
                    continue block24;
                }
                case "msg_size": {
                    this.setMsgSize((Integer)value);
                    continue block24;
                }
                case "anycast_count": {
                    this.setAnycastCount((Integer)value);
                    continue block24;
                }
                case "read_percentage": {
                    this.setReadPercentage((Double)value);
                    continue block24;
                }
                case "allow_local_gets": {
                    this.allowLocalGets((Boolean)value);
                    continue block24;
                }
                case "print_invokers": {
                    this.printInvokers((Boolean)value);
                    continue block24;
                }
                case "print_details": {
                    this.printDetails((Boolean)value);
                    continue block24;
                }
            }
            throw new IllegalArgumentException("field with name " + name + " not known");
        }
    }

    public void eventLoop() {
        while (this.looping) {
            try {
                int c = Util.keyPress(String.format(format, this.num_threads, this.time, Util.printBytes(this.msg_size), this.sync, this.oob, this.anycast_count, this.read_percentage, this.allow_local_gets, this.print_details, this.print_invokers));
                switch (c) {
                    case 49: {
                        this.startBenchmark();
                        break;
                    }
                    case 50: {
                        this.printView();
                        break;
                    }
                    case 52: {
                        this.invoke((short)6, Util.readIntFromStdin("Number of sender threads: "));
                        break;
                    }
                    case 54: {
                        this.invoke((short)7, Util.readIntFromStdin("Time (secs): "));
                        break;
                    }
                    case 55: {
                        this.invoke((short)8, Util.readIntFromStdin("Message size: "));
                        break;
                    }
                    case 97: {
                        int tmp = this.parseAnycastCount();
                        if (tmp < 0) break;
                        this.invoke((short)9, tmp);
                        break;
                    }
                    case 111: {
                        this.invoke((short)5, !this.oob);
                        break;
                    }
                    case 115: {
                        this.invoke((short)4, !this.sync);
                        break;
                    }
                    case 114: {
                        double percentage = ProgrammaticUPerf.parseReadPercentage();
                        if (!(percentage >= 0.0)) break;
                        this.invoke((short)10, percentage);
                        break;
                    }
                    case 100: {
                        this.invoke((short)13, !this.print_details);
                        break;
                    }
                    case 105: {
                        this.invoke((short)12, !this.print_invokers);
                        break;
                    }
                    case 108: {
                        this.invoke((short)11, !this.allow_local_gets);
                        break;
                    }
                    case 118: {
                        System.out.printf("Version: %s\n", Version.printVersion());
                        break;
                    }
                    case -1: 
                    case 120: {
                        this.looping = false;
                        break;
                    }
                    case 88: {
                        try {
                            RequestOptions options = new RequestOptions(ResponseMode.GET_NONE, 0L).flags(Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC);
                            this.disp.callRemoteMethods(null, new PerfUtil.CustomCall(14, new Object[0]), options);
                        }
                        catch (Throwable t) {
                            System.err.println("Calling quitAll() failed: " + t);
                        }
                        break;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.stop();
    }

    void invoke(short method_id, Object ... args2) throws Exception {
        PerfUtil.CustomCall call = new PerfUtil.CustomCall(method_id, args2);
        this.disp.callRemoteMethods(null, call, RequestOptions.SYNC());
    }

    void startBenchmark() {
        RspList responses = null;
        try {
            RequestOptions options = new RequestOptions(ResponseMode.GET_ALL, 0L);
            options.flags(Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC);
            responses = this.disp.callRemoteMethods(null, new PerfUtil.CustomCall(0, new Object[0]), options);
        }
        catch (Throwable t) {
            System.err.println("starting the benchmark failed: " + t);
            return;
        }
        long total_reqs = 0L;
        long total_time = 0L;
        AverageMinMax avg_gets = null;
        AverageMinMax avg_puts = null;
        System.out.println("\n======================= Results: ===========================");
        for (Map.Entry entry : responses.entrySet()) {
            Address mbr = (Address)entry.getKey();
            Rsp rsp = (Rsp)entry.getValue();
            PerfUtil.Results result = (PerfUtil.Results)rsp.getValue();
            if (result != null) {
                total_reqs += result.num_gets + result.num_puts;
                total_time += result.total_time;
                if (avg_gets == null) {
                    avg_gets = result.avg_gets;
                } else {
                    avg_gets.merge(result.avg_gets);
                }
                if (avg_puts == null) {
                    avg_puts = result.avg_puts;
                } else {
                    avg_puts.merge(result.avg_puts);
                }
            }
            System.out.println(mbr + ": " + result);
        }
        double total_reqs_sec = (double)total_reqs / ((double)total_time / 1000.0);
        double throughput = total_reqs_sec * (double)this.BUFFER.length;
        System.out.println("\n");
        System.out.println(Util.bold(String.format("Throughput: %,.2f reqs/sec/node (%s/sec)\nRoundtrip:  gets %s, puts %s\n", total_reqs_sec, Util.printBytes(throughput), ProgrammaticUPerf.print(avg_gets, this.print_details), ProgrammaticUPerf.print(avg_puts, this.print_details))));
        System.out.println("\n\n");
    }

    static double parseReadPercentage() throws Exception {
        double tmp = Util.readDoubleFromStdin("Read percentage: ");
        if (tmp < 0.0 || tmp > 1.0) {
            System.err.println("read percentage must be >= 0 or <= 1.0");
            return -1.0;
        }
        return tmp;
    }

    int parseAnycastCount() throws Exception {
        View tmp_view;
        int tmp = Util.readIntFromStdin("Anycast count: ");
        if (tmp > (tmp_view = this.channel.getView()).size()) {
            System.err.println("anycast count must be smaller or equal to the view size (" + tmp_view + ")\n");
            return -1;
        }
        return tmp;
    }

    protected void printView() {
        System.out.printf("\n-- local: %s, view: %s\n", this.local_addr, this.view);
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static String print(AverageMinMax avg, boolean details) {
        return details ? String.format("min/avg/max = %,.2f/%,.2f/%,.2f us", (double)avg.min() / 1000.0, avg.average() / 1000.0, (double)avg.max() / 1000.0) : String.format("avg = %,.2f us", avg.average() / 1000.0);
    }

    public static void main(String[] args2) throws Exception {
        block13: {
            String name = null;
            String bind_addr = null;
            String mcast_addr = "232.4.5.6";
            boolean run_event_loop = true;
            OneTimeAddressGenerator addr_generator = null;
            int port = 7800;
            int mcast_port = 45566;
            boolean udp = true;
            String initial_hosts = null;
            for (int i2 = 0; i2 < args2.length; ++i2) {
                if ("-name".equals(args2[i2])) {
                    name = args2[++i2];
                    continue;
                }
                if ("-nohup".equals(args2[i2])) {
                    run_event_loop = false;
                    continue;
                }
                if ("-uuid".equals(args2[i2])) {
                    addr_generator = new OneTimeAddressGenerator(Long.parseLong(args2[++i2]));
                    continue;
                }
                if ("-port".equals(args2[i2])) {
                    port = Integer.parseInt(args2[++i2]);
                    continue;
                }
                if ("-bind_addr".equals(args2[i2])) {
                    bind_addr = args2[++i2];
                    continue;
                }
                if ("-tcp".equals(args2[i2])) {
                    udp = false;
                    continue;
                }
                if ("-mcast_addr".equals(args2[i2])) {
                    mcast_addr = args2[++i2];
                    continue;
                }
                if ("-mcast_port".equals(args2[i2])) {
                    mcast_port = Integer.parseInt(args2[++i2]);
                    continue;
                }
                if ("-initial_hosts".equals(args2[i2])) {
                    initial_hosts = args2[++i2];
                    continue;
                }
                ProgrammaticUPerf.help();
                return;
            }
            ProgrammaticUPerf test = null;
            try {
                test = new ProgrammaticUPerf();
                test.init(name, addr_generator, bind_addr, port, udp, mcast_addr, mcast_port, initial_hosts);
                if (run_event_loop) {
                    test.startEventThread();
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (test == null) break block13;
                test.stop();
            }
        }
    }

    static void help() {
        System.out.printf("%s [-name name] [-nohup] [-uuid <UUID>] [-port <bind port>] [-bind_addr bind-address] [-tcp] [-mcast_addr addr] [-mcast_port port]\n[-initial_hosts hosts]", ProgrammaticUPerf.class.getSimpleName());
    }

    static {
        PerfUtil.init();
    }

    private class Invoker
    extends Thread {
        private final List<Address> dests = new ArrayList<Address>();
        private final CountDownLatch latch;
        private final AverageMinMax avg_gets = new AverageMinMax();
        private final AverageMinMax avg_puts = new AverageMinMax();
        private final List<Address> targets;
        private volatile boolean running;

        public Invoker(Collection<Address> dests, CountDownLatch latch) {
            this.targets = new ArrayList<Address>(ProgrammaticUPerf.this.anycast_count);
            this.running = true;
            this.latch = latch;
            this.dests.addAll(dests);
            this.setName("Invoker-" + ProgrammaticUPerf.this.COUNTER.getAndIncrement());
        }

        public AverageMinMax avgGets() {
            return this.avg_gets;
        }

        public AverageMinMax avgPuts() {
            return this.avg_puts;
        }

        public void cancel() {
            this.running = false;
        }

        @Override
        public void run() {
            Object[] put_args = new Object[]{0, ProgrammaticUPerf.this.BUFFER};
            Object[] get_args = new Object[]{0};
            PerfUtil.GetCall get_call = new PerfUtil.GetCall(1, get_args);
            PerfUtil.PutCall put_call = new PerfUtil.PutCall(2, put_args);
            RequestOptions get_options = new RequestOptions(ResponseMode.GET_ALL, 40000L, false, null);
            RequestOptions put_options = new RequestOptions(ProgrammaticUPerf.this.sync ? ResponseMode.GET_ALL : ResponseMode.GET_NONE, 40000L, true, null);
            if (ProgrammaticUPerf.this.oob) {
                get_options.flags(Message.Flag.OOB);
                put_options.flags(Message.Flag.OOB);
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (this.running) {
                boolean get = Util.tossWeightedCoin(ProgrammaticUPerf.this.read_percentage);
                try {
                    if (get) {
                        Address target = this.pickTarget();
                        long start = System.nanoTime();
                        if (ProgrammaticUPerf.this.allow_local_gets && Objects.equals(target, ProgrammaticUPerf.this.local_addr)) {
                            ProgrammaticUPerf.this.get(1);
                        } else {
                            ProgrammaticUPerf.this.disp.callRemoteMethod(target, get_call, get_options);
                        }
                        long get_time = System.nanoTime() - start;
                        this.avg_gets.add(get_time);
                        ProgrammaticUPerf.this.num_reads.increment();
                        continue;
                    }
                    this.pickAnycastTargets(this.targets);
                    long start = System.nanoTime();
                    ProgrammaticUPerf.this.disp.callRemoteMethods(this.targets, put_call, put_options);
                    long put_time = System.nanoTime() - start;
                    this.targets.clear();
                    this.avg_puts.add(put_time);
                    ProgrammaticUPerf.this.num_writes.increment();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        private Address pickTarget() {
            return Util.pickRandomElement(this.dests);
        }

        private void pickAnycastTargets(List<Address> anycast_targets) {
            int index = this.dests.indexOf(ProgrammaticUPerf.this.local_addr);
            for (int i2 = index + 1; i2 < index + 1 + ProgrammaticUPerf.this.anycast_count; ++i2) {
                int new_index = i2 % this.dests.size();
                Address tmp = this.dests.get(new_index);
                if (anycast_targets.contains(tmp)) continue;
                anycast_targets.add(tmp);
            }
        }
    }
}

