/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.LongAdder;
import org.jgroups.util.Util;

public class JPerf {
    private static void start(boolean client, int length, String bind_addr, String host, int port, int window_size, int interval) throws IOException {
        if (client) {
            System.out.println("-- creating socket to " + host + ":" + port);
            Socket sock = new Socket(host, port);
            if (window_size > 0) {
                sock.setReceiveBufferSize(window_size);
                sock.setSendBufferSize(window_size);
            }
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream(), 65535));
            byte[] buf = new byte[length];
            LongAdder sent = new LongAdder();
            Stats stats = new Stats(sent, true, length, interval * 1000);
            Thread stats_thread = new Thread((Runnable)stats, "sender-stats");
            stats_thread.start();
            while (true) {
                ((OutputStream)out).write(buf, 0, buf.length);
                sent.increment();
            }
        }
        InetAddress bind = InetAddress.getByName(bind_addr);
        InetSocketAddress saddr = new InetSocketAddress(bind, port);
        ServerSocket srv_sock = new ServerSocket();
        if (window_size > 0) {
            srv_sock.setReceiveBufferSize(window_size);
        }
        srv_sock.bind(saddr, 1);
        System.out.printf("------------------------------------------------------------\nServer listening on TCP port %d\nTCP window size:  %s\nLength of buffer (to send or receive): %s\n------------------------------------------------------------\n", srv_sock.getLocalPort(), Util.printBytes(window_size), Util.printBytes(length));
        System.out.printf("-- listening on %s\n", srv_sock.getLocalSocketAddress());
        while (true) {
            Socket client_sock = srv_sock.accept();
            if (window_size > 0) {
                client_sock.setReceiveBufferSize(window_size);
                client_sock.setSendBufferSize(window_size);
            }
            System.out.printf("-- accepted connection from %s\n", client_sock.getRemoteSocketAddress());
            DataInputStream in = new DataInputStream(new BufferedInputStream(client_sock.getInputStream(), 65535));
            byte[] buf = new byte[length];
            LongAdder received = new LongAdder();
            Stats stats = new Stats(received, false, length, interval * 1000);
            Thread stats_thread = new Thread((Runnable)stats, "receiver-stats");
            stats_thread.start();
            try {
                while (true) {
                    in.readFully(buf, 0, buf.length);
                    received.increment();
                }
            }
            catch (Exception ex) {
                System.out.printf("client %s closed connection: %s\n", client_sock.getRemoteSocketAddress(), ex);
                continue;
            }
            break;
        }
    }

    protected static void help() {
        System.out.println("JPerf [-help] [-c host] [-s] [-l <bytes>] [-B <bind address>] [-port <port>] [-w <bytes>] [-i <interval in secs>\n-c: client\n-s: server\n-w: TCP window size (socket buffer size)\n-l: length of buffer to write or read (in bytes)");
    }

    public static void main(String[] args2) throws IOException {
        boolean client = false;
        String bind_addr = "127.0.0.1";
        int port = 5001;
        int length = 128000;
        int window_size = 0;
        int interval = 2;
        String host = "127.0.0.1";
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (args2[i2].equals("-c")) {
                client = true;
                host = args2[++i2];
                continue;
            }
            if (args2[i2].equals("-s")) {
                client = false;
                continue;
            }
            if (args2[i2].equals("-l")) {
                length = Integer.parseInt(args2[++i2]);
                continue;
            }
            if (args2[i2].equals("-B")) {
                bind_addr = args2[++i2];
                continue;
            }
            if (args2[i2].equals("-host")) {
                host = args2[++i2];
                continue;
            }
            if (args2[i2].equals("-port")) {
                port = Integer.parseInt(args2[++i2]);
                continue;
            }
            if (args2[i2].equals("-w")) {
                window_size = Integer.parseInt(args2[++i2]);
                continue;
            }
            if (args2[i2].equals("-i")) {
                interval = Integer.parseInt(args2[++i2]);
                continue;
            }
            JPerf.help();
            return;
        }
        JPerf.start(client, length, bind_addr, host, port, window_size, interval);
    }

    protected static class Stats
    implements Runnable {
        protected final LongAdder cnt;
        protected final boolean sender;
        protected final int msg_size;
        protected final int interval;

        public Stats(LongAdder cnt, boolean sender, int msg_size, int interval) {
            this.cnt = cnt;
            this.sender = sender;
            this.msg_size = msg_size;
            this.interval = interval;
        }

        @Override
        public void run() {
            while (true) {
                long msgs_before = this.cnt.sum();
                Util.sleep(this.interval);
                long msgs_after = this.cnt.sumThenReset();
                if (msgs_after <= msgs_before) continue;
                long msgs = msgs_after - msgs_before;
                long bytes = msgs * (long)this.msg_size;
                double msgs_per_sec = (double)msgs / ((double)this.interval / 1000.0);
                double bytes_per_sec = (double)bytes / ((double)this.interval / 1000.0);
                System.out.printf("-- %s %,.2f msgs/sec %s/sec\n", this.sender ? "sent" : "received", msgs_per_sec, Util.printBytes(bytes_per_sec));
            }
        }
    }
}

