/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class UnicastTestRpc
implements Receiver {
    private JChannel channel;
    private Address local_addr;
    private RpcDispatcher disp;
    private String groupname = "UTestRpc";
    private boolean sync = true;
    private boolean oob = true;
    private boolean anycasting = false;
    private int num_threads = 25;
    private int num_msgs = 100000;
    private int msg_size = 1000;
    private int print = this.num_msgs / 10;
    private int anycast_count = 1;
    private final Collection<Address> anycast_mbrs = new ArrayList<Address>();
    private Address destination = null;
    private static final Method RECEIVE;
    private static final Method[] METHODS;
    protected final AtomicInteger num_requests = new AtomicInteger(0);

    public void init(String props, String name, String cluster_name) throws Exception {
        if (cluster_name != null) {
            this.groupname = cluster_name;
        }
        this.channel = new JChannel(props);
        if (name != null) {
            this.channel.setName(name);
        }
        this.disp = new RpcDispatcher(this.channel, this).setMethodLookup(id -> METHODS[id]).setReceiver(this);
        this.channel.connect(this.groupname);
        this.local_addr = this.channel.getAddress();
        try {
            MBeanServer server = Util.getMBeanServer();
            JmxConfigurator.registerChannel(this.channel, server, "jgroups", this.channel.getClusterName(), true);
        }
        catch (Throwable ex) {
            System.err.println("registering the channel in JMX failed: " + ex);
        }
    }

    void stop() {
        if (this.disp != null) {
            this.disp.stop();
        }
        Util.close((Closeable)this.channel);
    }

    public static void receiveData(byte[] data) {
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("** view: " + new_view);
    }

    public void eventLoop() throws Throwable {
        block15: while (true) {
            System.out.print("[1] Send msgs [2] Print view [3] Set sender threads (" + this.num_threads + ") [4] Set num msgs (" + this.num_msgs + ") \n[5] Set msg size (" + Util.printBytes(this.msg_size) + ") [6] Set anycast count (" + this.anycast_count + ")\n[o] Toggle OOB (" + this.oob + ") [s] Toggle sync (" + this.sync + ") [a] Toggle anycasting (" + this.anycasting + ")\n[q] Quit\n");
            System.out.flush();
            int c = System.in.read();
            switch (c) {
                case -1: {
                    continue block15;
                }
                case 49: {
                    try {
                        this.invokeRpcs();
                    }
                    catch (Throwable t) {
                        System.err.println(t);
                    }
                    continue block15;
                }
                case 50: {
                    this.printView();
                    continue block15;
                }
                case 51: {
                    this.setSenderThreads();
                    continue block15;
                }
                case 52: {
                    this.setNumMessages();
                    continue block15;
                }
                case 53: {
                    this.setMessageSize();
                    continue block15;
                }
                case 54: {
                    this.setAnycastCount();
                    continue block15;
                }
                case 111: {
                    this.oob = !this.oob;
                    System.out.println("oob=" + this.oob);
                    continue block15;
                }
                case 115: {
                    this.sync = !this.sync;
                    System.out.println("sync=" + this.sync);
                    continue block15;
                }
                case 97: {
                    this.anycasting = !this.anycasting;
                    System.out.println("anycasting=" + this.anycasting);
                    continue block15;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
            }
        }
    }

    void invokeRpcs() throws Throwable {
        if (this.anycasting) {
            this.populateAnycastList(this.channel.getView());
        } else {
            this.destination = this.getReceiver();
            if (this.destination == null) {
                System.err.println("UnicastTest.invokeRpcs(): receiver is null, cannot send messages");
                return;
            }
        }
        this.num_requests.set(0);
        System.out.println("invoking " + this.num_msgs + " RPCs of " + Util.printBytes(this.msg_size) + " on " + (this.anycasting ? this.anycast_mbrs : this.destination) + ", sync=" + this.sync + ", oob=" + this.oob + ", anycasting=" + this.anycasting);
        RequestOptions options = new RequestOptions(ResponseMode.GET_ALL, 15000L, this.anycasting, null);
        if (this.sync) {
            options.flags(Message.Flag.DONT_BUNDLE);
        }
        if (this.oob) {
            options.flags(Message.Flag.OOB);
        }
        options.mode(this.sync ? ResponseMode.GET_ALL : ResponseMode.GET_NONE);
        CountDownLatch latch = new CountDownLatch(1);
        Invoker[] invokers = new Invoker[this.num_threads];
        for (int i2 = 0; i2 < invokers.length; ++i2) {
            invokers[i2] = this.anycasting ? new Invoker(this.anycast_mbrs, options, latch) : new Invoker(this.destination, options, latch);
            invokers[i2].setName("invoker-" + i2);
            invokers[i2].start();
        }
        long start = System.currentTimeMillis();
        latch.countDown();
        for (Invoker invoker : invokers) {
            invoker.join();
        }
        long time = System.currentTimeMillis() - start;
        System.out.println("done invoking " + this.num_msgs + " in " + this.destination);
        double time_per_req = (double)time / (double)this.num_msgs;
        double reqs_sec = (double)this.num_msgs / ((double)time / 1000.0);
        double throughput = (double)(this.num_msgs * this.msg_size) / ((double)time / 1000.0);
        System.out.println(Util.bold("\ninvoked " + this.num_msgs + " requests in " + time + " ms: " + time_per_req + " ms/req, " + String.format("%.2f", reqs_sec) + " reqs/sec, " + Util.printBytes(throughput) + "/sec\n"));
    }

    void setSenderThreads() throws Exception {
        int threads = Util.readIntFromStdin("Number of sender threads: ");
        int old = this.num_threads;
        this.num_threads = threads;
        System.out.println("sender threads set to " + this.num_threads + " (from " + old + ")");
    }

    void setNumMessages() throws Exception {
        this.num_msgs = Util.readIntFromStdin("Number of RPCs: ");
        System.out.println("Set num_msgs=" + this.num_msgs);
        this.print = this.num_msgs / 10;
    }

    void setMessageSize() throws Exception {
        this.msg_size = Util.readIntFromStdin("Message size: ");
        System.out.println("set msg_size=" + this.msg_size);
    }

    void setAnycastCount() throws Exception {
        View view;
        int tmp = Util.readIntFromStdin("Anycast count: ");
        if (tmp > (view = this.channel.getView()).size()) {
            System.err.println("anycast count must be smaller or equal to the view size (" + view + ")\n");
            return;
        }
        this.anycast_count = tmp;
        System.out.println("set anycast_count=" + this.anycast_count);
    }

    void populateAnycastList(View view) {
        if (!this.anycasting) {
            return;
        }
        this.anycast_mbrs.clear();
        List<Address> mbrs = view.getMembers();
        int index = mbrs.indexOf(this.local_addr);
        for (int i2 = index + 1; i2 < index + 1 + this.anycast_count; ++i2) {
            int new_index = i2 % mbrs.size();
            this.anycast_mbrs.add(mbrs.get(new_index));
        }
        System.out.println("local_addr=" + this.local_addr + ", anycast_mbrs = " + this.anycast_mbrs);
    }

    void printView() {
        System.out.println("\n-- view: " + this.channel.getView() + "\n");
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Address getReceiver() {
        try {
            ArrayList<Address> mbrs = new ArrayList<Address>(this.channel.getView().getMembers());
            List<String> site_names = UnicastTestRpc.getSites(this.channel);
            for (String string : site_names) {
                try {
                    SiteMaster sm = new SiteMaster(string);
                    mbrs.add(sm);
                }
                catch (Throwable t) {
                    System.err.println("failed creating site master: " + t);
                }
            }
            System.out.println("pick receiver from the following members:");
            int i2 = 0;
            for (Address mbr : mbrs) {
                if (mbr.equals(this.channel.getAddress())) {
                    System.out.println("[" + i2 + "]: " + mbr + " (self)");
                } else {
                    System.out.println("[" + i2 + "]: " + mbr);
                }
                ++i2;
            }
            System.out.flush();
            System.in.skip(System.in.available());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String str = bufferedReader.readLine().trim();
            int index = Integer.parseInt(str);
            return (Address)mbrs.get(index);
        }
        catch (Exception e) {
            System.err.println("UnicastTest.getReceiver(): " + e);
            return null;
        }
    }

    protected static List<String> getSites(JChannel channel) {
        RELAY2 relay = (RELAY2)channel.getProtocolStack().findProtocol((Class<? extends Protocol>)RELAY2.class);
        return relay != null ? relay.siteNames() : Collections.emptyList();
    }

    public static void main(String[] args2) {
        block6: {
            String props = null;
            String name = null;
            String cluster_name = null;
            for (int i2 = 0; i2 < args2.length; ++i2) {
                if ("-props".equals(args2[i2])) {
                    props = args2[++i2];
                    continue;
                }
                if ("-name".equals(args2[i2])) {
                    name = args2[++i2];
                    continue;
                }
                if ("-cluster".endsWith(args2[i2])) {
                    cluster_name = args2[++i2];
                    continue;
                }
                UnicastTestRpc.help();
                return;
            }
            UnicastTestRpc test = null;
            try {
                test = new UnicastTestRpc();
                test.init(props, name, cluster_name);
                test.eventLoop();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (test == null) break block6;
                test.stop();
            }
        }
    }

    static void help() {
        System.out.println("UnicastTestRpc [-help] [-props <props>] [-name name] [-cluster name]");
    }

    static {
        METHODS = new Method[1];
        try {
            UnicastTestRpc.METHODS[0] = RECEIVE = UnicastTestRpc.class.getMethod("receiveData", byte[].class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private class Invoker
    extends Thread {
        private final Address dest;
        private final Collection<Address> dests;
        private final RequestOptions options;
        private final CountDownLatch latch;

        public Invoker(Address dest, RequestOptions options, CountDownLatch latch) {
            this.dest = dest;
            this.latch = latch;
            this.dests = null;
            this.options = options;
        }

        public Invoker(Collection<Address> dests, RequestOptions options, CountDownLatch latch) {
            this.latch = latch;
            this.dest = null;
            this.dests = dests;
            this.options = options;
        }

        @Override
        public void run() {
            int i2;
            byte[] buf = new byte[UnicastTestRpc.this.msg_size];
            Object[] args2 = new Object[]{buf};
            MethodCall call = new MethodCall(0, args2);
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            while ((i2 = UnicastTestRpc.this.num_requests.incrementAndGet()) <= UnicastTestRpc.this.num_msgs) {
                try {
                    if (this.dests != null) {
                        UnicastTestRpc.this.disp.callRemoteMethods(this.dests, call, this.options);
                    } else {
                        UnicastTestRpc.this.disp.callRemoteMethod(this.dest, call, this.options);
                    }
                    if (UnicastTestRpc.this.print <= 0 || i2 % UnicastTestRpc.this.print != 0) continue;
                    System.out.println("-- invoked " + i2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

