/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ObjectMessage;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.util.Util;

public class Chat
implements Receiver {
    protected JChannel channel;
    protected static final String CLUSTER = "chat";

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("** view: " + new_view);
    }

    @Override
    public void receive(Message msg) {
        String line = "[" + msg.getSrc() + "]: " + msg.getObject();
        System.out.println(line);
    }

    public void start(JChannel ch) throws Exception {
        this.channel = ch;
        this.channel.setReceiver(this);
        this.channel.connect(CLUSTER);
        this.eventLoop();
        this.channel.close();
    }

    private void start(String props, String name, boolean nohup) throws Exception {
        try {
            this.channel = new JChannel(props).name(name);
            this.channel.setReceiver(this);
            this.channel.connect(CLUSTER);
        }
        catch (Exception ex) {
            Util.close((Closeable)this.channel);
            throw ex;
        }
        if (!nohup) {
            this.eventLoop();
            this.channel.close();
        }
    }

    private void eventLoop() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        block3: while (true) {
            try {
                while (true) {
                    System.out.print("> ");
                    System.out.flush();
                    String line = in.readLine();
                    if ((line = line != null ? line.toLowerCase() : null) == null) continue;
                    if (line.startsWith("quit") || line.startsWith("exit")) break block3;
                    ObjectMessage msg = new ObjectMessage(null, line);
                    this.channel.send(msg);
                }
            }
            catch (IOException | IllegalArgumentException io_ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args2) throws Exception {
        String props = "udp.xml";
        String name = null;
        boolean nohup = false;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (args2[i2].equals("-props")) {
                props = args2[++i2];
                continue;
            }
            if (args2[i2].equals("-name")) {
                name = args2[++i2];
                continue;
            }
            if (args2[i2].equals("-nohup")) {
                nohup = true;
                continue;
            }
            Chat.help();
            return;
        }
        Chat ch = new Chat();
        ch.start(props, name, nohup);
    }

    protected static void help() {
        System.out.println("Chat [-props XML config] [-name name] [-nohup]");
    }
}

