/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.error;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.error.ErrorEvent;
import org.jdesktop.swingx.error.ErrorListener;

public class ErrorSupport {
    private List<ErrorListener> listeners;
    private Object source;

    public ErrorSupport(Object source2) {
        this.source = source2;
        this.listeners = new ArrayList<ErrorListener>();
    }

    public void addErrorListener(ErrorListener listener) {
        this.listeners.add(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.listeners.remove(listener);
    }

    public ErrorListener[] getErrorListeners() {
        return (ErrorListener[])this.listeners.toArray((T[])null);
    }

    public void fireErrorEvent(Throwable throwable) {
        final ErrorEvent evt = new ErrorEvent(throwable, this.source);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (ErrorListener el : ErrorSupport.this.listeners) {
                    el.errorOccured(evt);
                }
            }
        });
    }
}

