/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.Console;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Formatter;
import org.jboss.logmanager.formatters.Formatters;
import org.jboss.logmanager.handlers.OutputStreamHandler;
import org.jboss.logmanager.handlers.UncloseableOutputStream;
import org.jboss.logmanager.handlers.UncloseableWriter;

public class ConsoleHandler
extends OutputStreamHandler {
    private static final OutputStream out = System.out;
    private static final OutputStream err = System.err;
    private static final PrintWriter console;

    public ConsoleHandler() {
        this(Formatters.nullFormatter());
    }

    public ConsoleHandler(Formatter formatter) {
        this(console == null ? Target.SYSTEM_OUT : Target.CONSOLE, formatter);
    }

    public ConsoleHandler(Target target) {
        this(target, Formatters.nullFormatter());
    }

    public ConsoleHandler(Target target, Formatter formatter) {
        super(formatter);
        switch (target) {
            case SYSTEM_OUT: {
                this.setOutputStream(ConsoleHandler.wrap(out));
                break;
            }
            case SYSTEM_ERR: {
                this.setOutputStream(ConsoleHandler.wrap(err));
                break;
            }
            case CONSOLE: {
                this.setWriter(ConsoleHandler.wrap(console));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setTarget(Target target) {
        Target t = target == null ? (console == null ? Target.SYSTEM_OUT : Target.CONSOLE) : target;
        switch (t) {
            case SYSTEM_OUT: {
                this.setOutputStream(ConsoleHandler.wrap(out));
                break;
            }
            case SYSTEM_ERR: {
                this.setOutputStream(ConsoleHandler.wrap(err));
                break;
            }
            case CONSOLE: {
                this.setWriter(ConsoleHandler.wrap(console));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static OutputStream wrap(OutputStream outputStream2) {
        return outputStream2 == null ? null : (outputStream2 instanceof UncloseableOutputStream ? outputStream2 : new UncloseableOutputStream(outputStream2));
    }

    private static Writer wrap(Writer writer) {
        return writer == null ? null : (writer instanceof UncloseableWriter ? writer : new UncloseableWriter(writer));
    }

    @Override
    public void setOutputStream(OutputStream outputStream2) {
        super.setOutputStream(ConsoleHandler.wrap(outputStream2));
    }

    static {
        Console con = System.console();
        console = con == null ? null : con.writer();
    }

    public static enum Target {
        SYSTEM_OUT,
        SYSTEM_ERR,
        CONSOLE;

    }
}

