/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class IndentingXmlWriter
implements XMLStreamWriter,
XMLStreamConstants {
    private static final String SPACES = "    ";
    private final XMLStreamWriter delegate;
    private int index;
    private int state = 7;
    private boolean indentEnd;

    IndentingXmlWriter(XMLStreamWriter delegate) {
        this.delegate = delegate;
        this.index = 0;
        this.indentEnd = false;
    }

    private void indent() throws XMLStreamException {
        int index = this.index;
        if (index > 0) {
            for (int i2 = 0; i2 < index; ++i2) {
                this.delegate.writeCharacters(SPACES);
            }
        }
    }

    private void newline() throws XMLStreamException {
        this.delegate.writeCharacters("\n");
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.newline();
        this.indent();
        this.delegate.writeStartElement(localName);
        this.indentEnd = false;
        this.state = 1;
        ++this.index;
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.newline();
        this.indent();
        this.delegate.writeStartElement(namespaceURI, localName);
        this.indentEnd = false;
        this.state = 1;
        ++this.index;
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.newline();
        this.indent();
        this.delegate.writeStartElement(prefix, localName, namespaceURI);
        this.indentEnd = false;
        this.state = 1;
        ++this.index;
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.newline();
        this.indent();
        this.delegate.writeEmptyElement(namespaceURI, localName);
        this.state = 2;
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.newline();
        this.indent();
        this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
        this.state = 2;
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.newline();
        this.indent();
        this.delegate.writeEmptyElement(localName);
        this.state = 2;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.index;
        if (this.state != 4 || this.indentEnd) {
            this.newline();
            this.indent();
            this.indentEnd = false;
        }
        this.delegate.writeEndElement();
        this.state = 2;
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.delegate.writeEndDocument();
        this.state = 8;
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.delegate.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.newline();
        this.indent();
        this.delegate.writeComment(data);
        this.state = 5;
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.newline();
        this.indent();
        this.delegate.writeProcessingInstruction(target);
        this.state = 3;
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.newline();
        this.indent();
        this.delegate.writeProcessingInstruction(target, data);
        this.state = 3;
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.delegate.writeCData(data);
        this.state = 12;
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.newline();
        this.indent();
        this.delegate.writeDTD(dtd);
        this.state = 11;
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.delegate.writeEntityRef(name);
        this.state = 9;
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
        this.newline();
        this.state = 7;
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.delegate.writeStartDocument(version);
        this.newline();
        this.state = 7;
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.delegate.writeStartDocument(encoding, version);
        this.newline();
        this.state = 7;
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.indentEnd = false;
        boolean first = true;
        SplitIterator iterator2 = new SplitIterator(text, '\n');
        while (iterator2.hasNext()) {
            String t = (String)iterator2.next();
            if (first && iterator2.hasNext()) {
                first = false;
                this.newline();
                this.indent();
            }
            this.delegate.writeCharacters(t);
            if (!iterator2.hasNext()) continue;
            this.newline();
            this.indent();
            this.indentEnd = true;
        }
        this.state = 4;
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.delegate.writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.delegate.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.delegate.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.delegate.getProperty(name);
    }

    private static class SplitIterator
    implements Iterator<String> {
        private final String value;
        private final char delimiter;
        private int index;

        private SplitIterator(String value, char delimiter) {
            this.value = value;
            this.delimiter = delimiter;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index != -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String next() {
            String string;
            int index = this.index;
            if (index == -1) {
                throw new NoSuchElementException();
            }
            int x = this.value.indexOf(this.delimiter, index);
            try {
                string = x == -1 ? this.value.substring(index) : this.value.substring(index, x);
                this.index = x == -1 ? -1 : x + 1;
            }
            catch (Throwable throwable) {
                this.index = x == -1 ? -1 : x + 1;
                throw throwable;
            }
            return string;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

