/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.config;

import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.config.ConfigAction;
import org.jboss.logmanager.config.ErrorManagerConfiguration;
import org.jboss.logmanager.config.ErrorManagerConfigurationImpl;
import org.jboss.logmanager.config.FilterConfiguration;
import org.jboss.logmanager.config.FilterConfigurationImpl;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.FormatterConfigurationImpl;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.HandlerConfigurationImpl;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.config.LoggerConfigurationImpl;
import org.jboss.logmanager.config.ObjectProducer;
import org.jboss.logmanager.config.PojoConfiguration;
import org.jboss.logmanager.config.PojoConfigurationImpl;
import org.jboss.logmanager.config.RefProducer;
import org.jboss.logmanager.config.SimpleObjectProducer;
import org.jboss.logmanager.config.ValueExpression;
import org.jboss.logmanager.filters.AcceptAllFilter;
import org.jboss.logmanager.filters.AllFilter;
import org.jboss.logmanager.filters.AnyFilter;
import org.jboss.logmanager.filters.DenyAllFilter;
import org.jboss.logmanager.filters.InvertFilter;
import org.jboss.logmanager.filters.LevelChangingFilter;
import org.jboss.logmanager.filters.LevelFilter;
import org.jboss.logmanager.filters.LevelRangeFilter;
import org.jboss.logmanager.filters.RegexFilter;
import org.jboss.logmanager.filters.SubstituteFilter;

final class LogContextConfigurationImpl
implements LogContextConfiguration {
    private final LogContext logContext;
    private final Map<String, LoggerConfigurationImpl> loggers = new HashMap<String, LoggerConfigurationImpl>();
    private final Map<String, HandlerConfigurationImpl> handlers = new HashMap<String, HandlerConfigurationImpl>();
    private final Map<String, FormatterConfigurationImpl> formatters = new HashMap<String, FormatterConfigurationImpl>();
    private final Map<String, FilterConfigurationImpl> filters = new HashMap<String, FilterConfigurationImpl>();
    private final Map<String, ErrorManagerConfigurationImpl> errorManagers = new HashMap<String, ErrorManagerConfigurationImpl>();
    private final Map<String, PojoConfigurationImpl> pojos = new HashMap<String, PojoConfigurationImpl>();
    private final Map<String, Logger> loggerRefs = new HashMap<String, Logger>();
    private final Map<String, Handler> handlerRefs = new HashMap<String, Handler>();
    private final Map<String, Filter> filterRefs = new HashMap<String, Filter>();
    private final Map<String, Formatter> formatterRefs = new HashMap<String, Formatter>();
    private final Map<String, ErrorManager> errorManagerRefs = new HashMap<String, ErrorManager>();
    private final Map<String, Object> pojoRefs = new HashMap<String, Object>();
    private final Deque<ConfigAction<?>> transactionState = new ArrayDeque();
    private final Map<String, Deque<ConfigAction<?>>> postConfigurationTransactionState = new LinkedHashMap();
    private final Deque<ConfigAction<?>> preparedTransactions = new ArrayDeque();
    private boolean prepared = false;
    private static final ObjectProducer ACCEPT_PRODUCER = new SimpleObjectProducer(AcceptAllFilter.getInstance());
    private static final ObjectProducer DENY_PRODUCER = new SimpleObjectProducer(DenyAllFilter.getInstance());

    LogContextConfigurationImpl(LogContext logContext) {
        this.logContext = logContext;
        logContext.addCloseHandler(new LogContextConfigurationCloseHandler());
    }

    @Override
    public LogContext getLogContext() {
        return this.logContext;
    }

    @Override
    public LoggerConfiguration addLoggerConfiguration(final String loggerName) {
        if (this.loggers.containsKey(loggerName)) {
            throw new IllegalArgumentException(String.format("Logger \"%s\" already exists", loggerName));
        }
        LoggerConfigurationImpl loggerConfiguration = new LoggerConfigurationImpl(loggerName, this);
        this.loggers.put(loggerName, loggerConfiguration);
        this.transactionState.addLast(new ConfigAction<Logger>(){

            @Override
            public Logger validate() throws IllegalArgumentException {
                return LogContextConfigurationImpl.this.logContext.getLogger(loggerName);
            }

            @Override
            public void applyPreCreate(Logger param) {
                LogContextConfigurationImpl.this.loggerRefs.put(loggerName, param);
            }

            @Override
            public void applyPostCreate(Logger param) {
            }

            @Override
            public void rollback() {
                LogContextConfigurationImpl.this.loggers.remove(loggerName);
            }
        });
        return loggerConfiguration;
    }

    @Override
    public boolean removeLoggerConfiguration(String loggerName) {
        LoggerConfigurationImpl removed = this.loggers.remove(loggerName);
        if (removed != null) {
            this.transactionState.addLast(removed.getRemoveAction());
            removed.setRemoved();
            return true;
        }
        return false;
    }

    @Override
    public LoggerConfiguration getLoggerConfiguration(String loggerName) {
        return this.loggers.get(loggerName);
    }

    @Override
    public List<String> getLoggerNames() {
        return new ArrayList<String>(this.loggers.keySet());
    }

    @Override
    public HandlerConfiguration addHandlerConfiguration(String moduleName, String className, String handlerName, String ... constructorProperties) {
        if (this.handlers.containsKey(handlerName)) {
            throw new IllegalArgumentException(String.format("Handler \"%s\" already exists", handlerName));
        }
        HandlerConfigurationImpl handlerConfiguration = new HandlerConfigurationImpl(this, handlerName, moduleName, className, constructorProperties);
        this.handlers.put(handlerName, handlerConfiguration);
        this.addAction(handlerConfiguration.getConstructAction());
        return handlerConfiguration;
    }

    @Override
    public boolean removeHandlerConfiguration(String handlerName) {
        HandlerConfigurationImpl removed = this.handlers.remove(handlerName);
        if (removed != null) {
            this.transactionState.addLast(removed.getRemoveAction());
            removed.setRemoved();
            return true;
        }
        return false;
    }

    @Override
    public HandlerConfiguration getHandlerConfiguration(String handlerName) {
        return this.handlers.get(handlerName);
    }

    @Override
    public List<String> getHandlerNames() {
        return new ArrayList<String>(this.handlers.keySet());
    }

    @Override
    public FormatterConfiguration addFormatterConfiguration(String moduleName, String className, String formatterName, String ... constructorProperties) {
        if (this.formatters.containsKey(formatterName)) {
            throw new IllegalArgumentException(String.format("Formatter \"%s\" already exists", formatterName));
        }
        FormatterConfigurationImpl formatterConfiguration = new FormatterConfigurationImpl(this, formatterName, moduleName, className, constructorProperties);
        this.formatters.put(formatterName, formatterConfiguration);
        this.addAction(formatterConfiguration.getConstructAction());
        return formatterConfiguration;
    }

    @Override
    public boolean removeFormatterConfiguration(String formatterName) {
        FormatterConfigurationImpl removed = this.formatters.remove(formatterName);
        if (removed != null) {
            this.transactionState.addLast(removed.getRemoveAction());
            removed.setRemoved();
            return true;
        }
        return false;
    }

    @Override
    public FormatterConfiguration getFormatterConfiguration(String formatterName) {
        return this.formatters.get(formatterName);
    }

    @Override
    public List<String> getFormatterNames() {
        return new ArrayList<String>(this.formatters.keySet());
    }

    @Override
    public FilterConfiguration addFilterConfiguration(String moduleName, String className, String filterName, String ... constructorProperties) {
        if (this.filters.containsKey(filterName)) {
            throw new IllegalArgumentException(String.format("Filter \"%s\" already exists", filterName));
        }
        FilterConfigurationImpl filterConfiguration = new FilterConfigurationImpl(this, filterName, moduleName, className, constructorProperties);
        this.filters.put(filterName, filterConfiguration);
        this.addAction(filterConfiguration.getConstructAction());
        return filterConfiguration;
    }

    @Override
    public boolean removeFilterConfiguration(String filterName) {
        FilterConfigurationImpl removed = this.filters.remove(filterName);
        if (removed != null) {
            this.transactionState.addLast(removed.getRemoveAction());
            removed.setRemoved();
            return true;
        }
        return false;
    }

    @Override
    public FilterConfiguration getFilterConfiguration(String filterName) {
        return this.filters.get(filterName);
    }

    @Override
    public List<String> getFilterNames() {
        return new ArrayList<String>(this.filters.keySet());
    }

    @Override
    public ErrorManagerConfiguration addErrorManagerConfiguration(String moduleName, String className, String errorManagerName, String ... constructorProperties) {
        if (this.errorManagers.containsKey(errorManagerName)) {
            throw new IllegalArgumentException(String.format("ErrorManager \"%s\" already exists", errorManagerName));
        }
        ErrorManagerConfigurationImpl errorManagerConfiguration = new ErrorManagerConfigurationImpl(this, errorManagerName, moduleName, className, constructorProperties);
        this.errorManagers.put(errorManagerName, errorManagerConfiguration);
        this.addAction(errorManagerConfiguration.getConstructAction());
        return errorManagerConfiguration;
    }

    @Override
    public boolean removeErrorManagerConfiguration(String errorManagerName) {
        ErrorManagerConfigurationImpl removed = this.errorManagers.remove(errorManagerName);
        if (removed != null) {
            this.transactionState.addLast(removed.getRemoveAction());
            removed.setRemoved();
            return true;
        }
        return false;
    }

    @Override
    public ErrorManagerConfiguration getErrorManagerConfiguration(String errorManagerName) {
        return this.errorManagers.get(errorManagerName);
    }

    @Override
    public List<String> getErrorManagerNames() {
        return new ArrayList<String>(this.errorManagers.keySet());
    }

    @Override
    public PojoConfiguration addPojoConfiguration(String moduleName, String className, String pojoName, String ... constructorProperties) {
        if (this.pojos.containsKey(pojoName)) {
            throw new IllegalArgumentException(String.format("POJO \"%s\" already exists", pojoName));
        }
        PojoConfigurationImpl pojoConfiguration = new PojoConfigurationImpl(this, pojoName, moduleName, className, constructorProperties);
        this.pojos.put(pojoName, pojoConfiguration);
        this.transactionState.addLast(pojoConfiguration.getConstructAction());
        return pojoConfiguration;
    }

    @Override
    public boolean removePojoConfiguration(String pojoName) {
        PojoConfigurationImpl removed = this.pojos.remove(pojoName);
        if (removed != null) {
            this.transactionState.addLast(removed.getRemoveAction());
            removed.setRemoved();
            return true;
        }
        return false;
    }

    @Override
    public PojoConfiguration getPojoConfiguration(String pojoName) {
        return this.pojos.get(pojoName);
    }

    @Override
    public List<String> getPojoNames() {
        return new ArrayList<String>(this.pojos.keySet());
    }

    @Override
    public void prepare() {
        this.doPrepare(this.transactionState);
        for (Deque<ConfigAction<?>> items : this.postConfigurationTransactionState.values()) {
            this.doPrepare(items);
        }
        this.prepared = true;
    }

    @Override
    public void commit() {
        if (!this.prepared) {
            this.prepare();
        }
        this.clear();
    }

    private static <T> void doApplyPreCreate(ConfigAction<T> action, Object arg) {
        try {
            action.applyPreCreate(arg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static <T> void doApplyPostCreate(ConfigAction<T> action, Object arg) {
        try {
            action.applyPostCreate(arg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void forget() {
        this.doForget(this.transactionState);
        this.doForget(this.preparedTransactions);
        for (Deque<ConfigAction<?>> items : this.postConfigurationTransactionState.values()) {
            this.doForget(items);
        }
        this.clear();
    }

    private void clear() {
        this.prepared = false;
        this.postConfigurationTransactionState.clear();
        this.transactionState.clear();
        this.preparedTransactions.clear();
    }

    private void doPrepare(Deque<ConfigAction<?>> transactionState) {
        ArrayList items = new ArrayList();
        for (ConfigAction<?> action : transactionState) {
            items.add(action.validate());
            this.preparedTransactions.add(action);
        }
        Iterator iterator2 = items.iterator();
        for (ConfigAction<?> action : transactionState) {
            LogContextConfigurationImpl.doApplyPreCreate(action, iterator2.next());
        }
        iterator2 = items.iterator();
        for (ConfigAction<?> action : transactionState) {
            LogContextConfigurationImpl.doApplyPostCreate(action, iterator2.next());
        }
        transactionState.clear();
    }

    private void doForget(Deque<ConfigAction<?>> transactionState) {
        Iterator<ConfigAction<?>> iterator2 = transactionState.descendingIterator();
        while (iterator2.hasNext()) {
            ConfigAction<?> action = iterator2.next();
            try {
                action.rollback();
            }
            catch (Throwable throwable) {}
        }
    }

    void addAction(ConfigAction<?> action) {
        this.transactionState.addLast(action);
    }

    void addPostConfigurationActions(String name, Deque<ConfigAction<?>> actions) {
        if (actions != null && !actions.isEmpty()) {
            this.postConfigurationTransactionState.put(name, actions);
        }
    }

    Deque<?> removePostConfigurationActions(String name) {
        return this.postConfigurationTransactionState.remove(name);
    }

    boolean postConfigurationActionsExist(String name) {
        return this.postConfigurationTransactionState.containsKey(name);
    }

    ObjectProducer getValue(Class<?> objClass, String propertyName, Class<?> paramType, ValueExpression<String> valueExpression, boolean immediate) {
        if (valueExpression == null || valueExpression.getResolvedValue() == null) {
            if (paramType.isPrimitive()) {
                throw new IllegalArgumentException(String.format("Cannot assign null value to primitive property \"%s\" of %s", propertyName, objClass));
            }
            return ObjectProducer.NULL_PRODUCER;
        }
        String resolvedValue = valueExpression.getResolvedValue();
        String trimmedValue = resolvedValue.trim();
        if (paramType == String.class) {
            return new SimpleObjectProducer(resolvedValue);
        }
        if (paramType == Handler.class) {
            if (!this.handlers.containsKey(trimmedValue) || immediate && !this.handlerRefs.containsKey(trimmedValue)) {
                throw new IllegalArgumentException(String.format("No handler named \"%s\" is defined", trimmedValue));
            }
            if (immediate) {
                return new SimpleObjectProducer(this.handlerRefs.get(trimmedValue));
            }
            return new RefProducer(trimmedValue, this.handlerRefs);
        }
        if (paramType == Filter.class) {
            return this.resolveFilter(trimmedValue, immediate);
        }
        if (paramType == Formatter.class) {
            if (!this.formatters.containsKey(trimmedValue) || immediate && !this.formatterRefs.containsKey(trimmedValue)) {
                throw new IllegalArgumentException(String.format("No formatter named \"%s\" is defined", trimmedValue));
            }
            if (immediate) {
                return new SimpleObjectProducer(this.formatterRefs.get(trimmedValue));
            }
            return new RefProducer(trimmedValue, this.formatterRefs);
        }
        if (paramType == ErrorManager.class) {
            if (!this.errorManagers.containsKey(trimmedValue) || immediate && !this.errorManagerRefs.containsKey(trimmedValue)) {
                throw new IllegalArgumentException(String.format("No error manager named \"%s\" is defined", trimmedValue));
            }
            if (immediate) {
                return new SimpleObjectProducer(this.errorManagerRefs.get(trimmedValue));
            }
            return new RefProducer(trimmedValue, this.errorManagerRefs);
        }
        if (paramType == Level.class) {
            return new SimpleObjectProducer(LogContext.getSystemLogContext().getLevelForName(trimmedValue));
        }
        if (paramType == java.util.logging.Logger.class) {
            return new SimpleObjectProducer(LogContext.getSystemLogContext().getLogger(trimmedValue));
        }
        if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            return new SimpleObjectProducer(Boolean.valueOf(trimmedValue));
        }
        if (paramType == Byte.TYPE || paramType == Byte.class) {
            return new SimpleObjectProducer(Byte.valueOf(trimmedValue));
        }
        if (paramType == Short.TYPE || paramType == Short.class) {
            return new SimpleObjectProducer(Short.valueOf(trimmedValue));
        }
        if (paramType == Integer.TYPE || paramType == Integer.class) {
            return new SimpleObjectProducer(Integer.valueOf(trimmedValue));
        }
        if (paramType == Long.TYPE || paramType == Long.class) {
            return new SimpleObjectProducer(Long.valueOf(trimmedValue));
        }
        if (paramType == Float.TYPE || paramType == Float.class) {
            return new SimpleObjectProducer(Float.valueOf(trimmedValue));
        }
        if (paramType == Double.TYPE || paramType == Double.class) {
            return new SimpleObjectProducer(Double.valueOf(trimmedValue));
        }
        if (paramType == Character.TYPE || paramType == Character.class) {
            return new SimpleObjectProducer(Character.valueOf(trimmedValue.length() > 0 ? trimmedValue.charAt(0) : (char)'\u0000'));
        }
        if (paramType == TimeZone.class) {
            return new SimpleObjectProducer(TimeZone.getTimeZone(trimmedValue));
        }
        if (paramType == Charset.class) {
            return new SimpleObjectProducer(Charset.forName(trimmedValue));
        }
        if (paramType.isEnum()) {
            return new SimpleObjectProducer(Enum.valueOf(paramType.asSubclass(Enum.class), trimmedValue));
        }
        if (this.pojos.containsKey(trimmedValue)) {
            return new RefProducer(trimmedValue, this.pojoRefs);
        }
        throw new IllegalArgumentException("Unknown parameter type for property " + propertyName + " on " + objClass);
    }

    Map<String, Filter> getFilterRefs() {
        return this.filterRefs;
    }

    Map<String, FilterConfigurationImpl> getFilterConfigurations() {
        return this.filters;
    }

    Map<String, ErrorManager> getErrorManagerRefs() {
        return this.errorManagerRefs;
    }

    Map<String, ErrorManagerConfigurationImpl> getErrorManagerConfigurations() {
        return this.errorManagers;
    }

    Map<String, Handler> getHandlerRefs() {
        return this.handlerRefs;
    }

    Map<String, HandlerConfigurationImpl> getHandlerConfigurations() {
        return this.handlers;
    }

    Map<String, Formatter> getFormatterRefs() {
        return this.formatterRefs;
    }

    Map<String, FormatterConfigurationImpl> getFormatterConfigurations() {
        return this.formatters;
    }

    Map<String, Logger> getLoggerRefs() {
        return this.loggerRefs;
    }

    Map<String, LoggerConfigurationImpl> getLoggerConfigurations() {
        return this.loggers;
    }

    Map<String, Object> getPojoRefs() {
        return this.pojoRefs;
    }

    Map<String, PojoConfigurationImpl> getPojoConfigurations() {
        return this.pojos;
    }

    private static List<String> tokens(String source2) {
        ArrayList<String> tokens = new ArrayList<String>();
        int length = source2.length();
        int idx = 0;
        while (idx < length) {
            int start;
            block16: {
                int ch = source2.codePointAt(idx);
                if (Character.isWhitespace(ch)) {
                    ch = source2.codePointAt(idx);
                    idx = source2.offsetByCodePoints(idx, 1);
                    continue;
                }
                if (Character.isJavaIdentifierStart(ch)) {
                    start = idx;
                    while ((idx = source2.offsetByCodePoints(idx, 1)) < length && Character.isJavaIdentifierPart(ch = source2.codePointAt(idx))) {
                    }
                    tokens.add(source2.substring(start, idx));
                    continue;
                }
                if (ch != 34) break block16;
                StringBuilder b = new StringBuilder();
                b.append('\"');
                idx = source2.offsetByCodePoints(idx, 1);
                while (idx < length && (ch = source2.codePointAt(idx)) != 34) {
                    block18: {
                        block17: {
                            ch = source2.codePointAt(idx);
                            if (ch != 92) break block17;
                            if ((idx = source2.offsetByCodePoints(idx, 1)) == length) {
                                throw new IllegalArgumentException("Truncated filter expression string");
                            }
                            ch = source2.codePointAt(idx);
                            switch (ch) {
                                case 92: {
                                    b.append('\\');
                                    break block18;
                                }
                                case 39: {
                                    b.append('\'');
                                    break block18;
                                }
                                case 34: {
                                    b.append('\"');
                                    break block18;
                                }
                                case 98: {
                                    b.append('\b');
                                    break block18;
                                }
                                case 102: {
                                    b.append('\f');
                                    break block18;
                                }
                                case 110: {
                                    b.append('\n');
                                    break block18;
                                }
                                case 114: {
                                    b.append('\r');
                                    break block18;
                                }
                                case 116: {
                                    b.append('\t');
                                    break block18;
                                }
                                default: {
                                    throw new IllegalArgumentException("Invalid escape found in filter expression string");
                                }
                            }
                        }
                        b.appendCodePoint(ch);
                    }
                    idx = source2.offsetByCodePoints(idx, 1);
                }
                idx = source2.offsetByCodePoints(idx, 1);
                tokens.add(b.toString());
                continue;
            }
            start = idx;
            idx = source2.offsetByCodePoints(idx, 1);
            tokens.add(source2.substring(start, idx));
        }
        return tokens;
    }

    private ObjectProducer parseFilterExpression(Iterator<String> iterator2, boolean outermost, boolean immediate) {
        if (!iterator2.hasNext()) {
            if (outermost) {
                return ObjectProducer.NULL_PRODUCER;
            }
            throw LogContextConfigurationImpl.endOfExpression();
        }
        String token = iterator2.next();
        if ("accept".equals(token)) {
            return ACCEPT_PRODUCER;
        }
        if ("deny".equals(token)) {
            return DENY_PRODUCER;
        }
        if ("not".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator2);
            final ObjectProducer nested = this.parseFilterExpression(iterator2, false, immediate);
            LogContextConfigurationImpl.expect(")", iterator2);
            return new ObjectProducer(){

                @Override
                public Object getObject() {
                    return new InvertFilter((Filter)nested.getObject());
                }
            };
        }
        if ("all".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator2);
            final ArrayList<ObjectProducer> producers = new ArrayList<ObjectProducer>();
            do {
                producers.add(this.parseFilterExpression(iterator2, false, immediate));
            } while (LogContextConfigurationImpl.expect(",", ")", iterator2));
            return new ObjectProducer(){

                @Override
                public Object getObject() {
                    int length = producers.size();
                    Filter[] filters = new Filter[length];
                    for (int i2 = 0; i2 < length; ++i2) {
                        filters[i2] = (Filter)((ObjectProducer)producers.get(i2)).getObject();
                    }
                    return new AllFilter(filters);
                }
            };
        }
        if ("any".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator2);
            final ArrayList<ObjectProducer> producers = new ArrayList<ObjectProducer>();
            do {
                producers.add(this.parseFilterExpression(iterator2, false, immediate));
            } while (LogContextConfigurationImpl.expect(",", ")", iterator2));
            return new ObjectProducer(){

                @Override
                public Object getObject() {
                    int length = producers.size();
                    Filter[] filters = new Filter[length];
                    for (int i2 = 0; i2 < length; ++i2) {
                        filters[i2] = (Filter)((ObjectProducer)producers.get(i2)).getObject();
                    }
                    return new AnyFilter(filters);
                }
            };
        }
        if ("levelChange".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator2);
            String levelName = LogContextConfigurationImpl.expectName(iterator2);
            Level level = this.logContext.getLevelForName(levelName);
            LogContextConfigurationImpl.expect(")", iterator2);
            return new SimpleObjectProducer(new LevelChangingFilter(level));
        }
        if ("levels".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator2);
            HashSet<Level> levels = new HashSet<Level>();
            do {
                levels.add(this.logContext.getLevelForName(LogContextConfigurationImpl.expectName(iterator2)));
            } while (LogContextConfigurationImpl.expect(",", ")", iterator2));
            return new SimpleObjectProducer(new LevelFilter(levels));
        }
        if ("levelRange".equals(token)) {
            boolean minInclusive = LogContextConfigurationImpl.expect("[", "(", iterator2);
            Level minLevel = this.logContext.getLevelForName(LogContextConfigurationImpl.expectName(iterator2));
            LogContextConfigurationImpl.expect(",", iterator2);
            Level maxLevel = this.logContext.getLevelForName(LogContextConfigurationImpl.expectName(iterator2));
            boolean maxInclusive = LogContextConfigurationImpl.expect("]", ")", iterator2);
            return new SimpleObjectProducer(new LevelRangeFilter(minLevel, minInclusive, maxLevel, maxInclusive));
        }
        if ("match".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator2);
            String pattern = LogContextConfigurationImpl.expectString(iterator2);
            LogContextConfigurationImpl.expect(")", iterator2);
            return new SimpleObjectProducer(new RegexFilter(pattern));
        }
        if ("substitute".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator2);
            String pattern = LogContextConfigurationImpl.expectString(iterator2);
            LogContextConfigurationImpl.expect(",", iterator2);
            String replacement = LogContextConfigurationImpl.expectString(iterator2);
            LogContextConfigurationImpl.expect(")", iterator2);
            return new SimpleObjectProducer(new SubstituteFilter(pattern, replacement, false));
        }
        if ("substituteAll".equals(token)) {
            LogContextConfigurationImpl.expect("(", iterator2);
            String pattern = LogContextConfigurationImpl.expectString(iterator2);
            LogContextConfigurationImpl.expect(",", iterator2);
            String replacement = LogContextConfigurationImpl.expectString(iterator2);
            LogContextConfigurationImpl.expect(")", iterator2);
            return new SimpleObjectProducer(new SubstituteFilter(pattern, replacement, true));
        }
        String name = LogContextConfigurationImpl.expectName(iterator2);
        if (!this.filters.containsKey(name) || immediate && !this.filterRefs.containsKey(name)) {
            throw new IllegalArgumentException(String.format("No filter named \"%s\" is defined", name));
        }
        if (immediate) {
            return new SimpleObjectProducer(this.filterRefs.get(name));
        }
        return new RefProducer(name, this.filterRefs);
    }

    private static String expectName(Iterator<String> iterator2) {
        String next;
        if (iterator2.hasNext() && Character.isJavaIdentifierStart((next = iterator2.next()).codePointAt(0))) {
            return next;
        }
        throw new IllegalArgumentException("Expected identifier next in filter expression");
    }

    private static String expectString(Iterator<String> iterator2) {
        String next;
        if (iterator2.hasNext() && (next = iterator2.next()).codePointAt(0) == 34) {
            return next.substring(1);
        }
        throw new IllegalArgumentException("Expected string next in filter expression");
    }

    private static boolean expect(String trueToken, String falseToken, Iterator<String> iterator2) {
        boolean result;
        String next;
        boolean hasNext = iterator2.hasNext();
        String string = next = hasNext ? iterator2.next() : null;
        if (!hasNext || !(result = trueToken.equals(next)) && !falseToken.equals(next)) {
            throw new IllegalArgumentException("Expected '" + trueToken + "' or '" + falseToken + "' next in filter expression");
        }
        return result;
    }

    private static void expect(String token, Iterator<String> iterator2) {
        if (!iterator2.hasNext() || !token.equals(iterator2.next())) {
            throw new IllegalArgumentException("Expected '" + token + "' next in filter expression");
        }
    }

    private static IllegalArgumentException endOfExpression() {
        return new IllegalArgumentException("Unexpected end of filter expression");
    }

    private ObjectProducer resolveFilter(String expression, boolean immediate) {
        if (expression == null) {
            return ObjectProducer.NULL_PRODUCER;
        }
        if (this.filters.containsKey(expression)) {
            if (immediate) {
                return new SimpleObjectProducer(this.filterRefs.get(expression));
            }
            return new RefProducer(expression, this.filterRefs);
        }
        Iterator<String> iterator2 = LogContextConfigurationImpl.tokens(expression).iterator();
        ObjectProducer result = this.parseFilterExpression(iterator2, true, immediate);
        if (iterator2.hasNext()) {
            throw new IllegalArgumentException("Extra data after filter expression");
        }
        return result;
    }

    ObjectProducer resolveFilter(String expression) {
        return this.resolveFilter(expression, false);
    }

    private class LogContextConfigurationCloseHandler
    implements AutoCloseable {
        private LogContextConfigurationCloseHandler() {
        }

        @Override
        public void close() {
            LogContextConfigurationImpl configuration = LogContextConfigurationImpl.this;
            for (String name : configuration.getLoggerNames()) {
                configuration.removeLoggerConfiguration(name);
            }
            for (String name : configuration.getHandlerNames()) {
                configuration.removeHandlerConfiguration(name);
            }
            for (String name : configuration.getFilterNames()) {
                configuration.removeFilterConfiguration(name);
            }
            for (String name : configuration.getFormatterNames()) {
                configuration.removeFormatterConfiguration(name);
            }
            for (String name : configuration.getErrorManagerNames()) {
                configuration.removeErrorManagerConfiguration(name);
            }
            for (String name : configuration.getPojoNames()) {
                configuration.removePojoConfiguration(name);
            }
            configuration.commit();
        }
    }
}

