/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyValues {
    private static final int KEY = 0;
    private static final int VALUE = 1;

    public static Map<String, String> stringToMap(String s2) {
        if (s2 == null || s2.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        char[] chars = s2.toCharArray();
        int state = 0;
        block12: for (int i2 = 0; i2 < chars.length; ++i2) {
            char c = chars[i2];
            switch (state) {
                case 0: {
                    char next;
                    switch (c) {
                        case '\\': {
                            if (chars.length > ++i2 && ((next = chars[i2]) == '=' || next == '\\')) {
                                key.append(next);
                                continue block12;
                            }
                            throw new IllegalStateException("Escape character found at invalid position " + i2 + ". Only characters '=' and '\\' need to be escaped for a key.");
                        }
                        case '=': {
                            state = 1;
                            continue block12;
                        }
                    }
                    key.append(c);
                    continue block12;
                }
                case 1: {
                    char next;
                    switch (c) {
                        case '\\': {
                            if (chars.length > ++i2 && ((next = chars[i2]) == ',' || next == '\\')) {
                                value.append(next);
                                continue block12;
                            }
                            throw new IllegalStateException("Escape character found at invalid position " + i2 + ". Only characters ',' and '\\' need to be escaped for a value.");
                        }
                        case ',': {
                            if (key.length() > 0) {
                                if (value.length() == 0) {
                                    map.put(key.toString(), null);
                                } else {
                                    map.put(key.toString(), value.toString());
                                }
                                key.setLength(0);
                            }
                            value.setLength(0);
                            state = 0;
                            continue block12;
                        }
                    }
                    value.append(c);
                    continue block12;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (key.length() > 0) {
            if (value.length() == 0) {
                map.put(key.toString(), null);
            } else {
                map.put(key.toString(), value.toString());
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static <E extends Enum<E>> EnumMap<E, String> stringToEnumMap(Class<E> enumType, String s2) {
        return PropertyValues.stringToEnumMap(enumType, s2, true);
    }

    public static <E extends Enum<E>> EnumMap<E, String> stringToEnumMap(Class<E> enumType, String s2, boolean convertKeyCase) {
        EnumMap<E, String> result = new EnumMap<E, String>(enumType);
        if (s2 == null || s2.isEmpty()) {
            return result;
        }
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        char[] chars = s2.toCharArray();
        int state = 0;
        block12: for (int i2 = 0; i2 < chars.length; ++i2) {
            char c = chars[i2];
            switch (state) {
                case 0: {
                    switch (c) {
                        case '=': {
                            state = 1;
                            continue block12;
                        }
                        case '-': {
                            key.append('_');
                            continue block12;
                        }
                    }
                    if (convertKeyCase) {
                        key.append(Character.toUpperCase(c));
                        continue block12;
                    }
                    key.append(c);
                    continue block12;
                }
                case 1: {
                    switch (c) {
                        case '\\': {
                            char next;
                            if (chars.length > ++i2 && ((next = chars[i2]) == ',' || next == '\\')) {
                                value.append(next);
                                continue block12;
                            }
                            throw new IllegalStateException("Escape character found at invalid position " + i2 + ". Only characters ',' and '\\' need to be escaped for a value.");
                        }
                        case ',': {
                            if (key.length() > 0) {
                                if (value.length() == 0) {
                                    result.put(Enum.valueOf(enumType, key.toString()), null);
                                } else {
                                    result.put(Enum.valueOf(enumType, key.toString()), value.toString());
                                }
                                key.setLength(0);
                            }
                            value.setLength(0);
                            state = 0;
                            continue block12;
                        }
                    }
                    value.append(c);
                    continue block12;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (key.length() > 0) {
            if (value.length() == 0) {
                result.put(Enum.valueOf(enumType, key.toString()), null);
            } else {
                result.put(Enum.valueOf(enumType, key.toString()), value.toString());
            }
        }
        return result;
    }

    public static <K> String mapToString(Map<K, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        if (map instanceof EnumMap) {
            return PropertyValues.mapToString((EnumMap)map);
        }
        StringBuilder sb = new StringBuilder(map.size() * 32);
        Iterator<Map.Entry<K, String>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<K, String> entry = iterator2.next();
            PropertyValues.escapeKey(sb, String.valueOf(entry.getKey()));
            sb.append('=');
            PropertyValues.escapeValue(sb, entry.getValue());
            if (!iterator2.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static <K extends Enum<K>> String mapToString(EnumMap<K, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(map.size() * 32);
        Iterator<Map.Entry<K, String>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<K, String> entry = iterator2.next();
            sb.append(((Enum)entry.getKey()).name());
            sb.append('=');
            PropertyValues.escapeValue(sb, entry.getValue());
            if (!iterator2.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static void escapeKey(StringBuilder sb, String key) {
        char[] chars = key.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char c = chars[i2];
            if (c == '\\') {
                int n = i2 + 1;
                if (n >= chars.length) {
                    sb.append('\\').append('\\');
                    continue;
                }
                char next = chars[n];
                if (next == '\\' || next == '=') {
                    sb.append(c);
                    sb.append(next);
                    i2 = n;
                    continue;
                }
                sb.append('\\').append('\\');
                continue;
            }
            if (c == '=') {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
    }

    public static void escapeValue(StringBuilder sb, String value) {
        if (value != null) {
            char[] chars = value.toCharArray();
            for (int i2 = 0; i2 < chars.length; ++i2) {
                char c = chars[i2];
                if (c == '\\') {
                    int n = i2 + 1;
                    if (n >= chars.length) {
                        sb.append('\\').append('\\');
                        continue;
                    }
                    char next = chars[n];
                    if (next == '\\' || next == ',') {
                        sb.append(c);
                        sb.append(next);
                        i2 = n;
                        continue;
                    }
                    sb.append('\\').append('\\');
                    continue;
                }
                if (c == ',') {
                    sb.append('\\').append(c);
                    continue;
                }
                sb.append(c);
            }
        }
    }
}

