/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.util;

import antlr.ASTFactory;
import antlr.collections.AST;
import org.hibernate.hql.internal.ast.util.ASTUtil;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public final class PathHelper {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, PathHelper.class.getName());

    private PathHelper() {
    }

    public static AST parsePath(String path, ASTFactory factory) {
        String[] identifiers = StringHelper.split(".", path);
        AST lhs = null;
        for (int i2 = 0; i2 < identifiers.length; ++i2) {
            String identifier = identifiers[i2];
            AST child = ASTUtil.create(factory, 110, identifier);
            lhs = i2 == 0 ? child : ASTUtil.createBinarySubtree(factory, 15, ".", lhs, child);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("parsePath() : %s -> %s", (Object)path, (Object)ASTUtil.getDebugString(lhs));
        }
        return lhs;
    }

    public static String getAlias(String path) {
        return StringHelper.root(path);
    }
}

