/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.event.internal.AbstractFlushingEventListener;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class DefaultAutoFlushEventListener
extends AbstractFlushingEventListener
implements AutoFlushEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultAutoFlushEventListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAutoFlush(AutoFlushEvent event) throws HibernateException {
        EventSource source2 = event.getSession();
        SessionEventListenerManager eventListenerManager = source2.getEventListenerManager();
        try {
            eventListenerManager.partialFlushStart();
            if (this.flushMightBeNeeded(source2)) {
                ActionQueue actionQueue = source2.getActionQueue();
                int oldSize = actionQueue.numberOfCollectionRemovals();
                this.flushEverythingToExecutions(event);
                if (this.flushIsReallyNeeded(event, source2)) {
                    LOG.trace("Need to execute flush");
                    event.setFlushRequired(true);
                    this.performExecutions(source2);
                    this.postFlush(source2);
                    this.postPostFlush(source2);
                    StatisticsImplementor statistics = source2.getFactory().getStatistics();
                    if (statistics.isStatisticsEnabled()) {
                        statistics.flush();
                    }
                } else {
                    LOG.trace("Don't need to execute flush");
                    event.setFlushRequired(false);
                    actionQueue.clearFromFlushNeededCheck(oldSize);
                }
            }
        }
        finally {
            eventListenerManager.partialFlushEnd(event.getNumberOfEntitiesProcessed(), event.getNumberOfEntitiesProcessed());
        }
    }

    private boolean flushIsReallyNeeded(AutoFlushEvent event, EventSource source2) {
        return source2.getHibernateFlushMode() == FlushMode.ALWAYS || source2.getActionQueue().areTablesToBeUpdated(event.getQuerySpaces());
    }

    private boolean flushMightBeNeeded(EventSource source2) {
        PersistenceContext persistenceContext = source2.getPersistenceContextInternal();
        return !source2.getHibernateFlushMode().lessThan(FlushMode.AUTO) && source2.getDontFlushFromFind() == 0 && (persistenceContext.getNumberOfManagedEntities() > 0 || persistenceContext.getCollectionEntriesSize() > 0);
    }
}

