/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public abstract class AbstractVisitor {
    private final EventSource session;

    AbstractVisitor(EventSource session) {
        this.session = session;
    }

    void processValues(Object[] values2, Type[] types) throws HibernateException {
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (!this.includeProperty(values2, i2)) continue;
            this.processValue(i2, values2, types);
        }
    }

    public void processEntityPropertyValues(Object[] values2, Type[] types) throws HibernateException {
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (!this.includeEntityProperty(values2, i2)) continue;
            this.processValue(i2, values2, types);
        }
    }

    void processValue(int i2, Object[] values2, Type[] types) {
        this.processValue(values2[i2], types[i2]);
    }

    boolean includeEntityProperty(Object[] values2, int i2) {
        return this.includeProperty(values2, i2);
    }

    boolean includeProperty(Object[] values2, int i2) {
        return values2[i2] != LazyPropertyInitializer.UNFETCHED_PROPERTY;
    }

    Object processComponent(Object component, CompositeType componentType) throws HibernateException {
        if (component != null) {
            this.processValues(componentType.getPropertyValues(component, this.session), componentType.getSubtypes());
        }
        return null;
    }

    final Object processValue(Object value, Type type) throws HibernateException {
        if (type.isCollectionType()) {
            return this.processCollection(value, (CollectionType)type);
        }
        if (type.isEntityType()) {
            return this.processEntity(value, (EntityType)type);
        }
        if (type.isComponentType()) {
            return this.processComponent(value, (CompositeType)type);
        }
        return null;
    }

    public void process(Object object, EntityPersister persister) throws HibernateException {
        this.processEntityPropertyValues(persister.getPropertyValues(object), persister.getPropertyTypes());
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        return null;
    }

    Object processEntity(Object value, EntityType entityType) throws HibernateException {
        return null;
    }

    final EventSource getSession() {
        return this.session;
    }
}

