/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityEntryExtraState;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractReassociateEventListener;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public abstract class AbstractSaveEventListener
extends AbstractReassociateEventListener
implements CallbackRegistryConsumer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractSaveEventListener.class);
    private CallbackRegistry callbackRegistry;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    protected Serializable saveWithRequestedId(Object entity, Serializable requestedId, String entityName, Object anything, EventSource source2) {
        this.callbackRegistry.preCreate(entity);
        return this.performSave(entity, requestedId, source2.getEntityPersister(entityName, entity), false, anything, source2, true);
    }

    protected Serializable saveWithGeneratedId(Object entity, String entityName, Object anything, EventSource source2, boolean requiresImmediateIdAccess) {
        EntityPersister persister;
        Serializable generatedId;
        this.callbackRegistry.preCreate(entity);
        if (entity instanceof SelfDirtinessTracker) {
            ((SelfDirtinessTracker)entity).$$_hibernate_clearDirtyAttributes();
        }
        if ((generatedId = (persister = source2.getEntityPersister(entityName, entity)).getIdentifierGenerator().generate(source2, entity)) == null) {
            throw new IdentifierGenerationException("null id generated for:" + entity.getClass());
        }
        if (generatedId == IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR) {
            return source2.getIdentifier(entity);
        }
        if (generatedId == IdentifierGeneratorHelper.POST_INSERT_INDICATOR) {
            return this.performSave(entity, null, persister, true, anything, source2, requiresImmediateIdAccess);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Generated identifier: %s, using strategy: %s", (Object)persister.getIdentifierType().toLoggableString(generatedId, source2.getFactory()), (Object)persister.getIdentifierGenerator().getClass().getName());
        }
        return this.performSave(entity, generatedId, persister, false, anything, source2, true);
    }

    protected Serializable performSave(Object entity, Serializable id, EntityPersister persister, boolean useIdentityColumn, Object anything, EventSource source2, boolean requiresImmediateIdAccess) {
        EntityKey key;
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Saving {0}", (Object)MessageHelper.infoString(persister, id, source2.getFactory()));
        }
        if (!useIdentityColumn) {
            key = source2.generateEntityKey(id, persister);
            PersistenceContext persistenceContext = source2.getPersistenceContextInternal();
            Object old = persistenceContext.getEntity(key);
            if (old != null) {
                if (persistenceContext.getEntry(old).getStatus() == Status.DELETED) {
                    source2.forceFlush(persistenceContext.getEntry(old));
                } else {
                    throw new NonUniqueObjectException(id, persister.getEntityName());
                }
            }
            persister.setIdentifier(entity, id, source2);
        } else {
            key = null;
        }
        if (this.invokeSaveLifecycle(entity, persister, source2)) {
            return id;
        }
        return this.performSaveOrReplicate(entity, key, persister, useIdentityColumn, anything, source2, requiresImmediateIdAccess);
    }

    protected boolean invokeSaveLifecycle(Object entity, EntityPersister persister, EventSource source2) {
        if (persister.implementsLifecycle()) {
            LOG.debug("Calling onSave()");
            if (((Lifecycle)entity).onSave(source2)) {
                LOG.debug("Insertion vetoed by onSave()");
                return true;
            }
        }
        return false;
    }

    protected Serializable performSaveOrReplicate(Object entity, EntityKey key, EntityPersister persister, boolean useIdentityColumn, Object anything, EventSource source2, boolean requiresImmediateIdAccess) {
        EntityEntryExtraState extraState;
        EntityEntry newEntry;
        Serializable id = key == null ? null : key.getIdentifier();
        boolean inTrx = source2.isTransactionInProgress();
        boolean shouldDelayIdentityInserts = !inTrx && !requiresImmediateIdAccess;
        PersistenceContext persistenceContext = source2.getPersistenceContextInternal();
        EntityEntry original = persistenceContext.addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false);
        this.cascadeBeforeSave(source2, persister, entity, anything);
        Object[] values2 = persister.getPropertyValuesToInsert(entity, this.getMergeMap(anything), source2);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values2, persister, source2);
        if (persister.hasCollections()) {
            boolean bl = substitute = this.visitCollectionsBeforeSave(entity, id, values2, types, source2) || substitute;
        }
        if (substitute) {
            persister.setPropertyValues(entity, values2);
        }
        TypeHelper.deepCopy(values2, types, persister.getPropertyUpdateability(), values2, source2);
        AbstractEntityInsertAction insert = this.addInsertAction(values2, id, entity, persister, useIdentityColumn, source2, shouldDelayIdentityInserts);
        this.cascadeAfterSave(source2, persister, entity, anything);
        if (useIdentityColumn && insert.isEarlyInsert()) {
            if (!EntityIdentityInsertAction.class.isInstance(insert)) {
                throw new IllegalStateException("Insert should be using an identity column, but action is of unexpected type: " + insert.getClass().getName());
            }
            id = ((EntityIdentityInsertAction)insert).getGeneratedId();
            insert.handleNaturalIdPostSaveNotifications(id);
        }
        if ((newEntry = persistenceContext.getEntry(entity)) != original && (extraState = newEntry.getExtraState(EntityEntryExtraState.class)) == null) {
            newEntry.addExtraState(original.getExtraState(EntityEntryExtraState.class));
        }
        return id;
    }

    private AbstractEntityInsertAction addInsertAction(Object[] values2, Serializable id, Object entity, EntityPersister persister, boolean useIdentityColumn, EventSource source2, boolean shouldDelayIdentityInserts) {
        if (useIdentityColumn) {
            EntityIdentityInsertAction insert = new EntityIdentityInsertAction(values2, entity, persister, this.isVersionIncrementDisabled(), source2, shouldDelayIdentityInserts);
            source2.getActionQueue().addAction(insert);
            return insert;
        }
        Object version = Versioning.getVersion(values2, persister);
        EntityInsertAction insert = new EntityInsertAction(id, values2, entity, version, persister, this.isVersionIncrementDisabled(), source2);
        source2.getActionQueue().addAction(insert);
        return insert;
    }

    protected Map getMergeMap(Object anything) {
        return null;
    }

    protected boolean isVersionIncrementDisabled() {
        return false;
    }

    protected boolean visitCollectionsBeforeSave(Object entity, Serializable id, Object[] values2, Type[] types, EventSource source2) {
        WrapVisitor visitor = new WrapVisitor(entity, id, source2);
        visitor.processEntityPropertyValues(values2, types);
        return visitor.isSubstitutionRequired();
    }

    protected boolean substituteValuesIfNecessary(Object entity, Serializable id, Object[] values2, EntityPersister persister, SessionImplementor source2) {
        boolean substitute = source2.getInterceptor().onSave(entity, id, values2, persister.getPropertyNames(), persister.getPropertyTypes());
        if (persister.isVersioned()) {
            substitute = Versioning.seedVersion(values2, persister.getVersionProperty(), persister.getVersionType(), source2) || substitute;
        }
        return substitute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeSave(EventSource source2, EntityPersister persister, Object entity, Object anything) {
        PersistenceContext persistenceContext = source2.getPersistenceContextInternal();
        persistenceContext.incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.BEFORE_INSERT_AFTER_DELETE, source2, persister, entity, anything);
        }
        finally {
            persistenceContext.decrementCascadeLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterSave(EventSource source2, EntityPersister persister, Object entity, Object anything) {
        PersistenceContext persistenceContext = source2.getPersistenceContextInternal();
        persistenceContext.incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.AFTER_INSERT_BEFORE_DELETE, source2, persister, entity, anything);
        }
        finally {
            persistenceContext.decrementCascadeLevel();
        }
    }

    protected abstract CascadingAction getCascadeAction();
}

