/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.Type;

public class SQLCriterion
implements Criterion {
    private final String sql;
    private final TypedValue[] typedValues;

    protected SQLCriterion(String sql, Object[] values2, Type[] types) {
        this.sql = sql;
        this.typedValues = new TypedValue[values2.length];
        for (int i2 = 0; i2 < this.typedValues.length; ++i2) {
            this.typedValues[i2] = new TypedValue(types[i2], values2[i2]);
        }
    }

    protected SQLCriterion(String sql, Object value, Type type) {
        this.sql = sql;
        this.typedValues = new TypedValue[]{new TypedValue(type, value)};
    }

    protected SQLCriterion(String sql) {
        this.sql = sql;
        this.typedValues = new TypedValue[0];
    }

    @Override
    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) {
        return StringHelper.replace(this.sql, "{alias}", criteriaQuery.getSQLAlias(criteria));
    }

    @Override
    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) {
        return this.typedValues;
    }

    public String toString() {
        return this.sql;
    }
}

