/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.naming;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitCollectionTableNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;

public class ImplicitNamingStrategyLegacyJpaImpl
extends ImplicitNamingStrategyJpaCompliantImpl {
    public static final ImplicitNamingStrategyLegacyJpaImpl INSTANCE = new ImplicitNamingStrategyLegacyJpaImpl();

    @Override
    public Identifier determineCollectionTableName(ImplicitCollectionTableNameSource source2) {
        Identifier identifier = this.toIdentifier(source2.getOwningPhysicalTableName().getText() + "_" + this.transformAttributePath(source2.getOwningAttributePath()), source2.getBuildingContext());
        if (source2.getOwningPhysicalTableName().isQuoted()) {
            identifier = Identifier.quote(identifier);
        }
        return identifier;
    }

    @Override
    public Identifier determineJoinTableName(ImplicitJoinTableNameSource source2) {
        String ownerPortion = source2.getOwningPhysicalTableName();
        String ownedPortion = source2.getNonOwningPhysicalTableName() != null ? source2.getNonOwningPhysicalTableName() : this.transformAttributePath(source2.getAssociationOwningAttributePath());
        return this.toIdentifier(ownerPortion + "_" + ownedPortion, source2.getBuildingContext());
    }

    @Override
    public Identifier determineJoinColumnName(ImplicitJoinColumnNameSource source2) {
        String name = source2.getNature() == ImplicitJoinColumnNameSource.Nature.ELEMENT_COLLECTION || source2.getAttributePath() == null ? source2.getReferencedTableName().getText() + '_' + source2.getReferencedColumnName().getText() : this.transformAttributePath(source2.getAttributePath()) + '_' + source2.getReferencedColumnName().getText();
        return this.toIdentifier(name, source2.getBuildingContext());
    }
}

