/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.MainMapLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="map", category="Lookup")
public class MapLookup
implements StrLookup {
    private final Map<String, String> map;

    public MapLookup() {
        this.map = null;
    }

    public MapLookup(Map<String, String> map) {
        this.map = map;
    }

    static Map<String, String> initMap(String[] srcArgs, Map<String, String> destMap) {
        for (int i2 = 0; i2 < srcArgs.length; ++i2) {
            int next = i2 + 1;
            String value = srcArgs[i2];
            destMap.put(Integer.toString(i2), value);
            destMap.put(value, next < srcArgs.length ? srcArgs[next] : null);
        }
        return destMap;
    }

    static HashMap<String, String> newMap(int initialCapacity) {
        return new HashMap<String, String>(initialCapacity);
    }

    @Deprecated
    public static void setMainArguments(String ... args2) {
        MainMapLookup.setMainArguments(args2);
    }

    static Map<String, String> toMap(List<String> args2) {
        if (args2 == null) {
            return null;
        }
        int size = args2.size();
        return MapLookup.initMap(args2.toArray(Strings.EMPTY_ARRAY), MapLookup.newMap(size));
    }

    static Map<String, String> toMap(String[] args2) {
        if (args2 == null) {
            return null;
        }
        return MapLookup.initMap(args2, MapLookup.newMap(args2.length));
    }

    protected Map<String, String> getMap() {
        return this.map;
    }

    @Override
    public String lookup(LogEvent event, String key) {
        String obj;
        boolean isMapMessage;
        boolean bl = isMapMessage = event != null && event.getMessage() instanceof MapMessage;
        if (isMapMessage && (obj = ((MapMessage)event.getMessage()).get(key)) != null) {
            return obj;
        }
        if (this.map != null) {
            return this.map.get(key);
        }
        return null;
    }

    @Override
    public String lookup(String key) {
        if (key == null || this.map == null) {
            return null;
        }
        return this.map.get(key);
    }
}

