/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonMergePatch;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonPointer;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.BufferStrategyFactory;
import org.apache.johnzon.core.DefaultJsonPointerFactory;
import org.apache.johnzon.core.JsonBuilderFactoryImpl;
import org.apache.johnzon.core.JsonDoubleImpl;
import org.apache.johnzon.core.JsonGeneratorFactoryImpl;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.core.JsonMergePatchDiff;
import org.apache.johnzon.core.JsonMergePatchImpl;
import org.apache.johnzon.core.JsonNumberImpl;
import org.apache.johnzon.core.JsonParserFactoryImpl;
import org.apache.johnzon.core.JsonPatchBuilderImpl;
import org.apache.johnzon.core.JsonPatchDiff;
import org.apache.johnzon.core.JsonReaderFactoryImpl;
import org.apache.johnzon.core.JsonStringImpl;
import org.apache.johnzon.core.JsonWriterFactoryImpl;
import org.apache.johnzon.core.RejectDuplicateKeysMode;
import org.apache.johnzon.core.spi.JsonPointerFactory;

public class JsonProviderImpl
extends JsonProvider
implements Serializable {
    private final Supplier<BufferStrategy.BufferProvider<char[]>> bufferProvider = new Cached<BufferStrategy.BufferProvider<char[]>>(() -> BufferStrategyFactory.valueOf(System.getProperty("org.apache.johnzon.buffer-strategy", "QUEUE")).newCharProvider(Integer.getInteger("org.apache.johnzon.default-char-provider.length", 1024)));
    private final JsonReaderFactory readerFactory = new JsonReaderFactoryImpl(null);
    private final JsonParserFactory parserFactory = new JsonParserFactoryImpl(null);
    private final JsonGeneratorFactory generatorFactory = new JsonGeneratorFactoryImpl(null);
    private final JsonWriterFactory writerFactory = new JsonWriterFactoryImpl(null);
    private final Supplier<JsonBuilderFactory> builderFactory = new Cached<JsonBuilderFactory>(() -> new JsonBuilderFactoryImpl(null, this.bufferProvider.get(), RejectDuplicateKeysMode.DEFAULT));
    private final JsonPointerFactory jsonPointerFactory = StreamSupport.stream(ServiceLoader.load(JsonPointerFactory.class).spliterator(), false).min(Comparator.comparing(JsonPointerFactory::ordinal)).orElseGet(DefaultJsonPointerFactory::new);

    @Override
    public JsonParser createParser(InputStream in) {
        return this.parserFactory.createParser(in);
    }

    @Override
    public JsonParser createParser(Reader reader) {
        return this.parserFactory.createParser(reader);
    }

    @Override
    public JsonReader createReader(InputStream in) {
        return this.readerFactory.createReader(in);
    }

    @Override
    public JsonReader createReader(Reader reader) {
        return this.readerFactory.createReader(reader);
    }

    @Override
    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        return config == null || config.isEmpty() ? this.parserFactory : new JsonParserFactoryImpl(config);
    }

    @Override
    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        return config == null || config.isEmpty() ? this.readerFactory : new JsonReaderFactoryImpl(config);
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return this.generatorFactory.createGenerator(writer);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) {
        return this.generatorFactory.createGenerator(out);
    }

    @Override
    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        return config == null || config.isEmpty() ? this.generatorFactory : new JsonGeneratorFactoryImpl(config);
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return this.writerFactory.createWriter(writer);
    }

    @Override
    public JsonWriter createWriter(OutputStream out) {
        return this.writerFactory.createWriter(out);
    }

    @Override
    public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        return config == null || config.isEmpty() ? this.writerFactory : new JsonWriterFactoryImpl(config);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return this.builderFactory.get().createObjectBuilder();
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(JsonObject jsonObject) {
        return this.builderFactory.get().createObjectBuilder(jsonObject);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(Map<String, Object> initialValues) {
        return this.builderFactory.get().createObjectBuilder(initialValues);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return this.builderFactory.get().createArrayBuilder();
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(JsonArray initialData) {
        return this.builderFactory.get().createArrayBuilder(initialData);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(Collection<?> initialData) {
        return this.builderFactory.get().createArrayBuilder(initialData);
    }

    @Override
    public JsonString createValue(String value) {
        return new JsonStringImpl(value);
    }

    @Override
    public JsonNumber createValue(int value) {
        return new JsonLongImpl(value);
    }

    @Override
    public JsonNumber createValue(long value) {
        return new JsonLongImpl(value);
    }

    @Override
    public JsonNumber createValue(double value) {
        return new JsonDoubleImpl(value);
    }

    @Override
    public JsonNumber createValue(BigDecimal value) {
        return new JsonNumberImpl(value);
    }

    @Override
    public JsonNumber createValue(BigInteger value) {
        return new JsonNumberImpl(new BigDecimal(value.toString()));
    }

    @Override
    public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        JsonBuilderFactory builderFactory = this.builderFactory.get();
        return config == null || config.isEmpty() ? builderFactory : new JsonBuilderFactoryImpl(config, this.bufferProvider.get(), RejectDuplicateKeysMode.from(config));
    }

    @Override
    public JsonPatchBuilder createPatchBuilder() {
        return new JsonPatchBuilderImpl(this);
    }

    @Override
    public JsonPatchBuilder createPatchBuilder(JsonArray initialData) {
        return new JsonPatchBuilderImpl(this, initialData);
    }

    @Override
    public JsonPointer createPointer(String path) {
        return this.jsonPointerFactory.createPointer(this, path);
    }

    @Override
    public JsonPatch createPatch(JsonArray array) {
        return this.createPatchBuilder(array).build();
    }

    @Override
    public JsonPatch createDiff(JsonStructure source2, JsonStructure target) {
        return new JsonPatchDiff(this, source2, target).calculateDiff();
    }

    @Override
    public JsonMergePatch createMergePatch(JsonValue patch) {
        return new JsonMergePatchImpl(patch, this.bufferProvider.get());
    }

    @Override
    public JsonMergePatch createMergeDiff(JsonValue source2, JsonValue target) {
        return new JsonMergePatchDiff(source2, target, this.bufferProvider.get()).calculateDiff();
    }

    private static class Cached<T>
    implements Supplier<T> {
        private final Supplier<T> delegate;
        private volatile T computed;

        private Cached(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.computed == null) {
                Cached cached = this;
                synchronized (cached) {
                    if (this.computed == null) {
                        this.computed = this.delegate.get();
                    }
                }
            }
            return this.computed;
        }
    }
}

