/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import org.apache.johnzon.core.DiffBase;
import org.apache.johnzon.core.JsonPatchBuilderImpl;
import org.apache.johnzon.core.JsonPointerUtil;

class JsonPatchDiff
extends DiffBase {
    private final JsonProvider provider;
    private final JsonStructure source;
    private final JsonStructure target;

    JsonPatchDiff(JsonProvider provider, JsonStructure source2, JsonStructure target) {
        this.provider = provider;
        this.source = source2;
        this.target = target;
    }

    JsonPatch calculateDiff() {
        JsonPatchBuilderImpl patchBuilder = new JsonPatchBuilderImpl(this.provider);
        this.diff(patchBuilder, "", this.source, this.target);
        return patchBuilder.build();
    }

    private void diff(JsonPatchBuilder patchBuilder, String basePath, JsonValue source2, JsonValue target) {
        if (this.isJsonObject(source2) && this.isJsonObject(target)) {
            this.diffJsonObjects(patchBuilder, basePath + "/", (JsonObject)source2, (JsonObject)target);
        } else if (this.isJsonArray(source2) && this.isJsonArray(target)) {
            this.diffJsonArray(patchBuilder, basePath + "/", (JsonArray)source2, (JsonArray)target);
        } else if (!source2.equals(target)) {
            patchBuilder.replace(basePath, target);
        }
    }

    private void diffJsonArray(JsonPatchBuilder patchBuilder, String basePath, JsonArray source2, JsonArray target) {
        int i2;
        for (i2 = 0; i2 < source2.size(); ++i2) {
            JsonValue sourceValue = (JsonValue)source2.get(i2);
            if (target.size() <= i2) {
                patchBuilder.remove(basePath + i2);
                continue;
            }
            this.diff(patchBuilder, basePath + i2, sourceValue, (JsonValue)target.get(i2));
        }
        if (target.size() > source2.size()) {
            for (i2 = source2.size(); i2 < target.size(); ++i2) {
                patchBuilder.add(basePath + i2, (JsonValue)target.get(i2));
            }
        }
    }

    private void diffJsonObjects(JsonPatchBuilder patchBuilder, String basePath, JsonObject source2, JsonObject target) {
        for (Map.Entry sourceEntry : source2.entrySet()) {
            String attributeName = (String)sourceEntry.getKey();
            if (target.containsKey(attributeName)) {
                this.diff(patchBuilder, basePath + JsonPointerUtil.encode(attributeName), (JsonValue)sourceEntry.getValue(), (JsonValue)target.get(attributeName));
                continue;
            }
            patchBuilder.remove(basePath + JsonPointerUtil.encode(attributeName));
        }
        for (Map.Entry targetEntry : target.entrySet()) {
            if (source2.containsKey(targetEntry.getKey())) continue;
            patchBuilder.add(basePath + JsonPointerUtil.encode((String)targetEntry.getKey()), (JsonValue)targetEntry.getValue());
        }
    }
}

