/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.beanutils.BeanIntrospectionData;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.DefaultBeanIntrospector;
import org.apache.commons.beanutils.DefaultIntrospectionContext;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.SuppressPropertiesBeanIntrospector;
import org.apache.commons.beanutils.WeakFastHashMap;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyUtilsBean {
    private Resolver resolver = new DefaultResolver();
    private WeakFastHashMap<Class<?>, BeanIntrospectionData> descriptorsCache = null;
    private WeakFastHashMap<Class<?>, FastHashMap> mappedDescriptorsCache = null;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Log log = LogFactory.getLog(PropertyUtils.class);
    private final List<BeanIntrospector> introspectors;

    protected static PropertyUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getPropertyUtils();
    }

    public PropertyUtilsBean() {
        this.descriptorsCache = new WeakFastHashMap();
        this.descriptorsCache.setFast(true);
        this.mappedDescriptorsCache = new WeakFastHashMap();
        this.mappedDescriptorsCache.setFast(true);
        this.introspectors = new CopyOnWriteArrayList<BeanIntrospector>();
        this.resetBeanIntrospectors();
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver == null ? new DefaultResolver() : resolver;
    }

    public final void resetBeanIntrospectors() {
        this.introspectors.clear();
        this.introspectors.add(DefaultBeanIntrospector.INSTANCE);
        this.introspectors.add(SuppressPropertiesBeanIntrospector.SUPPRESS_CLASS);
    }

    public void addBeanIntrospector(BeanIntrospector introspector) {
        if (introspector == null) {
            throw new IllegalArgumentException("BeanIntrospector must not be null!");
        }
        this.introspectors.add(introspector);
    }

    public boolean removeBeanIntrospector(BeanIntrospector introspector) {
        return this.introspectors.remove(introspector);
    }

    public void clearDescriptors() {
        this.descriptorsCache.clear();
        this.mappedDescriptorsCache.clear();
        Introspector.flushCaches();
    }

    public void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors;
            for (DynaProperty origDescriptor : origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties()) {
                String name = origDescriptor.getName();
                if (!this.isReadable(orig, name) || !this.isWriteable(dest, name)) continue;
                try {
                    Object value = ((DynaBean)orig).get(name);
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name, value);
                        continue;
                    }
                    this.setSimpleProperty(dest, name, value);
                }
                catch (NoSuchMethodException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Error writing to '" + name + "' on class '" + dest.getClass() + "'", e);
                }
            }
        } else if (orig instanceof Map) {
            for (Map.Entry entry : ((Map)orig).entrySet()) {
                String name = (String)entry.getKey();
                if (!this.isWriteable(dest, name)) continue;
                try {
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name, entry.getValue());
                        continue;
                    }
                    this.setSimpleProperty(dest, name, entry.getValue());
                }
                catch (NoSuchMethodException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Error writing to '" + name + "' on class '" + dest.getClass() + "'", e);
                }
            }
        } else {
            PropertyDescriptor[] origDescriptors;
            for (PropertyDescriptor origDescriptor : origDescriptors = this.getPropertyDescriptors(orig)) {
                String name = origDescriptor.getName();
                if (!this.isReadable(orig, name) || !this.isWriteable(dest, name)) continue;
                try {
                    Object value = this.getSimpleProperty(orig, name);
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name, value);
                        continue;
                    }
                    this.setSimpleProperty(dest, name, value);
                }
                catch (NoSuchMethodException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Error writing to '" + name + "' on class '" + dest.getClass() + "'", e);
                }
            }
        }
    }

    public Map<String, Object> describe(Object bean2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        HashMap<String, Object> description = new HashMap<String, Object>();
        if (bean2 instanceof DynaBean) {
            DynaProperty[] descriptors;
            for (DynaProperty descriptor : descriptors = ((DynaBean)bean2).getDynaClass().getDynaProperties()) {
                String name = descriptor.getName();
                description.put(name, this.getProperty(bean2, name));
            }
        } else {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = this.getPropertyDescriptors(bean2)) {
                String name = descriptor.getName();
                if (descriptor.getReadMethod() == null) continue;
                description.put(name, this.getProperty(bean2, name));
            }
        }
        return description;
    }

    public Object getIndexedProperty(Object bean2, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        int index = -1;
        try {
            index = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean2.getClass() + "' " + e.getMessage());
        }
        if (index < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getIndexedProperty(bean2, name, index);
    }

    public Object getIndexedProperty(Object bean2, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null || name.length() == 0) {
            if (bean2.getClass().isArray()) {
                return Array.get(bean2, index);
            }
            if (bean2 instanceof List) {
                return ((List)bean2).get(index);
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean2).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean2.getClass() + "'");
            }
            return ((DynaBean)bean2).get(name, index);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean2, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            readMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), readMethod);
            if (readMethod != null) {
                Object[] subscript = new Object[]{new Integer(index)};
                try {
                    return this.invokeMethod(readMethod, bean2, subscript);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof IndexOutOfBoundsException) {
                        throw (IndexOutOfBoundsException)e.getTargetException();
                    }
                    throw e;
                }
            }
        }
        if ((readMethod = this.getReadMethod(bean2.getClass(), descriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method on bean class '" + bean2.getClass() + "'");
        }
        Object value = this.invokeMethod(readMethod, bean2, EMPTY_OBJECT_ARRAY);
        if (!value.getClass().isArray()) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean2.getClass() + "'");
            }
            return ((List)value).get(index);
        }
        try {
            return Array.get(value, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", Size: " + Array.getLength(value) + " for property '" + name + "'");
        }
    }

    public Object getMappedProperty(Object bean2, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        String key = null;
        try {
            key = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean2.getClass() + "' " + e.getMessage());
        }
        if (key == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getMappedProperty(bean2, name, key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMappedProperty(Object bean2, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified for property '" + name + "' on bean class " + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean2).getDynaClass().getDynaProperty(name);
            if (descriptor != null) return ((DynaBean)bean2).get(name, key);
            throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + bean2.getClass() + "'");
        }
        Object result = null;
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean2, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + bean2.getClass() + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method readMethod = ((MappedPropertyDescriptor)descriptor).getMappedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), readMethod);
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean2.getClass() + "'");
            Object[] keyArray = new Object[]{key};
            return this.invokeMethod(readMethod, bean2, keyArray);
        }
        Method readMethod = this.getReadMethod(bean2.getClass(), descriptor);
        if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean2.getClass() + "'");
        Object invokeResult = this.invokeMethod(readMethod, bean2, EMPTY_OBJECT_ARRAY);
        if (!(invokeResult instanceof Map)) return result;
        return ((Map)invokeResult).get(key);
    }

    @Deprecated
    public FastHashMap getMappedPropertyDescriptors(Class<?> beanClass) {
        if (beanClass == null) {
            return null;
        }
        return this.mappedDescriptorsCache.get(beanClass);
    }

    @Deprecated
    public FastHashMap getMappedPropertyDescriptors(Object bean2) {
        if (bean2 == null) {
            return null;
        }
        return this.getMappedPropertyDescriptors(bean2.getClass());
    }

    public Object getNestedProperty(Object bean2, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            nestedBean = bean2 instanceof Map ? this.getPropertyOfMapBean((Map)bean2, next) : (this.resolver.isMapped(next) ? this.getMappedProperty(bean2, next) : (this.resolver.isIndexed(next) ? this.getIndexedProperty(bean2, next) : this.getSimpleProperty(bean2, next)));
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + name + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name = this.resolver.remove(name);
        }
        bean2 = bean2 instanceof Map ? this.getPropertyOfMapBean((Map)bean2, name) : (this.resolver.isMapped(name) ? this.getMappedProperty(bean2, name) : (this.resolver.isIndexed(name) ? this.getIndexedProperty(bean2, name) : this.getSimpleProperty(bean2, name)));
        return bean2;
    }

    protected Object getPropertyOfMapBean(Map<?, ?> bean2, String propertyName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name;
        if (this.resolver.isMapped(propertyName) && ((name = this.resolver.getProperty(propertyName)) == null || name.length() == 0)) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        return bean2.get(propertyName);
    }

    public Object getProperty(Object bean2, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean2, name);
    }

    public PropertyDescriptor getPropertyDescriptor(Object bean2, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = this.getProperty(bean2, next);
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name = this.resolver.remove(name);
        }
        if ((name = this.resolver.getProperty(name)) == null) {
            return null;
        }
        BeanIntrospectionData data = this.getIntrospectionData(bean2.getClass());
        PropertyDescriptor result = data.getDescriptor(name);
        if (result != null) {
            return result;
        }
        FastHashMap mappedDescriptors = this.getMappedPropertyDescriptors(bean2);
        if (mappedDescriptors == null) {
            mappedDescriptors = new FastHashMap();
            mappedDescriptors.setFast(true);
            this.mappedDescriptorsCache.put(bean2.getClass(), mappedDescriptors);
        }
        if ((result = (PropertyDescriptor)mappedDescriptors.get(name)) == null) {
            try {
                result = new MappedPropertyDescriptor(name, bean2.getClass());
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            if (result != null) {
                mappedDescriptors.put(name, result);
            }
        }
        return result;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        return this.getIntrospectionData(beanClass).getDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object bean2) {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        return this.getPropertyDescriptors(bean2.getClass());
    }

    public Class<?> getPropertyEditorClass(Object bean2, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean2, name);
        if (descriptor != null) {
            return descriptor.getPropertyEditorClass();
        }
        return null;
    }

    public Class<?> getPropertyType(Object bean2, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object descriptor;
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = this.getProperty(bean2, next);
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean2 instanceof DynaBean) {
            descriptor = ((DynaBean)bean2).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                return null;
            }
            Class<?> type = ((DynaProperty)descriptor).getType();
            if (type == null) {
                return null;
            }
            if (type.isArray()) {
                return type.getComponentType();
            }
            return type;
        }
        descriptor = this.getPropertyDescriptor(bean2, name);
        if (descriptor == null) {
            return null;
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType();
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            return ((MappedPropertyDescriptor)descriptor).getMappedPropertyType();
        }
        return ((PropertyDescriptor)descriptor).getPropertyType();
    }

    public Method getReadMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getReadMethod());
    }

    Method getReadMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(clazz, descriptor.getReadMethod());
    }

    public Object getSimpleProperty(Object bean2, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean2).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean2).getDynaClass() + "'");
            }
            return ((DynaBean)bean2).get(name);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean2, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean2.getClass() + "'");
        }
        Method readMethod = this.getReadMethod(bean2.getClass(), descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method in class '" + bean2.getClass() + "'");
        }
        Object value = this.invokeMethod(readMethod, bean2, EMPTY_OBJECT_ARRAY);
        return value;
    }

    public Method getWriteMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getWriteMethod());
    }

    public Method getWriteMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        BeanIntrospectionData data = this.getIntrospectionData(clazz);
        return MethodUtils.getAccessibleMethod(clazz, data.getWriteMethod(clazz, descriptor));
    }

    public boolean isReadable(Object bean2, String name) {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            try {
                nestedBean = this.getProperty(bean2, next);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean2 instanceof WrapDynaBean) {
            bean2 = ((WrapDynaBean)bean2).getInstance();
        }
        if (bean2 instanceof DynaBean) {
            return ((DynaBean)bean2).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean2, name);
            if (desc != null) {
                Method readMethod = this.getReadMethod(bean2.getClass(), desc);
                if (readMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        readMethod = ((IndexedPropertyDescriptor)desc).getIndexedReadMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        readMethod = ((MappedPropertyDescriptor)desc).getMappedReadMethod();
                    }
                    readMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), readMethod);
                }
                return readMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean isWriteable(Object bean2, String name) {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            try {
                nestedBean = this.getProperty(bean2, next);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean2 instanceof WrapDynaBean) {
            bean2 = ((WrapDynaBean)bean2).getInstance();
        }
        if (bean2 instanceof DynaBean) {
            return ((DynaBean)bean2).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean2, name);
            if (desc != null) {
                Method writeMethod = this.getWriteMethod(bean2.getClass(), desc);
                if (writeMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        writeMethod = ((IndexedPropertyDescriptor)desc).getIndexedWriteMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        writeMethod = ((MappedPropertyDescriptor)desc).getMappedWriteMethod();
                    }
                    writeMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), writeMethod);
                }
                return writeMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public void setIndexedProperty(Object bean2, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        int index = -1;
        try {
            index = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setIndexedProperty(bean2, name, index, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIndexedProperty(Object bean2, String name, int index, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null || name.length() == 0) {
            if (bean2.getClass().isArray()) {
                Array.set(bean2, index, value);
                return;
            }
            if (bean2 instanceof List) {
                List<Object> list = PropertyUtilsBean.toObjectList(bean2);
                list.set(index, value);
                return;
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean2).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean2.getClass() + "'");
            }
            ((DynaBean)bean2).set(name, index, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean2, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            Method writeMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod();
            writeMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), writeMethod);
            if (writeMethod != null) {
                Object[] subscript = new Object[]{new Integer(index), value};
                try {
                    if (this.log.isTraceEnabled()) {
                        String valueClassName = value == null ? "<null>" : value.getClass().getName();
                        this.log.trace("setSimpleProperty: Invoking method " + writeMethod + " with index=" + index + ", value=" + value + " (class " + valueClassName + ")");
                    }
                    this.invokeMethod(writeMethod, bean2, subscript);
                    return;
                }
                catch (InvocationTargetException e) {
                    if (!(e.getTargetException() instanceof IndexOutOfBoundsException)) throw e;
                    throw (IndexOutOfBoundsException)e.getTargetException();
                }
            }
        }
        if ((readMethod = this.getReadMethod(bean2.getClass(), descriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method on bean class '" + bean2.getClass() + "'");
        }
        Object array = this.invokeMethod(readMethod, bean2, EMPTY_OBJECT_ARRAY);
        if (!array.getClass().isArray()) {
            if (!(array instanceof List)) throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean2.getClass() + "'");
            List<Object> list = PropertyUtilsBean.toObjectList(array);
            list.set(index, value);
            return;
        } else {
            Array.set(array, index, value);
        }
    }

    public void setMappedProperty(Object bean2, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        String key = null;
        try {
            key = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setMappedProperty(bean2, name, key, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMappedProperty(Object bean2, String name, String key, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified for property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean2).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean2.getClass() + "'");
            }
            ((DynaBean)bean2).set(name, key, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean2, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method mappedWriteMethod = ((MappedPropertyDescriptor)descriptor).getMappedWriteMethod();
            mappedWriteMethod = MethodUtils.getAccessibleMethod(bean2.getClass(), mappedWriteMethod);
            if (mappedWriteMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped setter methodon bean class '" + bean2.getClass() + "'");
            Object[] params = new Object[]{key, value};
            if (this.log.isTraceEnabled()) {
                String valueClassName = value == null ? "<null>" : value.getClass().getName();
                this.log.trace("setSimpleProperty: Invoking method " + mappedWriteMethod + " with key=" + key + ", value=" + value + " (class " + valueClassName + ")");
            }
            this.invokeMethod(mappedWriteMethod, bean2, params);
            return;
        } else {
            Method readMethod = this.getReadMethod(bean2.getClass(), descriptor);
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean2.getClass() + "'");
            Object invokeResult = this.invokeMethod(readMethod, bean2, EMPTY_OBJECT_ARRAY);
            if (!(invokeResult instanceof Map)) return;
            Map<String, Object> map = PropertyUtilsBean.toPropertyMap(invokeResult);
            map.put(key, value);
        }
    }

    public void setNestedProperty(Object bean2, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            nestedBean = bean2 instanceof Map ? this.getPropertyOfMapBean((Map)bean2, next) : (this.resolver.isMapped(next) ? this.getMappedProperty(bean2, next) : (this.resolver.isIndexed(next) ? this.getIndexedProperty(bean2, next) : this.getSimpleProperty(bean2, next)));
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + name + "' on bean class '" + bean2.getClass() + "'");
            }
            bean2 = nestedBean;
            name = this.resolver.remove(name);
        }
        if (bean2 instanceof Map) {
            this.setPropertyOfMapBean(PropertyUtilsBean.toPropertyMap(bean2), name, value);
        } else if (this.resolver.isMapped(name)) {
            this.setMappedProperty(bean2, name, value);
        } else if (this.resolver.isIndexed(name)) {
            this.setIndexedProperty(bean2, name, value);
        } else {
            this.setSimpleProperty(bean2, name, value);
        }
    }

    protected void setPropertyOfMapBean(Map<String, Object> bean2, String propertyName, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name;
        if (this.resolver.isMapped(propertyName) && ((name = this.resolver.getProperty(propertyName)) == null || name.length() == 0)) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        bean2.put(propertyName, value);
    }

    public void setProperty(Object bean2, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.setNestedProperty(bean2, name, value);
    }

    public void setSimpleProperty(Object bean2, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean2.getClass() + "'");
        }
        if (bean2 instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean2).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean2).getDynaClass() + "'");
            }
            ((DynaBean)bean2).set(name, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean2, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean2.getClass() + "'");
        }
        Method writeMethod = this.getWriteMethod(bean2.getClass(), descriptor);
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method in class '" + bean2.getClass() + "'");
        }
        Object[] values2 = new Object[]{value};
        if (this.log.isTraceEnabled()) {
            String valueClassName = value == null ? "<null>" : value.getClass().getName();
            this.log.trace("setSimpleProperty: Invoking method " + writeMethod + " with value " + value + " (class " + valueClassName + ")");
        }
        this.invokeMethod(writeMethod, bean2, values2);
    }

    private Object invokeMethod(Method method, Object bean2, Object[] values2) throws IllegalAccessException, InvocationTargetException {
        if (bean2 == null) {
            throw new IllegalArgumentException("No bean specified - this should have been checked before reaching this method");
        }
        try {
            return method.invoke(bean2, values2);
        }
        catch (NullPointerException cause) {
            IllegalArgumentException e;
            String valueString = "";
            if (values2 != null) {
                for (int i2 = 0; i2 < values2.length; ++i2) {
                    if (i2 > 0) {
                        valueString = valueString + ", ";
                    }
                    valueString = values2[i2] == null ? valueString + "<null>" : valueString + values2[i2].getClass().getName();
                }
            }
            String expectedString = "";
            Class<?>[] parTypes = method.getParameterTypes();
            if (parTypes != null) {
                for (int i3 = 0; i3 < parTypes.length; ++i3) {
                    if (i3 > 0) {
                        expectedString = expectedString + ", ";
                    }
                    expectedString = expectedString + parTypes[i3].getName();
                }
            }
            if (!BeanUtils.initCause(e = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean2.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\""), cause)) {
                this.log.error("Method invocation failed", cause);
            }
            throw e;
        }
        catch (IllegalArgumentException cause) {
            IllegalArgumentException e;
            String valueString = "";
            if (values2 != null) {
                for (int i4 = 0; i4 < values2.length; ++i4) {
                    if (i4 > 0) {
                        valueString = valueString + ", ";
                    }
                    valueString = values2[i4] == null ? valueString + "<null>" : valueString + values2[i4].getClass().getName();
                }
            }
            String expectedString = "";
            Class<?>[] parTypes = method.getParameterTypes();
            if (parTypes != null) {
                for (int i5 = 0; i5 < parTypes.length; ++i5) {
                    if (i5 > 0) {
                        expectedString = expectedString + ", ";
                    }
                    expectedString = expectedString + parTypes[i5].getName();
                }
            }
            if (!BeanUtils.initCause(e = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean2.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\""), cause)) {
                this.log.error("Method invocation failed", cause);
            }
            throw e;
        }
    }

    private BeanIntrospectionData getIntrospectionData(Class<?> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        BeanIntrospectionData data = this.descriptorsCache.get(beanClass);
        if (data == null) {
            data = this.fetchIntrospectionData(beanClass);
            this.descriptorsCache.put(beanClass, data);
        }
        return data;
    }

    private BeanIntrospectionData fetchIntrospectionData(Class<?> beanClass) {
        DefaultIntrospectionContext ictx = new DefaultIntrospectionContext(beanClass);
        for (BeanIntrospector bi : this.introspectors) {
            try {
                bi.introspect(ictx);
            }
            catch (IntrospectionException iex) {
                this.log.error("Exception during introspection", iex);
            }
        }
        return new BeanIntrospectionData(ictx.getPropertyDescriptors());
    }

    private static List<Object> toObjectList(Object obj) {
        List list = (List)obj;
        return list;
    }

    private static Map<String, Object> toPropertyMap(Object obj) {
        Map map = (Map)obj;
        return map;
    }
}

