/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.apache.activemq.artemis.utils.collections.RepeatableIterator;
import org.apache.activemq.artemis.utils.collections.RepeatableIteratorWrapper;
import org.apache.activemq.artemis.utils.collections.ResettableIterator;

public class UpdatableIterator<E>
implements ResettableIterator<E>,
RepeatableIterator<E> {
    private static final AtomicReferenceFieldUpdater<UpdatableIterator, RepeatableIteratorWrapper> changedIteratorFieldUpdater = AtomicReferenceFieldUpdater.newUpdater(UpdatableIterator.class, RepeatableIteratorWrapper.class, "changedIterator");
    private volatile RepeatableIteratorWrapper<E> changedIterator;
    private RepeatableIteratorWrapper<E> currentIterator;

    public UpdatableIterator(ResettableIterator<E> iterator2) {
        this.currentIterator = new RepeatableIteratorWrapper<E>(iterator2);
    }

    public void update(ResettableIterator<E> iterator2) {
        changedIteratorFieldUpdater.set(this, new RepeatableIteratorWrapper<E>(iterator2));
    }

    @Override
    public void reset() {
        RepeatableIteratorWrapper<E> changedIterator = this.changedIterator;
        if (changedIterator != null) {
            this.currentIterator = changedIterator;
            changedIteratorFieldUpdater.compareAndSet(this, changedIterator, null);
        }
        this.currentIterator.reset();
    }

    @Override
    public boolean hasNext() {
        return this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        this.currentIterator.forEachRemaining(action);
    }

    @Override
    public void repeat() {
        this.currentIterator.repeat();
    }
}

