/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.ArrayList;
import java.util.Iterator;

public class SelectorTranslator {
    public static String convertToActiveMQFilterString(String selectorString) {
        if (selectorString == null) {
            return null;
        }
        String filterString = SelectorTranslator.parse(selectorString, "JMSDeliveryMode", "AMQDurable");
        filterString = SelectorTranslator.parse(filterString, "'PERSISTENT'", "'DURABLE'");
        filterString = SelectorTranslator.parse(filterString, "'NON_PERSISTENT'", "'NON_DURABLE'");
        filterString = SelectorTranslator.parse(filterString, "JMSPriority", "AMQPriority");
        filterString = SelectorTranslator.parse(filterString, "JMSTimestamp", "AMQTimestamp");
        filterString = SelectorTranslator.parse(filterString, "JMSMessageID", "AMQUserID");
        filterString = SelectorTranslator.parse(filterString, "JMSExpiration", "AMQExpiration");
        filterString = SelectorTranslator.parse(filterString, "JMSXGroupID", "AMQGroupID");
        return filterString;
    }

    public static String convertHQToActiveMQFilterString(String hqFilterString) {
        if (hqFilterString == null) {
            return null;
        }
        String filterString = SelectorTranslator.parse(hqFilterString, "HQDurable", "AMQDurable");
        filterString = SelectorTranslator.parse(filterString, "HQPriority", "AMQPriority");
        filterString = SelectorTranslator.parse(filterString, "HQTimestamp", "AMQTimestamp");
        filterString = SelectorTranslator.parse(filterString, "HQUserID", "AMQUserID");
        filterString = SelectorTranslator.parse(filterString, "HQExpiration", "AMQExpiration");
        return filterString;
    }

    private static String parse(String input, String match, String replace) {
        int quote = 39;
        boolean inQuote = false;
        int matchPos = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        boolean replaceInQuotes = match.charAt(0) == '\'';
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char c = input.charAt(i2);
            if (c == '\'') {
                boolean bl = inQuote = !inQuote;
            }
            if ((!inQuote || replaceInQuotes) && c == match.charAt(matchPos)) {
                int posBeforeStart;
                if (++matchPos != match.length()) continue;
                boolean matched = true;
                if (i2 < input.length() - 1 && Character.isJavaIdentifierPart(input.charAt(i2 + 1))) {
                    matched = false;
                }
                if ((posBeforeStart = i2 - match.length()) >= 0 && Character.isJavaIdentifierPart(input.charAt(posBeforeStart))) {
                    matched = false;
                }
                if (matched) {
                    positions.add(i2 - match.length() + 1);
                }
                matchPos = 0;
                continue;
            }
            matchPos = 0;
        }
        if (!positions.isEmpty()) {
            StringBuffer buff = new StringBuffer();
            int startPos = 0;
            Iterator iterator2 = positions.iterator();
            while (iterator2.hasNext()) {
                int pos = (Integer)iterator2.next();
                String substr = input.substring(startPos, pos);
                buff.append(substr);
                buff.append(replace);
                startPos = pos + match.length();
            }
            if (startPos < input.length()) {
                buff.append(input.substring(startPos, input.length()));
            }
            return buff.toString();
        }
        return input;
    }
}

