/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri.schema.connector;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.uri.schema.connector.AbstractTransportConfigurationSchema;

public class InVMTransportConfigurationSchema
extends AbstractTransportConfigurationSchema {
    public static final String CONNECTIONS_ALLOWED = "connectionsAllowed";
    public static final String SECURITY_DOMAIN = "securityDomain";

    @Override
    public String getSchemaName() {
        return "vm";
    }

    @Override
    protected List<TransportConfiguration> internalNewObject(URI uri, Map<String, String> query2, String name) throws Exception {
        ArrayList<TransportConfiguration> configurations = new ArrayList<TransportConfiguration>();
        configurations.add(InVMTransportConfigurationSchema.createTransportConfiguration(uri, query2, name, this.getFactoryName()));
        return configurations;
    }

    @Override
    protected URI internalNewURI(List<TransportConfiguration> bean2) throws Exception {
        return null;
    }

    protected String getFactoryName() {
        return "org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory";
    }

    public static TransportConfiguration createTransportConfiguration(URI uri, Map<String, String> query2, String name, String factoryName) {
        HashMap<String, Object> inVmTransportConfig = new HashMap<String, Object>();
        inVmTransportConfig.put("serverId", uri.getHost());
        if (query2.containsKey(CONNECTIONS_ALLOWED)) {
            inVmTransportConfig.put(CONNECTIONS_ALLOWED, query2.get(CONNECTIONS_ALLOWED));
        } else if (query2.containsKey(SECURITY_DOMAIN)) {
            inVmTransportConfig.put(SECURITY_DOMAIN, query2.get(SECURITY_DOMAIN));
        }
        return new TransportConfiguration(factoryName, inVmTransportConfig, name);
    }
}

