/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.PrincipalsCallback;

public class JaasCallbackHandler
implements CallbackHandler {
    private final String username;
    private final String password;
    final RemotingConnection remotingConnection;

    public JaasCallbackHandler(String username, String password, RemotingConnection remotingConnection) {
        this.username = username;
        this.password = password;
        this.remotingConnection = remotingConnection;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                if (this.password == null) {
                    passwordCallback.setPassword(null);
                    continue;
                }
                passwordCallback.setPassword(this.password.toCharArray());
                continue;
            }
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                if (this.username == null) {
                    nameCallback.setName(null);
                    continue;
                }
                nameCallback.setName(this.username);
                continue;
            }
            if (callback instanceof CertificateCallback) {
                CertificateCallback certCallback = (CertificateCallback)callback;
                certCallback.setCertificates(CertificateUtil.getCertsFromConnection(this.remotingConnection));
                continue;
            }
            if (callback instanceof PrincipalsCallback) {
                Principal peerPrincipalFromConnection;
                PrincipalsCallback principalsCallback = (PrincipalsCallback)callback;
                Subject peerSubject = this.remotingConnection.getSubject();
                if (peerSubject != null) {
                    Iterator<KerberosPrincipal> iterator2 = peerSubject.getPrivateCredentials(KerberosPrincipal.class).iterator();
                    if (iterator2.hasNext()) {
                        KerberosPrincipal principal = iterator2.next();
                        principalsCallback.setPeerPrincipals(new Principal[]{principal});
                        return;
                    }
                    Set<Principal> principals = peerSubject.getPrincipals();
                    if (principals.size() > 0) {
                        principalsCallback.setPeerPrincipals(principals.toArray(new Principal[0]));
                        return;
                    }
                }
                if ((peerPrincipalFromConnection = CertificateUtil.getPeerPrincipalFromConnection(this.remotingConnection)) == null) continue;
                principalsCallback.setPeerPrincipals(new Principal[]{peerPrincipalFromConnection});
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

