/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.protocol;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.jboss.logging.Logger;

public class EmbedMessageUtil {
    private static final String AMQP_ENCODE_PROPERTY = "_AMQP_EMBED_LARGE";
    private static final byte[] signature = new byte[]{69, 77, 66};
    private static final Logger logger = Logger.getLogger(EmbedMessageUtil.class);

    public static ICoreMessage embedAsCoreMessage(Message source2) {
        if (source2 instanceof ICoreMessage) {
            return (ICoreMessage)source2;
        }
        if (source2.isLargeMessage()) {
            LargeServerMessage largeSource = (LargeServerMessage)((Object)source2);
            LargeServerMessageImpl largeServerMessage = new LargeServerMessageImpl(8, source2.getMessageID(), largeSource.getStorageManager(), largeSource.getLargeBody().createFile());
            largeServerMessage.setDurable(source2.isDurable());
            int size = source2.getPersister().getEncodeSize(source2);
            byte[] arrayByte = new byte[size];
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer(arrayByte);
            buffer.resetWriterIndex();
            source2.getPersister().encode(buffer, source2);
            largeServerMessage.toMessage().putBytesProperty(AMQP_ENCODE_PROPERTY, arrayByte);
            largeServerMessage.setParentRef((RefCountMessage)((Object)source2));
            return (ICoreMessage)largeServerMessage.toMessage();
        }
        Persister<Message> persister = source2.getPersister();
        CoreMessage message = new CoreMessage(source2.getMessageID(), persister.getEncodeSize(source2) + signature.length + 4).setType((byte)7);
        message.setDurable(source2.isDurable());
        ActiveMQBuffer buffer = message.getBodyBuffer();
        buffer.writeBytes(signature);
        persister.encode(buffer, source2);
        return message;
    }

    public static Message extractEmbedded(ICoreMessage message, StorageManager storageManager) {
        switch (message.getType()) {
            case 7: {
                return EmbedMessageUtil.extractRegularMessage(message, storageManager);
            }
            case 8: {
                return EmbedMessageUtil.extractLargeMessage(message, storageManager);
            }
        }
        return message;
    }

    private static Message extractRegularMessage(ICoreMessage message, StorageManager storageManager) {
        ActiveMQBuffer buffer = message.getReadOnlyBodyBuffer();
        if (buffer.readableBytes() < signature.length || !EmbedMessageUtil.checkSignature(buffer)) {
            logger.tracef("Message type %d was used for something other than embed messages, ignoring content and treating as a regular message", 7);
            return message;
        }
        return EmbedMessageUtil.readEncoded(message, storageManager, buffer);
    }

    private static Message readEncoded(ICoreMessage message, StorageManager storageManager, ActiveMQBuffer buffer) {
        try {
            Message returnMessage = MessagePersister.getInstance().decode(buffer, null, null, storageManager);
            if (returnMessage instanceof LargeServerMessage) {
                ((LargeServerMessage)((Object)returnMessage)).setStorageManager(storageManager);
            }
            returnMessage.setMessageID(message.getMessageID());
            return returnMessage;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), e);
            return message;
        }
    }

    private static Message extractLargeMessage(ICoreMessage message, StorageManager storageManager) {
        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer(message.getBytesProperty(AMQP_ENCODE_PROPERTY));
        return EmbedMessageUtil.readEncoded(message, storageManager, buffer);
    }

    private static boolean checkSignature(ActiveMQBuffer buffer) {
        return buffer.readByte() == signature[0] && buffer.readByte() == signature[1] && buffer.readByte() == signature[2];
    }
}

