/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.service.extensions;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.service.extensions.ActiveMQServiceExtensionLogger;
import org.apache.activemq.artemis.service.extensions.transactions.TransactionManagerLocator;
import org.apache.activemq.artemis.service.extensions.xa.ActiveMQXAResourceWrapper;
import org.apache.activemq.artemis.service.extensions.xa.ActiveMQXAResourceWrapperFactory;
import org.apache.activemq.artemis.service.extensions.xa.ActiveMQXAResourceWrapperFactoryImpl;

public class ServiceUtils {
    private static ActiveMQXAResourceWrapperFactory activeMQXAResourceWrapperFactory;
    private static TransactionManager transactionManager;
    private static boolean transactionManagerLoaded;

    private static ActiveMQXAResourceWrapperFactory getActiveMQXAResourceWrapperFactory() {
        if (activeMQXAResourceWrapperFactory == null) {
            activeMQXAResourceWrapperFactory = ServiceUtils.findActiveMQXAResourceWrapperFactory();
        }
        return activeMQXAResourceWrapperFactory;
    }

    public static ActiveMQXAResourceWrapper wrapXAResource(XAResource xaResource, Map<String, Object> properties) {
        return ServiceUtils.getActiveMQXAResourceWrapperFactory().wrap(xaResource, properties);
    }

    public static synchronized TransactionManager getTransactionManager() {
        if (!transactionManagerLoaded) {
            transactionManager = ServiceUtils.findTransactionManager();
            if (transactionManager != null) {
                transactionManagerLoaded = true;
            } else {
                ActiveMQServiceExtensionLogger.LOGGER.transactionManagerNotFound();
            }
        }
        return transactionManager;
    }

    public static void setTransactionManager(TransactionManager tm) {
        transactionManager = tm;
        transactionManagerLoaded = transactionManager != null;
    }

    private static TransactionManager findTransactionManager() {
        return AccessController.doPrivileged(new PrivilegedAction<TransactionManager>(){

            @Override
            public TransactionManager run() {
                Iterator<TransactionManagerLocator> it = ServiceLoader.load(TransactionManagerLocator.class, ServiceUtils.class.getClassLoader()).iterator();
                while (it.hasNext() && transactionManager == null) {
                    transactionManager = it.next().getTransactionManager();
                }
                return transactionManager;
            }
        });
    }

    private static ActiveMQXAResourceWrapperFactory findActiveMQXAResourceWrapperFactory() {
        return AccessController.doPrivileged(new PrivilegedAction<ActiveMQXAResourceWrapperFactory>(){

            @Override
            public ActiveMQXAResourceWrapperFactory run() {
                Iterator<ActiveMQXAResourceWrapperFactory> iterator2 = ServiceLoader.load(ActiveMQXAResourceWrapperFactory.class, ServiceUtils.class.getClassLoader()).iterator();
                if (iterator2.hasNext()) {
                    return iterator2.next();
                }
                return new ActiveMQXAResourceWrapperFactoryImpl();
            }
        });
    }

    static {
        transactionManagerLoaded = false;
    }
}

