/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.journal;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.journal.ActiveMQJournalBundle;

public class ActiveMQJournalBundle_$bundle
implements ActiveMQJournalBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQJournalBundle_$bundle INSTANCE = new ActiveMQJournalBundle_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ActiveMQJournalBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String ioRenameFileError$str() {
        return "AMQ149000: failed to rename file {0} to {1}";
    }

    @Override
    public final ActiveMQIOErrorException ioRenameFileError(String name, String newFileName) {
        ActiveMQIOErrorException result = new ActiveMQIOErrorException(this._formatMessage(this.ioRenameFileError$str(), name, newFileName));
        ActiveMQJournalBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args2) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args2, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String journalDifferentVersion$str() {
        return "AMQ149001: Journal data belong to a different version";
    }

    @Override
    public final ActiveMQIOErrorException journalDifferentVersion() {
        ActiveMQIOErrorException result = new ActiveMQIOErrorException(String.format(this.getLoggingLocale(), this.journalDifferentVersion$str(), new Object[0]));
        ActiveMQJournalBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String journalFileMisMatch$str() {
        return "AMQ149002: Journal files version mismatch. You should export the data from the previous version and import it as explained on the user's manual";
    }

    @Override
    public final ActiveMQIOErrorException journalFileMisMatch() {
        ActiveMQIOErrorException result = new ActiveMQIOErrorException(String.format(this.getLoggingLocale(), this.journalFileMisMatch$str(), new Object[0]));
        ActiveMQJournalBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fileNotOpened$str() {
        return "AMQ149003: File not opened";
    }

    @Override
    public final ActiveMQIOErrorException fileNotOpened() {
        ActiveMQIOErrorException result = new ActiveMQIOErrorException(String.format(this.getLoggingLocale(), this.fileNotOpened$str(), new Object[0]));
        ActiveMQJournalBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToOpenFile$str() {
        return "AMQ149004: unable to open file";
    }

    @Override
    public final String unableToOpenFile() {
        return String.format(this.getLoggingLocale(), this.unableToOpenFile$str(), new Object[0]);
    }

    protected String recordLargerThanStoreMax$str() {
        return "AMQ149005: Message of {0} bytes is bigger than the max record size of {1} bytes. You should try to move large application properties to the message body.";
    }

    @Override
    public final ActiveMQIOErrorException recordLargerThanStoreMax(long recordSize, long maxRecordSize) {
        ActiveMQIOErrorException result = new ActiveMQIOErrorException(this._formatMessage(this.recordLargerThanStoreMax$str(), recordSize, maxRecordSize));
        ActiveMQJournalBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

