/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.logging;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingResultSet;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingStatement;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingUtil;
import org.jboss.logging.Logger;

public class LoggingPreparedStatement
extends LoggingStatement
implements PreparedStatement {
    private final PreparedStatement preparedStatement;

    public LoggingPreparedStatement(PreparedStatement preparedStatement, Logger logger2) {
        super(preparedStatement, logger2);
        this.preparedStatement = preparedStatement;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        LoggingResultSet rs = new LoggingResultSet(this.preparedStatement.executeQuery(), this.logger);
        this.logger.logf(level, "%s.executeQuery() = %s", (Object)this.statementID, (Object)rs.getResultSetID());
        return rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        int i2 = this.preparedStatement.executeUpdate();
        this.logger.logf(level, "%s.executeUpdate() = %s", (Object)this.statementID, (Object)i2);
        return i2;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.logger.logf(level, "%s.setNull(%d, %d)", (Object)this.statementID, (Object)parameterIndex, (Object)sqlType);
        this.preparedStatement.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.logger.logf(level, "%s.setBoolean(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.logger.logf(level, "%s.setByte(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.logger.logf(level, "%s.setShort(%d, %d)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.logger.logf(level, "%s.setInt(%d, %d)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.logger.logf(level, "%s.setLong(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.logger.logf(level, "%s.setFloat(%d, %f)", (Object)this.statementID, (Object)parameterIndex, (Object)Float.valueOf(x));
        this.preparedStatement.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.logger.logf(level, "%s.setDouble(%d, %d)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.logger.logf(level, "%s.setBigDecimal(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.logger.logf(level, "%s.setString(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.logger.logf(level, "%s.setBytes(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.logger.logf(level, "%s.setDate(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.logger.logf(level, "%s.setTime(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.logger.logf(level, "%s.setTimestamp(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.logger.logf(level, "%s.setAsciiStream(%d, %s, %d)", this.statementID, parameterIndex, x, length);
        this.preparedStatement.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.logger.logf(level, "%s.setUnicodeStream(%d, %s, %d)", this.statementID, parameterIndex, x, length);
        this.preparedStatement.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.logger.logf(level, "%s.setBinaryStream(%d, %s, %d)", this.statementID, parameterIndex, x, length);
        this.preparedStatement.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.logger.logf(level, "%s.clearParameters()", (Object)this.statementID);
        this.preparedStatement.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.logger.logf(level, "%s.setObject(%d, %s, %d)", this.statementID, parameterIndex, x, targetSqlType);
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.logger.logf(level, "%s.setObject(%d, %s)", (Object)this.statementID, (Object)parameterIndex, x);
        this.preparedStatement.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        boolean b = this.preparedStatement.execute();
        this.logger.logf(level, "%s.execute() = %s", (Object)this.statementID, (Object)b);
        return b;
    }

    @Override
    public void addBatch() throws SQLException {
        this.logger.logf(level, "%s.addBatch()", (Object)this.statementID);
        this.preparedStatement.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.logger.logf(level, "%s.setCharacterStream(%d, %s, %d)", this.statementID, parameterIndex, reader, length);
        this.preparedStatement.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.logger.logf(level, "%s.setRef(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setRef(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.logger.logf(level, "%s.setBlob(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.logger.logf(level, "%s.setClob(%d, %x)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setClob(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.logger.logf(level, "%s.setArray(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setArray(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.preparedStatement.getMetaData();
        this.logger.logf(level, "%s.getMetaData() = %s", (Object)this.statementID, (Object)LoggingUtil.getID(resultSetMetaData));
        return resultSetMetaData;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.logger.logf(level, "%s.setDate(%d, %s, %s)", this.statementID, parameterIndex, x, cal);
        this.preparedStatement.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.logger.logf(level, "%s.setTime(%d, %s, %s)", this.statementID, parameterIndex, x, cal);
        this.preparedStatement.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.logger.logf(level, "%s.setTimestamp(%d, %s, %s)", this.statementID, parameterIndex, x, cal);
        this.preparedStatement.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.logger.logf(level, "%s.setNull(%d, %d, %s)", this.statementID, parameterIndex, sqlType, typeName);
        this.preparedStatement.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.logger.logf(level, "%s.setURL(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        ParameterMetaData x = this.preparedStatement.getParameterMetaData();
        this.logger.logf(level, "%s.getParameterMetaData() = %s", (Object)this.statementID, (Object)x);
        return x;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.logger.logf(level, "%s.setRowId(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.logger.logf(level, "%s.setNString(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)value);
        this.preparedStatement.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.logger.logf(level, "%s.setNCharacterStream(%d, %s, %d)", this.statementID, parameterIndex, value, length);
        this.preparedStatement.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.logger.logf(level, "%s.setNClob(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)value);
        this.preparedStatement.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.logger.logf(level, "%s.setClob(%d, %s, %s)", this.statementID, parameterIndex, reader, length);
        this.preparedStatement.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream2, long length) throws SQLException {
        this.logger.logf(level, "%s.setBlob(%d, %s, %d)", this.statementID, parameterIndex, inputStream2, length);
        this.preparedStatement.setBlob(parameterIndex, inputStream2, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.logger.logf(level, "%s.setNClob(%d, %s, %d)", this.statementID, parameterIndex, reader, length);
        this.preparedStatement.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.logger.logf(level, "%s.setSQLXML(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)xmlObject);
        this.preparedStatement.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.logger.logf(level, "%s.setNull(%d, %d)", (Object)this.statementID, (Object)parameterIndex, x);
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.logger.logf(level, "%s.setNull(%d, %d)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.logger.logf(level, "%s.setNull(%d, %d)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.logger.logf(level, "%s.setCharacterStream(%d, %s, %d)", this.statementID, parameterIndex, reader, length);
        this.preparedStatement.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.logger.logf(level, "%s.setAsciiStream(%d, %d)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.logger.logf(level, "%s.setBinaryStream(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)x);
        this.preparedStatement.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.logger.logf(level, "%s.setCharacterStream(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)reader);
        this.preparedStatement.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.logger.logf(level, "%s.setNCharacterStream(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)value);
        this.preparedStatement.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.logger.logf(level, "%s.setClob(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)reader);
        this.preparedStatement.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream2) throws SQLException {
        this.logger.logf(level, "%s.setBlob(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)inputStream2);
        this.preparedStatement.setBlob(parameterIndex, inputStream2);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.logger.logf(level, "%s.setNClob(%d, %s)", (Object)this.statementID, (Object)parameterIndex, (Object)reader);
        this.preparedStatement.setNClob(parameterIndex, reader);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.logger.logf(level, "%s.setObject(%d, %s, %s, %d)", this.statementID, parameterIndex, x, targetSqlType, scaleOrLength);
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.logger.logf(level, "%s.setObject(%d, %s, %d)", this.statementID, parameterIndex, x, targetSqlType);
        this.preparedStatement.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        long l = this.preparedStatement.executeLargeUpdate();
        this.logger.logf(level, "%s.executeLargeUpdate() = %s", (Object)this.statementID, (Object)l);
        return l;
    }
}

