/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.MessageGroups;

abstract class MapMessageGroups<C>
implements MessageGroups<C> {
    private final Map<SimpleString, C> groups;

    protected MapMessageGroups(Map<SimpleString, C> groups2) {
        this.groups = groups2;
    }

    @Override
    public void put(SimpleString key, C consumer) {
        this.groups.put(key, consumer);
    }

    @Override
    public C get(SimpleString key) {
        return this.groups.get(key);
    }

    @Override
    public C remove(SimpleString key) {
        return this.groups.remove(key);
    }

    @Override
    public boolean removeIf(Predicate<? super C> filter2) {
        return this.groups.values().removeIf(filter2);
    }

    @Override
    public void removeAll() {
        this.groups.clear();
    }

    @Override
    public int size() {
        return this.groups.size();
    }

    @Override
    public Map<SimpleString, C> toMap() {
        return new HashMap<SimpleString, C>(this.groups);
    }
}

