/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jboss.logmanager.config.ErrorManagerConfiguration;
import org.jboss.logmanager.config.FilterConfiguration;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.HandlerContainingConfigurable;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.config.PojoConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.logmanager.config.ValueExpression;

public class LoggingConfigurationUpdater {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");
    private static final String LOGGERS = "loggers";
    private static final String HANDLERS = "handlers";
    private static final String FILTERS = "filters";
    private static final String FORMATTERS = "formatters";
    private static final String ERROR_MANAGERS = "errorManagers";
    private static final String POJOS = "pojos";
    private static final String LOGGER = "logger";
    private static final String LEVEL = "level";
    private static final String HANDLER = "handler";
    private static final String FORMATTER = "formatter";
    private static final String ENCODING = "encoding";
    private static final String ERROR_MANAGER = "errorManager";
    private static final String POST_CONFIGURATION = "postConfiguration";
    private static final String POJO = "pojo";
    private static final String MODULE = "module";
    private static final String PROPERTIES = "properties";
    private static final String FILTER = "filter";
    private static final String CONSTRUCTOR_PROPERTIES = "constructorProperties";
    private static final String USE_PARENT_HANDLERS = "useParentHandlers";
    private final LogContextConfiguration config;

    public LoggingConfigurationUpdater(LogContextConfiguration config) {
        this.config = config;
    }

    public void configure(InputStream inputStream2) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(inputStream2, StandardCharsets.UTF_8));
            inputStream2.close();
        }
        finally {
            LoggingConfigurationUpdater.safeClose(inputStream2);
        }
        this.configure(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(Properties properties) {
        try {
            String[] loggerNames;
            List<String> handlersToRemove = this.config.getHandlerNames();
            handlersToRemove.removeAll(this.configureLogger(properties, ""));
            for (String loggerName : loggerNames = LoggingConfigurationUpdater.getStringCsvArray(properties, LOGGERS)) {
                handlersToRemove.removeAll(this.configureLogger(properties, loggerName));
            }
            List<String> loggersToRemove = this.config.getLoggerNames();
            loggersToRemove.remove("");
            loggersToRemove.removeAll(Arrays.asList(loggerNames));
            for (String loggerName : loggersToRemove) {
                this.config.removeLoggerConfiguration(loggerName);
            }
            String[] handlerNames = LoggingConfigurationUpdater.getStringCsvArray(properties, HANDLERS);
            for (String handlerName : handlerNames) {
                this.configureHandler(properties, handlerName);
            }
            handlersToRemove.removeAll(Arrays.asList(handlerNames));
            for (String handlerName : handlersToRemove) {
                this.config.removeHandlerConfiguration(handlerName);
            }
            for (String filterName : LoggingConfigurationUpdater.getStringCsvArray(properties, FILTERS)) {
                this.configureFilter(properties, filterName);
            }
            for (String formatterName : LoggingConfigurationUpdater.getStringCsvArray(properties, FORMATTERS)) {
                this.configureFormatter(properties, formatterName);
            }
            for (String errorManagerName : LoggingConfigurationUpdater.getStringCsvArray(properties, ERROR_MANAGERS)) {
                this.configureErrorManager(properties, errorManagerName);
            }
            for (String pojoName : LoggingConfigurationUpdater.getStringCsvArray(properties, POJOS)) {
                this.configurePojos(properties, pojoName);
            }
            this.config.commit();
        }
        finally {
            this.config.forget();
        }
    }

    private List<String> configureLogger(Properties properties, String loggerName) {
        String filterName;
        ValueExpression<String> newValue;
        LoggerConfiguration loggerConfiguration = this.config.getLoggerNames().contains(loggerName) ? this.config.getLoggerConfiguration(loggerName) : this.config.addLoggerConfiguration(loggerName);
        String levelName = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(LOGGER, loggerName, LEVEL));
        if (LoggingConfigurationUpdater.notEqual(levelName, loggerConfiguration.getLevelValueExpression())) {
            loggerConfiguration.setLevel(levelName == null ? "ALL" : levelName);
        }
        if (LoggingConfigurationUpdater.notEqual(newValue = ValueExpression.STRING_RESOLVER.resolve(filterName = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(LOGGER, loggerName, FILTER))), loggerConfiguration.getFilterValueExpression())) {
            String filterClassName;
            loggerConfiguration.setFilter(filterName);
            String resolvedFilter = loggerConfiguration.getFilterValueExpression().getResolvedValue();
            if (resolvedFilter != null && (filterClassName = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(FILTER, resolvedFilter))) != null) {
                this.configureFilter(properties, resolvedFilter);
            }
        }
        this.configureHandlerNames(properties, loggerConfiguration, LOGGER, loggerName);
        String useParentHandlersString = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(LOGGER, loggerName, USE_PARENT_HANDLERS));
        if (LoggingConfigurationUpdater.booleanNotEqual(useParentHandlersString, loggerConfiguration.getUseParentHandlersValueExpression())) {
            if (EXPRESSION_PATTERN.matcher(useParentHandlersString).matches()) {
                loggerConfiguration.setUseParentHandlers(useParentHandlersString);
            } else {
                loggerConfiguration.setUseParentHandlers(Boolean.parseBoolean(useParentHandlersString));
            }
        }
        return loggerConfiguration.getHandlerNames();
    }

    private void configureFilter(Properties properties, String filterName) {
        String className = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(FILTER, filterName));
        if (className == null) {
            return;
        }
        FilterConfiguration configuration = this.config.getFilterNames().contains(filterName) ? this.config.getFilterConfiguration(filterName) : this.config.addFilterConfiguration(LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(FILTER, filterName, MODULE)), className, filterName, LoggingConfigurationUpdater.getStringCsvArray(properties, LoggingConfigurationUpdater.getKey(FILTER, filterName, CONSTRUCTOR_PROPERTIES)));
        String[] postConfigurationMethods = LoggingConfigurationUpdater.getStringCsvArray(properties, LoggingConfigurationUpdater.getKey(FILTER, filterName, POST_CONFIGURATION));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, LoggingConfigurationUpdater.getKey(FILTER, filterName));
    }

    private boolean configureFormatter(Properties properties, String formatterName) {
        String className = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(FORMATTER, formatterName));
        if (className == null) {
            LoggingConfigurationUpdater.printError("Formatter %s is not defined%n", formatterName);
            return false;
        }
        FormatterConfiguration configuration = this.config.getFormatterNames().contains(formatterName) ? this.config.getFormatterConfiguration(formatterName) : this.config.addFormatterConfiguration(LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(FORMATTER, formatterName, MODULE)), className, formatterName, LoggingConfigurationUpdater.getStringCsvArray(properties, LoggingConfigurationUpdater.getKey(FORMATTER, formatterName, CONSTRUCTOR_PROPERTIES)));
        String[] postConfigurationMethods = LoggingConfigurationUpdater.getStringCsvArray(properties, LoggingConfigurationUpdater.getKey(FORMATTER, formatterName, POST_CONFIGURATION));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, LoggingConfigurationUpdater.getKey(FORMATTER, formatterName));
        return true;
    }

    private boolean configureErrorManager(Properties properties, String errorManagerName) {
        String className = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(ERROR_MANAGER, errorManagerName));
        if (className == null) {
            LoggingConfigurationUpdater.printError("Error manager %s is not defined%n", errorManagerName);
            return false;
        }
        ErrorManagerConfiguration configuration = this.config.getErrorManagerNames().contains(errorManagerName) ? this.config.getErrorManagerConfiguration(errorManagerName) : this.config.addErrorManagerConfiguration(LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(ERROR_MANAGER, errorManagerName, MODULE)), className, errorManagerName, LoggingConfigurationUpdater.getStringCsvArray(properties, LoggingConfigurationUpdater.getKey(ERROR_MANAGER, errorManagerName, CONSTRUCTOR_PROPERTIES)));
        String[] postConfigurationMethods = LoggingConfigurationUpdater.getStringCsvArray(properties, LoggingConfigurationUpdater.getKey(ERROR_MANAGER, errorManagerName, POST_CONFIGURATION));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, LoggingConfigurationUpdater.getKey(ERROR_MANAGER, errorManagerName));
        return true;
    }

    private boolean configureHandler(Properties properties, String handlerName) {
        String errorManagerName;
        String encoding;
        String formatterName;
        String levelName;
        String className = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(HANDLER, handlerName));
        if (className == null) {
            LoggingConfigurationUpdater.printError("Handler %s is not defined%n", handlerName);
            return false;
        }
        HandlerConfiguration configuration = this.config.getHandlerNames().contains(handlerName) ? this.config.getHandlerConfiguration(handlerName) : this.config.addHandlerConfiguration(LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(HANDLER, handlerName, MODULE)), className, handlerName, LoggingConfigurationUpdater.getStringCsvArray(properties, LoggingConfigurationUpdater.getKey(HANDLER, handlerName, CONSTRUCTOR_PROPERTIES)));
        String filter2 = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(HANDLER, handlerName, FILTER));
        if (LoggingConfigurationUpdater.notEqual(filter2, configuration.getFilterValueExpression())) {
            String filterClassName;
            configuration.setFilter(filter2);
            String resolvedFilter = configuration.getFilterValueExpression().getResolvedValue();
            if (resolvedFilter != null && (filterClassName = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(FILTER, resolvedFilter))) != null) {
                this.configureFilter(properties, resolvedFilter);
            }
        }
        if (LoggingConfigurationUpdater.notEqual(levelName = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(HANDLER, handlerName, LEVEL)), configuration.getLevelValueExpression())) {
            configuration.setLevel(levelName == null ? "ALL" : levelName);
        }
        if ((formatterName = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(HANDLER, handlerName, FORMATTER))) != null) {
            if (LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(FORMATTER, ValueExpression.STRING_RESOLVER.resolve(formatterName).getResolvedValue())) == null) {
                LoggingConfigurationUpdater.printError("Formatter %s is not defined%n", formatterName);
            } else {
                ValueExpression<String> newValue = ValueExpression.STRING_RESOLVER.resolve(formatterName);
                if (LoggingConfigurationUpdater.notEqual(newValue, configuration.getFormatterNameValueExpression()) && this.configureFormatter(properties, newValue.getResolvedValue())) {
                    configuration.setFormatterName(formatterName);
                }
            }
        }
        if (LoggingConfigurationUpdater.notEqual(encoding = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(HANDLER, handlerName, ENCODING)), configuration.getEncodingValueExpression())) {
            configuration.setEncoding(encoding);
        }
        if ((errorManagerName = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(HANDLER, handlerName, ERROR_MANAGER))) != null) {
            if (LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(ERROR_MANAGER, ValueExpression.STRING_RESOLVER.resolve(errorManagerName).getResolvedValue())) == null) {
                LoggingConfigurationUpdater.printError("Error manager %s is not defined%n", errorManagerName);
            } else {
                ValueExpression<String> newValue = ValueExpression.STRING_RESOLVER.resolve(errorManagerName);
                if (LoggingConfigurationUpdater.notEqual(newValue, configuration.getErrorManagerNameValueExpression()) && this.configureErrorManager(properties, newValue.getResolvedValue())) {
                    configuration.setErrorManagerName(errorManagerName);
                }
            }
        }
        this.configureHandlerNames(properties, configuration, HANDLER, handlerName);
        String[] postConfigurationMethods = LoggingConfigurationUpdater.getStringCsvArray(properties, LoggingConfigurationUpdater.getKey(HANDLER, handlerName, POST_CONFIGURATION));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, LoggingConfigurationUpdater.getKey(HANDLER, handlerName));
        return true;
    }

    private void configurePojos(Properties properties, String pojoName) {
        String className = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(POJO, pojoName));
        if (className == null) {
            LoggingConfigurationUpdater.printError("POJO %s is not defined%n", pojoName);
            return;
        }
        PojoConfiguration configuration = this.config.getPojoNames().contains(pojoName) ? this.config.getPojoConfiguration(pojoName) : this.config.addPojoConfiguration(LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(POJO, pojoName, MODULE)), LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(POJO, pojoName)), pojoName, LoggingConfigurationUpdater.getStringCsvArray(properties, LoggingConfigurationUpdater.getKey(POJO, pojoName, CONSTRUCTOR_PROPERTIES)));
        String[] postConfigurationMethods = LoggingConfigurationUpdater.getStringCsvArray(properties, LoggingConfigurationUpdater.getKey(POJO, pojoName, POST_CONFIGURATION));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, LoggingConfigurationUpdater.getKey(POJO, pojoName));
    }

    private void configureProperties(Properties properties, PropertyConfigurable configurable, String prefix) {
        List<String> propertyNames = LoggingConfigurationUpdater.getStringCsvList(properties, LoggingConfigurationUpdater.getKey(prefix, PROPERTIES));
        for (String propertyName : propertyNames) {
            String valueString = LoggingConfigurationUpdater.getStringProperty(properties, LoggingConfigurationUpdater.getKey(prefix, propertyName), false);
            if (!LoggingConfigurationUpdater.notEqual(valueString, configurable.getPropertyValueExpression(propertyName))) continue;
            configurable.setPropertyValueString(propertyName, valueString);
        }
    }

    private void configureHandlerNames(Properties properties, HandlerContainingConfigurable configuration, String prefix, String name) {
        String[] handlerNames = LoggingConfigurationUpdater.getStringCsvArray(properties, LoggingConfigurationUpdater.getKey(prefix, name, HANDLERS));
        ArrayList<String> availableHandlers = new ArrayList<String>();
        for (String handlerName : handlerNames) {
            if (!this.configureHandler(properties, handlerName)) continue;
            availableHandlers.add(handlerName);
        }
        configuration.setHandlerNames(availableHandlers);
    }

    private static String getKey(String prefix, String objectName) {
        return objectName.length() > 0 ? prefix + "." + objectName : prefix;
    }

    private static String getKey(String prefix, String objectName, String key) {
        return objectName.length() > 0 ? prefix + "." + objectName + "." + key : prefix + "." + key;
    }

    private static String getStringProperty(Properties properties, String key) {
        return LoggingConfigurationUpdater.getStringProperty(properties, key, true);
    }

    private static String getStringProperty(Properties properties, String key, boolean trim) {
        String value = properties.getProperty(key);
        return trim ? (value == null ? null : value.trim()) : value;
    }

    private static String[] getStringCsvArray(Properties properties, String key) {
        String property = properties.getProperty(key, "");
        if (property == null) {
            return EMPTY_STRINGS;
        }
        String value = property.trim();
        if (value.length() == 0) {
            return EMPTY_STRINGS;
        }
        return value.split("\\s*,\\s*");
    }

    private static List<String> getStringCsvList(Properties properties, String key) {
        return new ArrayList<String>(Arrays.asList(LoggingConfigurationUpdater.getStringCsvArray(properties, key)));
    }

    private static void printError(String format, Object ... args2) {
        System.err.printf(format, args2);
    }

    private static void safeClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean notEqual(ValueExpression<String> newValue, ValueExpression<String> currentValue) {
        if (newValue == null) {
            return currentValue.getResolvedValue() != null;
        }
        return !Objects.equals(newValue.getValue(), currentValue.getValue());
    }

    private static boolean notEqual(String newValue, ValueExpression<String> currentValue) {
        if (newValue == null) {
            return currentValue.getResolvedValue() != null;
        }
        if (currentValue.isExpression()) {
            String resolvedCurrentValue = currentValue.getResolvedValue();
            String resolvedNewValue = ValueExpression.STRING_RESOLVER.resolve(newValue).getResolvedValue();
            return resolvedCurrentValue == null ? resolvedNewValue != null : !resolvedCurrentValue.equals(resolvedNewValue);
        }
        return !newValue.equals(currentValue.getValue());
    }

    private static boolean booleanNotEqual(String newValue, ValueExpression<Boolean> currentValue) {
        if (newValue == null) {
            return currentValue.getResolvedValue() != null;
        }
        if (currentValue.isExpression()) {
            Boolean resolvedCurrentValue = currentValue.getResolvedValue();
            Boolean resolvedNewValue = ValueExpression.BOOLEAN_RESOLVER.resolve(newValue).getResolvedValue();
            return resolvedCurrentValue == null ? resolvedNewValue != null : !resolvedCurrentValue.equals(resolvedNewValue);
        }
        return !newValue.equals(currentValue.getValue());
    }
}

