/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.ResponseHandler;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage_V2;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashMap;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashSet;

public class ResponseCache {
    private final AtomicLong sequence = new AtomicLong(0L);
    private final ConcurrentLongHashMap<Packet> store = new ConcurrentLongHashMap();
    private ResponseHandler responseHandler;

    public long nextCorrelationID() {
        return this.sequence.incrementAndGet();
    }

    public boolean add(Packet packet) {
        this.store.put(packet.getCorrelationID(), packet);
        return true;
    }

    public Packet remove(long correlationID) {
        return this.store.remove(correlationID);
    }

    public void handleResponse(Packet response) {
        long correlationID = response.getCorrelationID();
        Packet packet = this.remove(correlationID);
        if (packet != null) {
            this.responseHandler.handleResponse(packet, response);
        }
    }

    public void errorAll(ActiveMQException exception) {
        ConcurrentLongHashSet keys2 = this.store.keysLongHashSet();
        keys2.forEach(correlationID -> this.handleResponse(new ActiveMQExceptionMessage_V2(correlationID, exception)));
    }

    public void setResponseHandler(ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    public int size() {
        return this.store.size();
    }
}

