/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.net.URL;
import java.util.Properties;
import java.util.Set;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

@Deprecated
public class FileSecurityConfiguration
extends SecurityConfiguration {
    private final String usersUrl;
    private final String rolesUrl;
    private Boolean maskPassword;
    private String passwordCodec;
    private boolean started;

    public FileSecurityConfiguration(String usersUrl, String rolesUrl, String defaultUser, Boolean maskPassword, String passwordCodec) {
        this.usersUrl = usersUrl;
        this.rolesUrl = rolesUrl;
        this.defaultUser = defaultUser;
        this.maskPassword = maskPassword;
        this.passwordCodec = passwordCodec;
    }

    public void stop() throws Exception {
        this.users.clear();
        this.roles.clear();
        this.defaultUser = null;
    }

    public boolean isStarted() {
        return true;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        URL theUsersUrl = this.getClass().getClassLoader().getResource(this.usersUrl);
        if (theUsersUrl == null) {
            theUsersUrl = new URL(this.usersUrl);
        }
        Properties userProps = new Properties();
        userProps.load(theUsersUrl.openStream());
        URL theRolesUrl = this.getClass().getClassLoader().getResource(this.usersUrl);
        if (theRolesUrl == null) {
            theRolesUrl = new URL(this.rolesUrl);
        }
        Properties roleProps = new Properties();
        roleProps.load(theRolesUrl.openStream());
        Set<String> keys2 = userProps.stringPropertyNames();
        for (String username : keys2) {
            String password = userProps.getProperty(username);
            password = PasswordMaskingUtil.resolveMask(this.maskPassword, password, this.passwordCodec);
            this.addUser(username, password);
        }
        for (String username : keys2) {
            String[] split;
            String roles = roleProps.getProperty(username);
            if (roles == null) {
                ActiveMQServerLogger.LOGGER.cannotFindRoleForUser(username);
                continue;
            }
            for (String role : split = roles.split(",")) {
                this.addRole(username, role.trim());
            }
        }
        this.started = true;
    }
}

