/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInterceptorRejectedPacketException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.ActiveMQLargeMessageException;
import org.apache.activemq.artemis.api.core.ActiveMQLargeMessageInterruptedException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.ActiveMQRedirectedException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionOutcomeUnknownException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionRolledBackException;
import org.apache.activemq.artemis.api.core.ActiveMQUnBlockedException;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.w3c.dom.Node;

public class ActiveMQClientMessageBundle_$bundle
implements ActiveMQClientMessageBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQClientMessageBundle_$bundle INSTANCE = new ActiveMQClientMessageBundle_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ActiveMQClientMessageBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String clientSessionClosed$str() {
        return "AMQ219000: ClientSession closed while creating session";
    }

    @Override
    public final ActiveMQInternalErrorException clientSessionClosed() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.clientSessionClosed$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String failedToCreateSession$str() {
        return "AMQ219001: Failed to create session";
    }

    @Override
    public final ActiveMQInternalErrorException failedToCreateSession(Throwable t) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.failedToCreateSession$str(), new Object[0]), t);
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String queueMisConfigured$str() {
        return "AMQ219003: Queue can not be both durable and temporary";
    }

    @Override
    public final ActiveMQInternalErrorException queueMisConfigured() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.queueMisConfigured$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToInitialiseSessionFactory$str() {
        return "AMQ219004: Failed to initialise session factory";
    }

    @Override
    public final ActiveMQInternalErrorException failedToInitialiseSessionFactory(Exception e) {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.failedToInitialiseSessionFactory$str(), new Object[0]), e);
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nettyError$str() {
        return "AMQ219005: Exception in Netty transport";
    }

    @Override
    public final ActiveMQInternalErrorException nettyError() {
        ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(this.getLoggingLocale(), this.nettyError$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String channelDisconnected$str() {
        return "AMQ219006: Channel disconnected";
    }

    @Override
    public final ActiveMQNotConnectedException channelDisconnected() {
        ActiveMQNotConnectedException result = new ActiveMQNotConnectedException(String.format(this.getLoggingLocale(), this.channelDisconnected$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotConnectToServers$str() {
        return "AMQ219007: Cannot connect to server(s). Tried with all available servers.";
    }

    @Override
    public final ActiveMQNotConnectedException cannotConnectToServers() {
        ActiveMQNotConnectedException result = new ActiveMQNotConnectedException(String.format(this.getLoggingLocale(), this.cannotConnectToServers$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotConnectToStaticConnectors$str() {
        return "AMQ219008: Failed to connect to any static connectors";
    }

    @Override
    public final ActiveMQNotConnectedException cannotConnectToStaticConnectors(Exception e) {
        ActiveMQNotConnectedException result = new ActiveMQNotConnectedException(String.format(this.getLoggingLocale(), this.cannotConnectToStaticConnectors$str(), new Object[0]));
        result.initCause(e);
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotConnectToStaticConnectors2$str() {
        return "AMQ219009: Failed to connect to any static connectors";
    }

    @Override
    public final ActiveMQNotConnectedException cannotConnectToStaticConnectors2() {
        ActiveMQNotConnectedException result = new ActiveMQNotConnectedException(String.format(this.getLoggingLocale(), this.cannotConnectToStaticConnectors2$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionDestroyed$str() {
        return "AMQ219010: Connection is destroyed";
    }

    @Override
    public final ActiveMQNotConnectedException connectionDestroyed() {
        ActiveMQNotConnectedException result = new ActiveMQNotConnectedException(String.format(this.getLoggingLocale(), this.connectionDestroyed$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionTimedOut$str() {
        return "AMQ219011: Did not receive data from server for {0}";
    }

    @Override
    public final ActiveMQConnectionTimedOutException connectionTimedOut(Connection transportConnection) {
        ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(this._formatMessage(this.connectionTimedOut$str(), transportConnection));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args2) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args2, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String connectionTimedOutInInitialBroadcast$str() {
        return "AMQ219012: Timed out waiting to receive initial broadcast from cluster";
    }

    @Override
    public final ActiveMQConnectionTimedOutException connectionTimedOutInInitialBroadcast() {
        ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(String.format(this.getLoggingLocale(), this.connectionTimedOutInInitialBroadcast$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionTimedOutOnReceiveTopology$str() {
        return "AMQ219013: Timed out waiting to receive cluster topology. Group:{0}";
    }

    @Override
    public final ActiveMQConnectionTimedOutException connectionTimedOutOnReceiveTopology(DiscoveryGroup discoveryGroup) {
        ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(this._formatMessage(this.connectionTimedOutOnReceiveTopology$str(), discoveryGroup));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timedOutSendingPacket$str() {
        return "AMQ219014: Timed out after waiting {0} ms for response when sending packet {1}";
    }

    @Override
    public final ActiveMQConnectionTimedOutException timedOutSendingPacket(long timeout, Byte type) {
        ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(this._formatMessage(this.timedOutSendingPacket$str(), timeout, type));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String disconnected$str() {
        return "AMQ219015: The connection was disconnected because of server shutdown";
    }

    @Override
    public final ActiveMQDisconnectedException disconnected() {
        ActiveMQDisconnectedException result = new ActiveMQDisconnectedException(String.format(this.getLoggingLocale(), this.disconnected$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unblockingACall$str() {
        return "AMQ219016: Connection failure detected. Unblocking a blocking call that will never get a response";
    }

    @Override
    public final ActiveMQUnBlockedException unblockingACall(Throwable t) {
        ActiveMQUnBlockedException result = new ActiveMQUnBlockedException(String.format(this.getLoggingLocale(), this.unblockingACall$str(), new Object[0]));
        result.initCause(t);
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String consumerClosed$str() {
        return "AMQ219017: Consumer is closed";
    }

    @Override
    public final ActiveMQObjectClosedException consumerClosed() {
        ActiveMQObjectClosedException result = new ActiveMQObjectClosedException(String.format(this.getLoggingLocale(), this.consumerClosed$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String producerClosed$str() {
        return "AMQ219018: Producer is closed";
    }

    @Override
    public final ActiveMQObjectClosedException producerClosed() {
        ActiveMQObjectClosedException result = new ActiveMQObjectClosedException(String.format(this.getLoggingLocale(), this.producerClosed$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sessionClosed$str() {
        return "AMQ219019: Session is closed";
    }

    @Override
    public final ActiveMQObjectClosedException sessionClosed() {
        ActiveMQObjectClosedException result = new ActiveMQObjectClosedException(String.format(this.getLoggingLocale(), this.sessionClosed$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String messageHandlerSet$str() {
        return "AMQ219020: Cannot call receive(...) - a MessageHandler is set";
    }

    @Override
    public final ActiveMQIllegalStateException messageHandlerSet() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.messageHandlerSet$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inReceive$str() {
        return "AMQ219021: Cannot set MessageHandler - consumer is in receive(...)";
    }

    @Override
    public final ActiveMQIllegalStateException inReceive() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.inReceive$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String headerSizeTooBig$str() {
        return "AMQ219022: Header size ({0}) is too big, use the messageBody for large data, or increase minLargeMessageSize";
    }

    @Override
    public final ActiveMQIllegalStateException headerSizeTooBig(Integer headerSize) {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(this._formatMessage(this.headerSizeTooBig$str(), headerSize));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String largeMessageLostSession$str() {
        return "AMQ219023: The large message lost connection with its session, either because of a rollback or a closed session";
    }

    @Override
    public final ActiveMQIllegalStateException largeMessageLostSession() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.largeMessageLostSession$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noTCForSessionFactory$str() {
        return "AMQ219024: Could not select a TransportConfiguration to create SessionFactory";
    }

    @Override
    public final ActiveMQIllegalStateException noTCForSessionFactory() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.noTCForSessionFactory$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorSavingBody$str() {
        return "AMQ219025: Error saving the message body";
    }

    @Override
    public final ActiveMQLargeMessageException errorSavingBody(Exception e) {
        ActiveMQLargeMessageException result = new ActiveMQLargeMessageException(String.format(this.getLoggingLocale(), this.errorSavingBody$str(), new Object[0]));
        result.initCause(e);
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorReadingBody$str() {
        return "AMQ219026: Error reading the LargeMessageBody";
    }

    @Override
    public final ActiveMQLargeMessageException errorReadingBody(Exception e) {
        ActiveMQLargeMessageException result = new ActiveMQLargeMessageException(String.format(this.getLoggingLocale(), this.errorReadingBody$str(), new Object[0]));
        result.initCause(e);
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorClosingLargeMessage$str() {
        return "AMQ219027: Error closing stream from LargeMessageBody";
    }

    @Override
    public final ActiveMQLargeMessageException errorClosingLargeMessage(Exception e) {
        ActiveMQLargeMessageException result = new ActiveMQLargeMessageException(String.format(this.getLoggingLocale(), this.errorClosingLargeMessage$str(), new Object[0]));
        result.initCause(e);
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timeoutOnLargeMessage$str() {
        return "AMQ219028: Timeout waiting for LargeMessage Body";
    }

    @Override
    public final ActiveMQLargeMessageException timeoutOnLargeMessage() {
        ActiveMQLargeMessageException result = new ActiveMQLargeMessageException(String.format(this.getLoggingLocale(), this.timeoutOnLargeMessage$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorWritingLargeMessage$str() {
        return "AMQ219029: Error writing body of message";
    }

    @Override
    public final ActiveMQLargeMessageException errorWritingLargeMessage(Exception e) {
        ActiveMQLargeMessageException result = new ActiveMQLargeMessageException(String.format(this.getLoggingLocale(), this.errorWritingLargeMessage$str(), new Object[0]));
        result.initCause(e);
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String txRolledBack$str() {
        return "AMQ219030: The transaction was rolled back on failover to a backup server";
    }

    @Override
    public final ActiveMQTransactionRolledBackException txRolledBack() {
        ActiveMQTransactionRolledBackException result = new ActiveMQTransactionRolledBackException(String.format(this.getLoggingLocale(), this.txRolledBack$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String txOutcomeUnknown$str() {
        return "AMQ219031: The transaction was rolled back on failover however commit may have been successful";
    }

    @Override
    public final ActiveMQTransactionOutcomeUnknownException txOutcomeUnknown() {
        ActiveMQTransactionOutcomeUnknownException result = new ActiveMQTransactionOutcomeUnknownException(String.format(this.getLoggingLocale(), this.txOutcomeUnknown$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidType$str() {
        return "AMQ219032: Invalid type: {0}";
    }

    @Override
    public final IllegalArgumentException invalidType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidType$str(), type));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidEncodeType$str() {
        return "AMQ219033: Invalid type: {0}";
    }

    @Override
    public final IllegalArgumentException invalidEncodeType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidEncodeType$str(), type));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidManagementParam$str() {
        return "AMQ219034: Params for management operations must be of the following type: int long double String boolean Map or array thereof but found {0}";
    }

    @Override
    public final IllegalArgumentException invalidManagementParam(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidManagementParam$str(), type));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidWindowSize$str() {
        return "AMQ219035: Invalid window size {0}";
    }

    @Override
    public final IllegalArgumentException invalidWindowSize(Integer size) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidWindowSize$str(), size));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCommandID$str() {
        return "AMQ219037: Invalid last Received Command ID: {0}";
    }

    @Override
    public final IllegalArgumentException invalidCommandID(Integer lastReceivedCommandID) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidCommandID$str(), lastReceivedCommandID));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noChannelToClose$str() {
        return "AMQ219038: Cannot find channel with id {0} to close";
    }

    @Override
    public final IllegalArgumentException noChannelToClose(Long id) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.noChannelToClose$str(), id));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String closeListenerCannotBeNull$str() {
        return "AMQ219039: Close Listener cannot be null";
    }

    @Override
    public final IllegalArgumentException closeListenerCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.closeListenerCannotBeNull$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failListenerCannotBeNull$str() {
        return "AMQ219040: Fail Listener cannot be null";
    }

    @Override
    public final IllegalArgumentException failListenerCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failListenerCannotBeNull$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionExists$str() {
        return "AMQ219041: Connection already exists with id {0}";
    }

    @Override
    public final IllegalArgumentException connectionExists(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.connectionExists$str(), id));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullListener$str() {
        return "AMQ219042: Invalid argument null listener";
    }

    @Override
    public final IllegalArgumentException nullListener() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullListener$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullHandler$str() {
        return "AMQ219043: Invalid argument null handler";
    }

    @Override
    public final IllegalArgumentException nullHandler() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullHandler$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String firstNodeNull$str() {
        return "AMQ219045: the first node to be compared is null";
    }

    @Override
    public final IllegalArgumentException firstNodeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.firstNodeNull$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String secondNodeNull$str() {
        return "AMQ219046: the second node to be compared is null";
    }

    @Override
    public final IllegalArgumentException secondNodeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.secondNodeNull$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nodeHaveDifferentNames$str() {
        return "AMQ219047: nodes have different node names";
    }

    @Override
    public final IllegalArgumentException nodeHaveDifferentNames() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nodeHaveDifferentNames$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nodeHaveDifferentAttNumber$str() {
        return "AMQ219048: nodes have a different number of attributes";
    }

    @Override
    public final IllegalArgumentException nodeHaveDifferentAttNumber() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nodeHaveDifferentAttNumber$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attsDontMatch$str() {
        return "AMQ219049: attribute {0}={1} does not match";
    }

    @Override
    public final IllegalArgumentException attsDontMatch(String name, String value) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.attsDontMatch$str(), name, value));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String oneNodeHasChildren$str() {
        return "AMQ219050: one node has children and the other does not";
    }

    @Override
    public final IllegalArgumentException oneNodeHasChildren() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.oneNodeHasChildren$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nodeHasDifferentChildNumber$str() {
        return "AMQ219051: nodes have a different number of children";
    }

    @Override
    public final IllegalArgumentException nodeHasDifferentChildNumber() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nodeHasDifferentChildNumber$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustBeBoolean$str() {
        return "AMQ219052: Element {0} requires a valid Boolean value, but ''{1}'' cannot be parsed as a Boolean";
    }

    @Override
    public final IllegalArgumentException mustBeBoolean(Node elem, String value) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.mustBeBoolean$str(), elem, value));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustBeDouble$str() {
        return "AMQ219053: Element {0} requires a valid Double value, but ''{1}'' cannot be parsed as a Double";
    }

    @Override
    public final IllegalArgumentException mustBeDouble(Node elem, String value) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.mustBeDouble$str(), elem, value));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustBeInteger$str() {
        return "AMQ219054: Element {0} requires a valid Integer value, but ''{1}'' cannot be parsed as an Integer";
    }

    @Override
    public final IllegalArgumentException mustBeInteger(Node elem, String value) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.mustBeInteger$str(), elem, value));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustBeLong$str() {
        return "AMQ219055: Element {0} requires a valid Long value, but ''{1}'' cannot be parsed as a Long";
    }

    @Override
    public final IllegalArgumentException mustBeLong(Node element, String value) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.mustBeLong$str(), element, value));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errordecodingPassword$str() {
        return "AMQ219057: Error decoding password";
    }

    @Override
    public final IllegalArgumentException errordecodingPassword(Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.errordecodingPassword$str(), new Object[0]), e);
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String addressIsFull$str() {
        return "AMQ219058: Address \"{0}\" is full. Message encode size = {1}B";
    }

    @Override
    public final ActiveMQAddressFullException addressIsFull(String addressName, int size) {
        ActiveMQAddressFullException result = new ActiveMQAddressFullException(this._formatMessage(this.addressIsFull$str(), addressName, size));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String interceptorRejectedPacket$str() {
        return "AMQ219059: Interceptor {0} rejected packet in a blocking call. This call will never complete.";
    }

    @Override
    public final ActiveMQInterceptorRejectedPacketException interceptorRejectedPacket(String interceptionResult) {
        ActiveMQInterceptorRejectedPacketException result = new ActiveMQInterceptorRejectedPacketException(this._formatMessage(this.interceptorRejectedPacket$str(), interceptionResult));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String largeMessageInterrupted$str() {
        return "AMQ219060: Large Message Transmission interrupted on consumer shutdown.";
    }

    @Override
    public final ActiveMQLargeMessageInterruptedException largeMessageInterrupted() {
        ActiveMQLargeMessageInterruptedException result = new ActiveMQLargeMessageInterruptedException(String.format(this.getLoggingLocale(), this.largeMessageInterrupted$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotSendPacketDuringFailover$str() {
        return "AMQ219061: Cannot send a packet while channel is failing over.";
    }

    @Override
    public final IllegalStateException cannotSendPacketDuringFailover() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotSendPacketDuringFailover$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String packetTransmissionInterrupted$str() {
        return "AMQ219062: Multi-packet transmission (e.g. Large Messages) interrupted because of a reconnection.";
    }

    @Override
    public final ActiveMQInterruptedException packetTransmissionInterrupted() {
        ActiveMQInterruptedException result = new ActiveMQInterruptedException(String.format(this.getLoggingLocale(), this.packetTransmissionInterrupted$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotSendPacketWhilstResponseCacheFull$str() {
        return "AMQ219063: Cannot send a packet while response cache is full.";
    }

    @Override
    public final IllegalStateException cannotSendPacketWhilstResponseCacheFull() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotSendPacketWhilstResponseCacheFull$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPacket$str() {
        return "AMQ219064: Invalide packet: {0}";
    }

    @Override
    public final IllegalStateException invalidPacket(byte type) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.invalidPacket$str(), type));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToHandlePacket$str() {
        return "AMQ219065: Failed to handle packet.";
    }

    @Override
    public final RuntimeException failedToHandlePacket(Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToHandlePacket$str(), new Object[0]), e);
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String redirected$str() {
        return "AMQ219066: The connection was redirected";
    }

    @Override
    public final ActiveMQRedirectedException redirected() {
        ActiveMQRedirectedException result = new ActiveMQRedirectedException(String.format(this.getLoggingLocale(), this.redirected$str(), new Object[0]));
        ActiveMQClientMessageBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

