/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.PBKDF2;

import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.PBKDF2.PRF;
import net.lingala.zip4j.util.Zip4jUtil;

public class PBKDF2Engine {
    private PBKDF2Parameters parameters;
    private PRF prf;

    public PBKDF2Engine(PBKDF2Parameters parameters) {
        this(parameters, null);
    }

    public PBKDF2Engine(PBKDF2Parameters parameters, PRF prf) {
        this.parameters = parameters;
        this.prf = prf;
    }

    public byte[] deriveKey(char[] inputPassword) {
        return this.deriveKey(inputPassword, 0);
    }

    public byte[] deriveKey(char[] inputPassword, int dkLen) {
        if (inputPassword == null) {
            throw new NullPointerException();
        }
        byte[] p = Zip4jUtil.convertCharArrayToByteArray(inputPassword);
        this.assertPRF(p);
        if (dkLen == 0) {
            dkLen = this.prf.getHLen();
        }
        return this.PBKDF2(this.prf, this.parameters.getSalt(), this.parameters.getIterationCount(), dkLen);
    }

    public boolean verifyKey(char[] inputPassword) {
        byte[] referenceKey = this.getParameters().getDerivedKey();
        if (referenceKey == null || referenceKey.length == 0) {
            return false;
        }
        byte[] inputKey = this.deriveKey(inputPassword, referenceKey.length);
        if (inputKey == null || inputKey.length != referenceKey.length) {
            return false;
        }
        for (int i2 = 0; i2 < inputKey.length; ++i2) {
            if (inputKey[i2] == referenceKey[i2]) continue;
            return false;
        }
        return true;
    }

    private void assertPRF(byte[] P) {
        if (this.prf == null) {
            this.prf = new MacBasedPRF(this.parameters.getHashAlgorithm());
        }
        this.prf.init(P);
    }

    public PRF getPseudoRandomFunction() {
        return this.prf;
    }

    private byte[] PBKDF2(PRF prf, byte[] S, int c, int dkLen) {
        if (S == null) {
            S = new byte[]{};
        }
        int hLen = prf.getHLen();
        int l = this.ceil(dkLen, hLen);
        int r = dkLen - (l - 1) * hLen;
        byte[] T = new byte[l * hLen];
        int ti_offset = 0;
        for (int i2 = 1; i2 <= l; ++i2) {
            this._F(T, ti_offset, prf, S, c, i2);
            ti_offset += hLen;
        }
        if (r < hLen) {
            byte[] DK = new byte[dkLen];
            System.arraycopy(T, 0, DK, 0, dkLen);
            return DK;
        }
        return T;
    }

    private int ceil(int a, int b) {
        int m3 = 0;
        if (a % b > 0) {
            m3 = 1;
        }
        return a / b + m3;
    }

    private void _F(byte[] dest, int offset, PRF prf, byte[] S, int c, int blockIndex) {
        int hLen = prf.getHLen();
        byte[] U_r = new byte[hLen];
        byte[] U_i = new byte[S.length + 4];
        System.arraycopy(S, 0, U_i, 0, S.length);
        this.INT(U_i, S.length, blockIndex);
        for (int i2 = 0; i2 < c; ++i2) {
            U_i = prf.doFinal(U_i);
            this.xor(U_r, U_i);
        }
        System.arraycopy(U_r, 0, dest, offset, hLen);
    }

    private void xor(byte[] dest, byte[] src) {
        for (int i2 = 0; i2 < dest.length; ++i2) {
            int n = i2;
            dest[n] = (byte)(dest[n] ^ src[i2]);
        }
    }

    protected void INT(byte[] dest, int offset, int i2) {
        dest[offset] = (byte)(i2 / 0x1000000);
        dest[offset + 1] = (byte)(i2 / 65536);
        dest[offset + 2] = (byte)(i2 / 256);
        dest[offset + 3] = (byte)i2;
    }

    public PBKDF2Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(PBKDF2Parameters parameters) {
        this.parameters = parameters;
    }

    public void setPseudoRandomFunction(PRF prf) {
        this.prf = prf;
    }
}

