/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.utils;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class MaterialDrawingUtils {
    public static Graphics getAliasedGraphics(Graphics g2) {
        Map hints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (hints != null) {
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
            hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT);
            hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Graphics2D g2d = (Graphics2D)g2;
            g2d.addRenderingHints(hints);
            return g2d;
        }
        return g2;
    }

    public static void drawCircle(Graphics g2, int x, int y, int radius, Color color) {
        g2 = MaterialDrawingUtils.getAliasedGraphics(g2);
        Color shadowColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 65);
        g2.setColor(shadowColor);
        g2.fillOval(x, y, radius * 2, radius * 2);
    }

    public static void drawString(JComponent c, Graphics g2, String text, Rectangle textRect, int mnemonicIndex, int shiftOffset, Color color) {
        g2 = MaterialDrawingUtils.getAliasedGraphics(g2);
        FontMetrics fm = g2.getFontMetrics(c.getFont());
        g2.setColor(color);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2, text, mnemonicIndex, textRect.x + shiftOffset, textRect.y + fm.getAscent() + shiftOffset);
    }

    static {
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        System.setProperty("sun.java2d.xrender", "true");
    }
}

