/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retrofit;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.core.StopWatch;
import io.github.resilience4j.retrofit.internal.DecoratedCall;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public interface RetrofitCircuitBreaker {
    public static <T> Call<T> decorateCall(CircuitBreaker circuitBreaker, Call<T> call, Predicate<Response> responseSuccess) {
        return new CircuitBreakingCall<T>(call, circuitBreaker, responseSuccess);
    }

    public static class CircuitBreakingCall<T>
    extends DecoratedCall<T> {
        private final Call<T> call;
        private final CircuitBreaker circuitBreaker;
        private final Predicate<Response> responseSuccess;

        public CircuitBreakingCall(Call<T> call, CircuitBreaker circuitBreaker, Predicate<Response> responseSuccess) {
            super(call);
            this.call = call;
            this.circuitBreaker = circuitBreaker;
            this.responseSuccess = responseSuccess;
        }

        @Override
        public void enqueue(final Callback<T> callback) {
            try {
                this.circuitBreaker.acquirePermission();
            }
            catch (CallNotPermittedException cb) {
                callback.onFailure(this.call, cb);
                return;
            }
            final long start = System.nanoTime();
            this.call.enqueue(new Callback<T>(){

                @Override
                public void onResponse(Call<T> call, Response<T> response) {
                    if (responseSuccess.test(response)) {
                        circuitBreaker.onResult(System.nanoTime() - start, TimeUnit.NANOSECONDS, response);
                    } else {
                        Throwable throwable = new Throwable("Response error: HTTP " + response.code() + " - " + response.message());
                        circuitBreaker.onError(System.nanoTime() - start, TimeUnit.NANOSECONDS, throwable);
                    }
                    callback.onResponse(call, response);
                }

                @Override
                public void onFailure(Call<T> call, Throwable t) {
                    if (call.isCanceled()) {
                        circuitBreaker.releasePermission();
                    } else {
                        circuitBreaker.onError(System.nanoTime() - start, TimeUnit.NANOSECONDS, t);
                    }
                    callback.onFailure(call, t);
                }
            });
        }

        @Override
        public Response<T> execute() throws IOException {
            this.circuitBreaker.acquirePermission();
            StopWatch stopWatch = StopWatch.start();
            try {
                Response<T> response = this.call.execute();
                if (this.responseSuccess.test(response)) {
                    this.circuitBreaker.onResult(stopWatch.stop().toNanos(), TimeUnit.NANOSECONDS, response);
                } else {
                    Throwable throwable = new Throwable("Response error: HTTP " + response.code() + " - " + response.message());
                    this.circuitBreaker.onError(stopWatch.stop().toNanos(), TimeUnit.NANOSECONDS, throwable);
                }
                return response;
            }
            catch (Exception exception) {
                if (this.call.isCanceled()) {
                    this.circuitBreaker.releasePermission();
                } else {
                    this.circuitBreaker.onError(stopWatch.stop().toNanos(), TimeUnit.NANOSECONDS, exception);
                }
                throw exception;
            }
        }

        @Override
        public Call<T> clone() {
            return new CircuitBreakingCall<T>(this.call.clone(), this.circuitBreaker, this.responseSuccess);
        }
    }
}

