/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.i18n.LocalizationManager;
import de.griefed.versionchecker.github.GitHubChecker;
import de.griefed.versionchecker.gitlab.GitLabChecker;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateChecker {
    private static final Logger LOG = LogManager.getLogger(UpdateChecker.class);
    private final LocalizationManager LOCALIZATIONMANAGER;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private GitHubChecker GITHUB;
    private GitLabChecker GITGRIEFED;
    private GitLabChecker GITLAB;

    @Autowired
    public UpdateChecker(LocalizationManager injectedLocalizationManager, ApplicationProperties injectedApplicationProperties) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties == null ? new ApplicationProperties() : injectedApplicationProperties;
        this.LOCALIZATIONMANAGER = injectedLocalizationManager == null ? new LocalizationManager(this.APPLICATIONPROPERTIES) : injectedLocalizationManager;
        try {
            this.GITHUB = new GitHubChecker("Griefed/ServerPackCreator").refresh();
        }
        catch (IOException ex) {
            LOG.error("The GitHub user/repository you set resulted in a malformed URL.", (Throwable)ex);
            this.GITHUB = null;
        }
        try {
            this.GITLAB = new GitLabChecker("https://gitlab.com/api/v4/projects/32677538/releases").refresh();
        }
        catch (IOException ex) {
            LOG.error("The GitLab URL you set resulted in a malformed URL.", (Throwable)ex);
            this.GITLAB = null;
        }
        try {
            this.GITGRIEFED = new GitLabChecker("https://git.griefed.de/api/v4/projects/63/releases").refresh();
        }
        catch (IOException ex) {
            LOG.error("The GitGriefed URL you set resulted in a malformed URL.", (Throwable)ex);
            this.GITGRIEFED = null;
        }
    }

    public UpdateChecker refresh() {
        try {
            this.GITHUB.refresh();
        }
        catch (Exception ex) {
            LOG.error("Error refreshing GitHub.", (Throwable)ex);
            this.GITHUB = null;
        }
        try {
            this.GITLAB.refresh();
        }
        catch (Exception ex) {
            LOG.error("Error refreshing GitLab.", (Throwable)ex);
            this.GITLAB = null;
        }
        try {
            this.GITGRIEFED.refresh();
        }
        catch (Exception ex) {
            LOG.error("Error refreshing GitGriefed.", (Throwable)ex);
            this.GITGRIEFED = null;
        }
        return this;
    }

    public GitHubChecker getGitHub() {
        return this.GITHUB;
    }

    public GitLabChecker getGitLab() {
        return this.GITLAB;
    }

    public GitLabChecker getGitGriefed() {
        return this.GITGRIEFED;
    }

    public String checkForUpdate(@NotNull String version, Boolean preReleaseCheck) {
        if (version.equalsIgnoreCase("dev")) {
            return this.LOCALIZATIONMANAGER.getLocalizedString("updates.log.info.none");
        }
        String updater = null;
        if (this.GITHUB != null) {
            LOG.debug("Checking GitHub for updates...");
            updater = this.GITHUB.checkForUpdate(version, preReleaseCheck);
        }
        if (this.GITGRIEFED != null && updater != null) {
            LOG.debug("Checking GitGriefed for updates...");
            if (!updater.contains(";") && this.GITGRIEFED.checkForUpdate(version, preReleaseCheck).contains(";")) {
                updater = this.GITGRIEFED.checkForUpdate(version, preReleaseCheck);
            } else if (updater.contains(";") && this.GITGRIEFED.checkForUpdate(updater.split(";")[0], preReleaseCheck).contains(";")) {
                updater = this.GITGRIEFED.checkForUpdate(updater.split(";")[0], preReleaseCheck);
            }
        }
        if (this.GITLAB != null && updater != null) {
            LOG.debug("Checking GitLab for updates...");
            if (!updater.contains(";") && this.GITLAB.checkForUpdate(version, preReleaseCheck).contains(";")) {
                updater = this.GITLAB.checkForUpdate(version, preReleaseCheck);
            } else if (updater.contains(";") && this.GITLAB.checkForUpdate(updater.split(";")[0], preReleaseCheck).contains(";")) {
                updater = this.GITLAB.checkForUpdate(updater.split(";")[0], preReleaseCheck);
            }
        }
        LOG.debug("Received " + updater + " from UpdateChecker.");
        if (updater == null) {
            return this.LOCALIZATIONMANAGER.getLocalizedString("updates.log.info.none");
        }
        return updater;
    }
}

