/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemUtilities {
    private static final Logger LOG = LogManager.getLogger(SystemUtilities.class);
    private final List<String> DRIVES = new ArrayList<String>(Arrays.asList("A:", "B:", "C:", "D:", "E:", "F:", "G:", "H:", "I:", "J:", "K:", "L:", "M:", "N:", "O:", "P:", "Q:", "R:", "S:", "T:", "U:", "V:", "W:", "X:", "Y:", "Z:"));

    @Autowired
    public SystemUtilities() {
    }

    public String acquireJavaPathFromSystem() {
        LOG.debug("Acquiring path to Java installation from system properties...");
        String javaPath = "Couldn't acquire JavaPath";
        if (new File(System.getProperty("java.home")).exists() && !(javaPath = String.format("%s/bin/java", System.getProperty("java.home").replace("\\", "/"))).startsWith("/")) {
            for (String letter : this.DRIVES) {
                if (!javaPath.startsWith(letter)) continue;
                LOG.debug("We're running on Windows. Ensuring javaPath ends with .exe");
                javaPath = String.format("%s.exe", javaPath);
            }
        }
        return javaPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String fileDestination, URL downloadURL) {
        try {
            FileUtils.createParentDirectories(new File(fileDestination));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ReadableByteChannel readableByteChannel = null;
        OutputStream fileOutputStream = null;
        AbstractInterruptibleChannel fileChannel = null;
        try {
            readableByteChannel = Channels.newChannel(downloadURL.openStream());
            fileOutputStream = new FileOutputStream(fileDestination.replace("\\", "/"));
            fileChannel = ((FileOutputStream)fileOutputStream).getChannel();
            ((FileOutputStream)fileOutputStream).getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        catch (IOException ex) {
            LOG.error("An error occurred downloading " + fileDestination.replace("\\", "/") + ".", (Throwable)ex);
            FileUtils.deleteQuietly(new File(fileDestination.replace("\\", "/")));
        }
        finally {
            try {
                fileOutputStream.flush();
            }
            catch (Exception exception) {}
            try {
                ((FileOutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {}
            try {
                readableByteChannel.close();
            }
            catch (Exception exception) {}
            try {
                fileChannel.close();
            }
            catch (Exception exception) {}
        }
        return new File(fileDestination).exists();
    }

    public boolean replaceFile(File sourceFile, File destinationFile) throws IOException {
        if (sourceFile.exists() && destinationFile.delete()) {
            FileUtils.moveFile(sourceFile, destinationFile);
            return true;
        }
        LOG.error("Source file not found.");
        return false;
    }

    public void unzipArchive(String zipFile, String destinationDirectory) {
        LOG.info("Extracting ZIP-file: " + zipFile);
        try {
            new ZipFile(zipFile).extractAll(destinationDirectory);
        }
        catch (ZipException ex) {
            LOG.error("Error: There was an error extracting the archive " + zipFile, (Throwable)ex);
        }
    }
}

