/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities;

import de.griefed.serverpackcreator.Main;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.stereotype.Component;

@Component
public class JarUtilities {
    private static final Logger LOG = LogManager.getLogger(JarUtilities.class);

    public void copyFileFromJar(File fileToCopy) {
        if (!fileToCopy.exists()) {
            try {
                FileUtils.copyInputStreamToFile(Objects.requireNonNull(Main.class.getResourceAsStream("/" + fileToCopy.getName())), fileToCopy);
            }
            catch (IOException ex) {
                LOG.error("Error creating file: " + fileToCopy, (Throwable)ex);
            }
        }
    }

    public ApplicationHome getApplicationHomeForClass(Class<?> classToRetrieveHomeFor) {
        return new ApplicationHome(classToRetrieveHomeFor);
    }

    public HashMap<String, String> systemInformation(final ApplicationHome applicationHome) {
        return new HashMap<String, String>(){
            {
                try {
                    this.put("jarPath", applicationHome.getSource().toString().replace("\\", "/"));
                }
                catch (Exception ex) {
                    this.put("jarPath", applicationHome.getDir().toString().replace("\\", "/"));
                }
                try {
                    this.put("jarName", applicationHome.getSource().toString().replace("\\", "/").substring(applicationHome.getSource().toString().replace("\\", "/").lastIndexOf("/") + 1));
                }
                catch (Exception ex) {
                    this.put("jarName", applicationHome.getDir().toString().replace("\\", "/").substring(applicationHome.getDir().toString().replace("\\", "/").lastIndexOf("/") + 1));
                }
                this.put("javaVersion", System.getProperty("java.version"));
                this.put("osArch", System.getProperty("os.arch"));
                this.put("osName", System.getProperty("os.name"));
                this.put("osVersion", System.getProperty("os.version"));
            }
        };
    }

    private JarFile retrieveJarFromClass(Class<?> classToRetrieveJarFor) throws IOException {
        return new JarFile(new File(new ApplicationHome(classToRetrieveJarFor).getSource().toString().replace("\\", "/")));
    }

    public void copyFolderFromJar(String jarPath, String directoryToCopy, String destinationDirectory, String jarDirectoryPrefix, String fileEnding) throws IOException {
        LOG.debug("jarPath: " + jarPath);
        if (jarPath.endsWith("main")) {
            this.copyFolderFromJar(directoryToCopy, destinationDirectory, fileEnding);
        } else {
            this.copyFolderFromJar(this.retrieveJarFromClass(Main.class), directoryToCopy, destinationDirectory, jarDirectoryPrefix, fileEnding);
        }
    }

    private void copyFolderFromJar(JarFile jarToCopyFrom, String directoryToCopy, String destinationDirectory, String jarDirectoryPrefix, String fileEnding) throws IOException {
        Enumeration<JarEntry> entries = jarToCopyFrom.entries();
        while (entries.hasMoreElements()) {
            File destination;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.replace(jarDirectoryPrefix, "").startsWith(directoryToCopy + "/") || entry.isDirectory() || !entryName.endsWith(fileEnding) || (destination = new File(destinationDirectory + "/" + entryName.substring(entryName.replace("\\", "/").lastIndexOf("/") + 1))).exists()) continue;
            File parent = destination.getParentFile();
            if (parent != null && parent.mkdirs()) {
                LOG.debug("Created directory " + parent + ".");
            }
            FileOutputStream fileOutputStream = null;
            InputStream inputStream2 = null;
            try {
                fileOutputStream = new FileOutputStream(destination);
            }
            catch (FileNotFoundException ex) {
                LOG.error("File " + destination + " not found.", (Throwable)ex);
            }
            try {
                inputStream2 = jarToCopyFrom.getInputStream(entry);
            }
            catch (IOException ex) {
                LOG.error("Couldn't acquire input stream for entry " + entryName + ".", (Throwable)ex);
            }
            try {
                byte[] bytes = new byte[8192];
                int length = 0;
                while ((length = inputStream2.read(bytes)) > 0) {
                    fileOutputStream.write(bytes, 0, length);
                }
            }
            catch (IOException ex) {
                throw new IOException("Couldn't copy asset " + entryName + " from JAR-file.", ex);
            }
            finally {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void copyFolderFromJar(String source2, String destination, final String fileEnding) {
        ArrayList<String> filesFromJar;
        block6: {
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.toString().endsWith(fileEnding);
                }
            };
            filesFromJar = new ArrayList<String>(1000);
            try {
                File[] files = new File(Objects.requireNonNull(Main.class.getResource(source2)).toURI()).listFiles(fileFilter);
                assert (files != null);
                for (File value : files) {
                    String file2 = value.toString().replace("\\", "/");
                    filesFromJar.add(file2.substring(file2.lastIndexOf("/") + 1));
                }
                filesFromJar.forEach(System.out::println);
            }
            catch (URISyntaxException ex) {
                LOG.error("Error retrieving file list from JAR.", (Throwable)ex);
            }
            try {
                Files.createDirectory(Paths.get(destination, new String[0]), new FileAttribute[0]);
            }
            catch (IOException ex) {
                if (ex.toString().startsWith("java.nio.file.FileAlreadyExistsException")) break block6;
                LOG.error("Error creating language directory.", (Throwable)ex);
            }
        }
        filesFromJar.forEach(file -> {
            if (!new File(destination + "/" + file).exists()) {
                try (InputStream inputStream2 = Main.class.getResourceAsStream(source2 + "/" + file);){
                    assert (inputStream2 != null);
                    FileUtils.copyInputStreamToFile(inputStream2, new File(destination + "/" + file));
                }
                catch (IOException ex) {
                    LOG.error("Error extracting files.", (Throwable)ex);
                }
            }
        });
    }
}

