/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.DefaultFiles;
import de.griefed.serverpackcreator.Main;
import de.griefed.serverpackcreator.utilities.misc.Generated;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated
@Component
public class FileWatcher {
    private static final Logger LOG = LogManager.getLogger(FileWatcher.class);
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final DefaultFiles DEFAULTFILES;

    @Autowired
    public FileWatcher(ApplicationProperties injectedApplicationProperties, DefaultFiles injectedDefaultFiles) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.DEFAULTFILES = injectedDefaultFiles;
        FileAlterationObserver FILEALTERATIONOBSERVER = new FileAlterationObserver(new File("."));
        FileAlterationListener FILEALTERATIONLISTENER = new FileAlterationListener(){

            @Override
            public void onStart(FileAlterationObserver observer) {
            }

            @Override
            public void onDirectoryCreate(File directory) {
            }

            @Override
            public void onDirectoryChange(File directory) {
            }

            @Override
            public void onDirectoryDelete(File directory) {
            }

            @Override
            public void onFileCreate(File file) {
            }

            @Override
            public void onFileChange(File file) {
            }

            @Override
            public void onFileDelete(File file) {
                if (!file.toString().replace("\\", "/").startsWith("./server-packs") && !file.toString().replace("\\", "/").startsWith("./work/modpacks")) {
                    if (this.check(file, ((FileWatcher)FileWatcher.this).APPLICATIONPROPERTIES.FILE_SERVERPACKCREATOR_PROPERTIES)) {
                        this.createFile(((FileWatcher)FileWatcher.this).APPLICATIONPROPERTIES.FILE_SERVERPACKCREATOR_PROPERTIES);
                        FileWatcher.this.APPLICATIONPROPERTIES.reload();
                        LOG.info("Restored serverpackcreator.properties and loaded defaults.");
                    } else if (this.check(file, ((FileWatcher)FileWatcher.this).APPLICATIONPROPERTIES.FILE_SERVER_PROPERTIES)) {
                        FileWatcher.this.DEFAULTFILES.checkForFile(((FileWatcher)FileWatcher.this).APPLICATIONPROPERTIES.FILE_SERVER_PROPERTIES);
                        LOG.info("Restored default server.properties.");
                    } else if (this.check(file, ((FileWatcher)FileWatcher.this).APPLICATIONPROPERTIES.FILE_SERVER_ICON)) {
                        FileWatcher.this.DEFAULTFILES.checkForFile(((FileWatcher)FileWatcher.this).APPLICATIONPROPERTIES.FILE_SERVER_ICON);
                        LOG.info("Restored default server-icon.png.");
                    }
                }
            }

            @Override
            public void onStop(FileAlterationObserver observer) {
            }

            private boolean check(File watched, File toCreate) {
                return watched.toString().replace("\\", "/").substring(watched.toString().replace("\\", "/").lastIndexOf("/") + 1).equals(toCreate.toString());
            }

            private void createFile(File toCreate) {
                try {
                    FileUtils.copyInputStreamToFile(Objects.requireNonNull(Main.class.getResourceAsStream("/" + toCreate.getName())), toCreate);
                }
                catch (IOException ex) {
                    LOG.error("Error creating file: " + toCreate, (Throwable)ex);
                }
            }
        };
        FILEALTERATIONOBSERVER.addListener(FILEALTERATIONLISTENER);
        FileAlterationMonitor FILEALTERATIONMONITOR = new FileAlterationMonitor(1000L);
        FILEALTERATIONMONITOR.addObserver(FILEALTERATIONOBSERVER);
        try {
            FILEALTERATIONMONITOR.start();
        }
        catch (Exception ex) {
            LOG.error("Error starting the FileWatcher Monitor.", (Throwable)ex);
        }
    }
}

